% Example Poles and zeros in s-domain
% Course: Analog and Digital Filter Design
% Lecture: Transfer function
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/01/28$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

A = [1 0.4 1];
B = [0.2 0.3 1];
z = roots(B);
p = roots(A);

plot(real(z),imag(z),'ro',real(p),imag(p),'bx')
axis([-1 0.1 -2.5 2.5])
xlabel('real part')
ylabel('imaginary part')
legend('zeros','poles')
