% Example Frequency response in s-domain
% Course: Analog and Digital Filter Design
% Lecture: Transfer function
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/01/28$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

A = [1 0.4 1];
B = [0.2 0.3 1];
w = 0.1:0.01:10;
H = freqs(B,A,w);
M = abs(H);
P = angle(H);
subplot(2,1,1); 
loglog(w,M); grid;
ylabel('Magnitude');
title('H = freqs(B,A,w)');
subplot(2,1,2); 
semilogx(w,P); grid;
ylabel('Phase (rad)');
xlabel('\omega');

s = i*w;
H = polyval(B,s)./polyval(A,s);
figure
M = abs(H);
P = angle(H);
subplot(2,1,1);
plot(w,M); grid;
ylabel('Magnitude');
title('H = polyval(B,s)./polyval(A,s)');
subplot(2,1,2); 
plot(w,P*180/pi); grid;
ylabel('Phase (degrees)');
xlabel('\omega');
