% Example FFT
% Course: Analog and Digital Filter Design
% Lecture: Review Transforms
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/01/22$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

n = -5:24;
x = exp(-0.2*n).*(n>0);

subplot(2,2,[1 3]);
stem(n,x,'b');
title('\bf x_{(n)} = ifft(X_{(k)})')
xlabel('n');
ylabel('x_{(n)}');

f = fft(x);

subplot(2,2,2);
stem(abs(fft(x)));
title('\bf X_{(k)} = fft(x_{(n)})')
ylabel('|X_{(k)}|');

subplot(2,2,4);
stem(angle(fft(x)));
xlabel('k');
ylabel('arg(X_{(k)})');
