% Example response of continuous-time system by convolution integral
% Course: Analog and Digital Filter Design
% Lecture: Review Systems
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/01/16$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

h = inline('exp(-t).*(t>0)', 't');
x = inline('sin(t).*(t>0)', 't');
u = inline('exp(-(t-tau)).*((t-tau)>0).*sin(tau).*(tau>0)', 'tau', 't');
r = inline('0.5*(exp(-t) - cos(t) + sin(t)).*(t>0)', 't');

t1 = 0;
t2 = 6;
TR = [t1, t2];

subplot(2,1,1)
fplot(h, TR, 2e-3, 1, ':b')
hold on
fplot(x, TR, 2e-3, 1, '-r')
hold off
legend('impulse response', 'input')

ti = t1:0.2:t2;
y = [];

for i = 1:length(ti)
  y = [y, quad(u,0,ti(i),1e-8,0,ti(i))];
end;

subplot(2,1,2)
plot(ti, y);
xlabel('t')
ylabel('forced response')

hold on
fplot(r, TR, 2e-2, 1, 'or')
legend('numerical', 'exact')
hold off