% Example continuous-time (analog) sinusoidal signal
% with adaptive step control to produce a representative graph
% Course: Analog and Digital Filter Design
% Lecture: Review Signals
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2004 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2004/11/29$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc
set(0,'DefaultLineLineWidth',2)

Xs  = 1.8;
fs = 10; 
fi = pi/3; 

analogSignal = inline('Xs*sin(2*pi*fs*t + fi)', 't', 'Xs', 'fs', 'fi');

t1 = -0.1;
t2 = 0.2;
timeRange = [t1, t2];

fplot(analogSignal, timeRange, 2e-3, 1, '-', Xs, fs, fi)

xlabel('t','FontSize',14)
ylabel('x_s','FontSize',14)
title('x_s(t) = X_s sin(2 \pi f_s t + \phi_s)','FontSize',14)
xtick = [-0.1 0 0.1 0.2]; set(gca,'XTick',xtick)
ytick = [-2 0 2]; set(gca,'YTick',ytick)
