% Example unit impulse sequence
% Course: Analog and Digital Filter Design
% Lecture: Review Signals
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2004 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2004/11/29$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc
set(0,'DefaultLineLineWidth',2)

k1 = -5;
k2 = 10;
k = k1:k2;

x = (k==0);

stem(k, x)

set(gca,'FontSize',16)
xlabel('k')
ylabel('\delta_k')
title('Unit impulse sequence')
axis([k1 k2 -0.1 1.1])