% Example causal signal
% Course: Analog and Digital Filter Design
% Lecture: Review Signals
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2004 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2004/11/29$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2


clear all, close all, clc
set(0,'DefaultLineLineWidth',3)

B = 0.02;
a = 0.1;
f = 0.53;
phi = 3*pi/4;
t = -5:0.05:10;
x = B^a*exp(-a*t).*sin(...
    2*pi*f*t+phi);
xu = x.*(t>0);
u = (t>0);
plot(t,x,t,u,t,xu)
set(gca,'FontSize',16)
ylabel('x(t)')
xlabel('t (s)')
text(0,1.2,'u(t)','FontSize',16)
text(-4,-1.1,'x(t)','FontSize',16)
text(5,-.6,'x(t)*u(t)','FontSize',16)
axis([t(1) t(end) -1.5 1.5])