%%
%							----------------------------------
%							|Copyright : Kopsinis Yannis     |
%							|            Pikrakis Aggelos    |
%							|            Basilas Stratos     |
%							|           -------------------- |
%							|           Dept. of Informatics |
%							|           University of Athens |
%							----------------------------------
tsip=exist('tsipikoulia');
if tsip==0
   startdemo;
   break
end

clear all;
close all hidden;
tsipikoulia=1;
load setmat

info={'The purpose of this demo is to help the student to grasp the' 
'basics of a speech recognition task, in the context of an isolated' 
'word recognition  example.     '
'We are concerned with the recognition of the spoken words' 
'"kiss" and "love". For each one of these words, a reference '
'pattern is provided. Additionally, a set of test utterances has' 
'been generated.    '
'The user may choose a test word, which is subsequently matched' 
'against each one of the reference patterns using dynamic time' 
'warping techniques.  '
'To run the demo the student must have access to the Image and '
'Signal Processing Toolbox of the MATLAB.'
'      '
'To start  this demo click on the OK button of this help window,' 
'and then click on the Load Signal menu to load the pattern that' 
'you want to classify                         '};
   
help1={'click on the "Load Signal" menu to load the word '
   'to be recognized.     '};
   

help2={'This is the graph of the unknown spoken word versus time. If' 
'you have a sound card, click on the "Play Word" button to listen'
'to the word.'
'In order to proceed, click on the "Feature Generation" menu .'};


help3={'On the upper half of the screen you can still see the time plot of' 
'the word to be recognized. The lower half shows the' 
'corresponding spectrogram, i.e., the Short Time Fourier' 
'Transform of the word. You can modify the parameters of the' 
'spectrogram via the menus on the right side of the screen.'
'"window" stands for the length of the moving window. "overlap"' 
'stands for the overlap between successive windows. "LF" stands' 
'for the index of the lowest Fourier coefficient that you want to' 
'be included in the feature vectors "RF" stands for the index of' 
'the highest Fourier coefficient that you want to be included in' 
'the feature vectors.'
'In order to proceed, click on the "Load reference set" menu'};


help4={'This figure shows the spectrograms for  each of the two spoken' 
'words, comprising the reference set.              '
'The parameters of the spectrogram have been assigned ac-'
'cording to the values set in the previous step of this demo.'
'You can listen to anyone of the words of the reference set by' 
'clicking on the "Play Reference" button on the right side of the'
'corresponding spectrogram.'
'We are now ready to enter into the last stage of the recognition'
'task. The unknown word will be matched against each one of the' 
'words in the reference set. '
'Click on the "OK" button and then click on the "Recognition"' 
'menu'};

help5={'You can still see the time plot and spectrogram of the word to be' 
'recognized.'
'You can choose which local constratints to use for the matching' 
'operation, if you click on the "Recognition" menu. Choose either' 
'the Itakura or the Sakoe-Chiba local constraints and the' 
'matching operation will take place'};


help6={'This figure presents the results of the recognizer. A best path and' 
'a corresponding matching cost have been generated for each one' 
'of the words of the reference set. The word corresponding to the' 
'lowest matching cost is the one that best matches the unknown' 
'word. If you click on the "OK" button, you will be able to repeat' 
'this last stage of the recognition task.'};


help7=help6;

help8={'You can choose other local constraints under the recognition' 
'menu, or click on the Reset all button to start from the' 
'beginning'};

helpstr=help1;
global figsound 

figsound=figure('units','normalized','pos',[0 0 1 0.93],'color',[0.7843,0.7020,0.4745],...
   'menubar','none','name','RECOGNITION OF ISOLATED SPOKEN WORDS');

figsound2=figure('name','Reference Set','color',[0.7843,0.5020,0.4745],'visible','off',...
   'menubar','none','numbertitle','off');
hfig2=uimenu(figsound2,'label','New Help','call',[...
      'helpdlg(helpstr);set(hfig2,''label'',''Help'');set(helpsign2,''visible'',''off'');']);
oksound2=uicontrol('parent',figsound2,'style','push','units','norm',...
   'pos',[0.8 0.45 0.1 0.05],'string','OK','call',[...
      'helpstr=help5;',...
      'set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'set(figsound2,''visible'',''off'');',...
      'set(recmenu,''enable'',''on'');',...
      'gcf=figure(figsound);']);


figsound3=figure('name','Recognition Results','color',[0.7843,0.5020,0.4745],'visible','off',...
   'menubar','none','numbertitle','off');
hfig3=uimenu(figsound3,'label','New Help','call',[...
      'helpdlg(helpstr);set(hfig3,''label'',''Help'');set(helpsign3,''visible'',''off'');']);

oksound3=uicontrol('parent',figsound3,'style','push','units','norm',...
   'pos',[0.8 0.45 0.1 0.05],'string','OK','call',[...
      'helpstr=help8;',...
      'set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'set(figsound3,''visible'',''off'');',...
      'gcf=figure(figsound);']);

fighelp=figure('name','Info','windowstyle','modal',...
   'units','norm','pos',[0.225 0.2 0.55 0.5],'menubar','none',...
   'numbertitle','off');
helpstring=uicontrol(fighelp,'style','listbox','units','norm',...
   'back','white','pos',[0.05 0.15 0.9 0.82],'string',info);
okhelp=uicontrol(fighelp,'style','push','string','OK',...
   'pos',[0.4 0.01 0.2 0.1],'units','norm','call',[...
      'set(fighelp,''visible'',''off'');',...
      'gcf=figure(figsound);set(helpsign,''visible'',''on'');']);


w=512;
overlap=100;
lf=1;
rf=100;
cl=5;
%%%%%%%%%%%%%%%%%%%%%%%% ANALYSE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

helpsign=uicontrol(figsound,...
   'style','text',...
   'string',{'Click on the','New Help','Menu'},...
   'units','norm',...
   'fontweight','demi',...
   'fore','r',...
   'pos',[0.8 0.8 0.2 0.15],...
   'back',[0.7843,0.7020,0.4745],...
   'visible','off');
hl=helpsign;

set(hl,'fontsize',[10]);

   
waitcontrol=uicontrol(figsound,...
   'style','text',...
   'string','please wait ...',...
   'units','norm',...
   'fontsize',[12],...
   'fontangle','italic',...
   'fore','b',...
   'pos',[0.3 0.93 0.3 0.05],...
   'back',[0.7843,0.7020,0.4745],...
   'visible','off');

helpsign2=uicontrol(figsound2,...
   'style','text',...
   'string',{'Click on the','New Help','Menu'},...
   'units','norm',...
   'fontweight','demi',...
   'fore','r',...
   'pos',[0.8 0.8 0.2 0.15],...
   'back',[0.7843,0.5020,0.4745],...
   'visible','on');

hl2=helpsign2;

set(hl2,'fontsize',[10]);
waitcontrol2=uicontrol(figsound2,...
   'style','text',...
   'string','please wait ...',...
   'units','norm',...
   'fontsize',[12],...
   'fontangle','italic',...
   'fore','b',...
   'pos',[0.3 0.93 0.3 0.05],...
   'back',[0.7843,0.5020,0.4745],...
   'visible','off');

helpsign3=uicontrol(figsound3,...
   'style','text',...
   'string',{'Click on the','New Help','Menu'},...
   'units','norm',...
   'fontweight','demi',...
   'fore','r',...
   'pos',[0.8 0.8 0.2 0.15],...
   'back',[0.7843,0.5020,0.4745],...
   'visible','on');
hl3=helpsign3;

set(hl3,'fontsize',[10]);
anlcontrol=[];
wcntrl=uicontrol(figsound,...
                 'style','pop',...
                 'visible','on',...
                 'enable','off',...
                 'units','norm',...
                 'back',[0.7843,0.7020,0.4745],...
                 'string','window=512|window=256|window=512|window=1024|window=2048',...
                 'userdata',[512 ;256 ;512 ;1024;2048],...
                 'position',[0.82 0.52 0.15 0.01],...
                 'call',[...
                         'set(waitcontrol,''visible'',''on'');drawnow;',...
                         'wtemp=get(wcntrl,''userdata'');',...
                         'w=wtemp(get(wcntrl,''value''));',...
                         'if w==256;set(ovlapcntrl,''string'',''overlap=100|overlap=50|overlap=100|overlap=200'');',...
                         'set(ovlapcntrl,''userdata'',[100;50 ;100;200]);',...
                         'else;set(ovlapcntrl,''string'',''overlap=100|overlap=50|overlap=100|overlap=200|overlap=300'');',...
                         'set(ovlapcntrl,''userdata'',[100;50 ;100;200;300]);end;',...
                         'gcf=figure(figsound);',...
                         'subplot(2,1,1);plot(0:1/Fs:(1/Fs)*(length(signal)-1),signal,''r'');',...
                         'set(gca,''pos'',[0.1 0.53 0.68 0.35],''xcolor'',''k'',''ycolor'',''k'');',...
                         'subplot(2,1,2);[b,f,t]=specgram(signal,w,Fs,hamming(w),overlap);',...
                         'abs_b=abs(b(lf:rf,:));f_=f(lf:rf);',...
                         'imagesc(t,f(lf:rf),abs_b);',...
                         'ylabel(''Hz'');',...
                         'set(gca,''pos'',[0.1 0.1 0.68 0.35],''xcolor'',''k'',''ycolor'',''k'');',...
                         'set(waitcontrol,''visible'',''off'');drawnow;']);

anlcontrol=[anlcontrol,wcntrl];

ovlapcntrl=uicontrol(figsound,...
                 'visible','on',...
                 'back',[0.7883,0.7020,0.4745],...
                 'style','pop',...
                 'enable','off',...
                 'units','norm',...
                 'string','overlap=100|overlap=50|overlap=100|overlap=200|overlap=300',...
                 'userdata',[100;50 ;100;200;300],...
                 'position',[0.82 0.47 0.15 0.01],...
                 'call',[...
                         'set(waitcontrol,''visible'',''on'');drawnow;',...
                         'ovtemp=get(ovlapcntrl,''userdata'');',...
                         'overlap=ovtemp(get(ovlapcntrl,''value''));',...
                         'if overlap==300;set(wcntrl,''string'',''window=512|window=512|window=1024|window=2048'');',...
                         'set(wcntrl,''userdata'',[512 ;512 ;1024;2048]);',...
                         'else;set(wcntrl,''string'',''window=512|window=256|window=512|window=1024|window=2048'');',...
                         'set(wcntrl,''userdata'',[512 ;256 ;512 ;1024;2048]);end;',...
                         'gcf=figure(figsound);',...
                         'subplot(2,1,1);plot(0:1/Fs:(1/Fs)*(length(signal)-1),signal,''r'');',...
                         'set(gca,''pos'',[0.1 0.53 0.68 0.35],''xcolor'',''k'',''ycolor'',''k'');',...
                         'subplot(2,1,2);[b,f,t]=specgram(signal,w,Fs,hamming(w),overlap);',...
                         'abs_b=abs(b(lf:rf,:));f_=f(lf:rf);',...
                         'imagesc(t,f(lf:rf),abs_b);',...
                         'ylabel(''Hz'');',...                         
                         'set(gca,''pos'',[0.1 0.1 0.68 0.35],''xcolor'',''k'',''ycolor'',''k'');',...
                         'set(waitcontrol,''visible'',''off'');drawnow;']);

anlcontrol=[anlcontrol,ovlapcntrl];

lfcntrl=uicontrol(figsound,...
                 'visible','on',...
                 'back',[0.7843,0.7020,0.4745],...
                 'enable','off',...
                 'style','pop',...
                 'units','norm',...
                 'string','LF=1|LF=3|LF=10|LF=20',...
                 'userdata',[1 ;3 ;10;20],...
                 'position',[0.82 0.42 0.15 0.01],...
                 'call',[...
                         'set(waitcontrol,''visible'',''on'');drawnow;',...
                         'lftemp=get(lfcntrl,''userdata'');',...
                         'lf=lftemp(get(lfcntrl,''value''));',...
                         'gcf=figure(figsound);',...
                         'subplot(2,1,1);plot(0:1/Fs:(1/Fs)*(length(signal)-1),signal,''r'');',...
                         'set(gca,''pos'',[0.1 0.53 0.68 0.35],''xcolor'',''k'',''ycolor'',''k'');',...
                         'subplot(2,1,2);[b,f,t]=specgram(signal,w,Fs,hamming(w),overlap);',...
                         'abs_b=abs(b(lf:rf,:));f_=f(lf:rf);',...
                         'imagesc(t,f(lf:rf),abs_b);',...
                         'ylabel(''Hz'');',...                         
                         'set(gca,''pos'',[0.1 0.1 0.68 0.35],''xcolor'',''k'',''ycolor'',''k'');',...
                         'set(waitcontrol,''visible'',''off'');drawnow;']);

anlcontrol=[anlcontrol,lfcntrl];

rfcntrl=uicontrol(figsound,...
                 'visible','on',...
                 'back',[0.7843,0.7020,0.4845],...
                 'style','pop',...
                 'enable','off',...
                 'units','norm',...
                 'string','RF=100|RF=50|RF=70|RF=100|RF=150|RF=200|RF=250|RF=300',...
                 'userdata',[100 ;50 ;70 ;100;150;200;250;300],...
                 'position',[0.82 0.37 0.15 0.01],...
                 'call',[...
                         'set(waitcontrol,''visible'',''on'');drawnow;',...
                         'rftemp=get(rfcntrl,''userdata'');',...
                         'rf=rftemp(get(rfcntrl,''value''));',...
                         'gcf=figure(figsound);',...
                         'subplot(2,1,1);plot(0:1/Fs:(1/Fs)*(length(signal)-1),signal,''r'');',...
                         'set(gca,''pos'',[0.1 0.53 0.68 0.35],''xcolor'',''k'',''ycolor'',''k'');',...
                         'subplot(2,1,2);[b,f,t]=specgram(signal,w,Fs,hamming(w),overlap);',...
                         'abs_b=abs(b(lf:rf,:));f_=f(lf:rf);',...
                         'imagesc(t,f(lf:rf),abs_b);',...
                         'ylabel(''Hz'');',...
                         'set(gca,''pos'',[0.1 0.1 0.68 0.35],''xcolor'',''k'',''ycolor'',''k'');',...
                         'set(waitcontrol,''visible'',''off'');drawnow;']);
                   
anlcontrol=[anlcontrol,rfcntrl];
                   


playtest=uicontrol(figsound,...
                 'enable','off',...
                 'style','push',...
                 'units','norm',...
                 'string','Play Word',...
                 'position',[0.82 0.25 0.15 0.05],...
                 'call','sound(signal,Fs)');
                   

resetcntrl=uicontrol(figsound,...
                 'style','push',...
                 'units','norm',...
                 'string','Reset all',...
                 'position',[0.82 0.15 0.15 0.05],...
                 'call','soundrec');
                         

anmenu=uimenu(figsound,'label','Load signal','call',[...
               'newmenu=featextrmenu;',...
               '[filename,pathname]=uigetfile([cpath,''\spoken words\*.wav''],''Select a word'');',...
               'set(waitcontrol,''visible'',''on'');drawnow;',...
               '[signal,Fs]=wavread([pathname filename]);',...
               'gcf=figure(figsound);',...
               'plot(0:1/Fs:(1/Fs)*(length(signal)-1),signal,''r'');',...
               'set(gca,''pos'',[0.1 0.32 0.68 0.5],''xcolor'',''k'',''ycolor'',''k'');',...
               'set(waitcontrol,''visible'',''off'');drawnow;',...
               'set(anmenu,''enable'',''off'');',...
               'helpstr=help2;',...
               'set(h,''label'',''New Help'');',...
               'set(helpsign,''visible'',''on'');',...
               'if sound_card==1;set(playtest,''enable'',''on'');end;',...
               'set(featextrmenu,''enable'',''on'');']);
         
featextrmenu=uimenu(figsound,'label','feature generation','enable','off','call',[...
                      'newmenu=lrs;',...
                      'helpstr=help3;',...
                      'set(h,''label'',''New Help'');',...
                      'set(helpsign,''visible'',''on'');',...
                      'set(waitcontrol,''visible'',''on'');drawnow;',...
                      'gcf=figure(figsound);',...
                      'subplot(2,1,1);plot(0:1/Fs:(1/Fs)*(length(signal)-1),signal,''r'');',...
                      'set(featextrmenu,''enable'',''off'');'...
                      'set(gca,''pos'',[0.1 0.53 0.68 0.35],''xcolor'',''k'',''ycolor'',''k'');',...
                      'subplot(2,1,2);[b,f,t]=specgram(signal,w,Fs,hamming(w),overlap);',...
                      'abs_b=abs(b(lf:rf,:));f_=f(lf:rf);',...
                      'imagesc(t,f(lf:rf),abs_b);',...
                      'ylabel(''Hz'');',...
                      'set(gca,''pos'',[0.1 0.1 0.68 0.35],''xcolor'',''k'',''ycolor'',''k'');',...
                      'set(waitcontrol,''visible'',''off'');drawnow;',...
                      'set(featextrmenu,''enable'',''off'');',...
                      'set(anlcontrol,''enable'',''on'');',...
                      'set(lrs,''enable'',''on'');']);                
                
newmenu=anmenu;
pastmenu=featextrmenu;

lrs=uimenu(figsound,'label','Load reference set','enable','off','call',[...
      'newmenu=recmenu;',...
      'helpstr=help4;',...
      'set(featextrmenu,''enable'',''off'');',...                
      'set(figsound2,''visible'',''on'');',...
      'set(anlcontrol,''enable'',''off'');',...
      'set(waitcontrol,''visible'',''on'');drawnow;',...
      'set(waitcontrol2,''visible'',''on'');drawnow;',...
      '[ref1,Fsr1]=wavread([cpath,''\love_ref.wav'']);',...
      '[ref2,Fsr2]=wavread([cpath,''\kiss_ref.wav'']);',...
      'gcf=figure(figsound2);',...
      'subplot(2,1,1);[bref1,fref1,tref1]=specgram(ref1,w,Fsr1,hamming(w),overlap);title(''reference pattern 1'');',...
      'abs_b=abs(bref1(lf:rf,:));f_=f(lf:rf);',...
      'imagesc(tref1,f(lf:rf),abs_b);',... 
      'ylabel(''Hz'');',...
      'set(gca,''pos'',[0.1 0.53 0.6 0.35],''xcolor'',''k'',''ycolor'',''k'');',...
      'title(''"Love" reference word'');',...
      'subplot(2,1,2);[bref2,fref2,tref2]=specgram(ref2,w,Fsr2,hamming(w),overlap);title(''reference pattern 2'');',...
      'abs_b=abs(bref2(lf:rf,:));f_=f(lf:rf);',...
      'imagesc(tref2,f(lf:rf),abs_b);',...      
      'ylabel(''Hz'');',...
      'set(lrs,''enable'',''off'');',...
      'set(gca,''pos'',[0.1 0.08 0.6 0.35],''xcolor'',''k'',''ycolor'',''k'');',...
      'title(''"Kiss" reference word'');',...      
      'set(waitcontrol,''visible'',''off'');drawnow;',...
      'set(waitcontrol2,''visible'',''off'');drawnow;']);

      
play1=uicontrol(figsound2,...
   'style','push',...
   'units','norm',...
   'visible','on',...
   'string','play reference pat. 1',...
   'pos',[0.72 0.7 0.25 0.05],'call','sound(ref1,Fsr1)');
                

play2=uicontrol(figsound2,...
   'style','push',...
   'visible','on',...
   'units','norm',...
   'string','play reference pat. 2',...
   'pos',[0.72 0.25 0.25 0.05],'call','sound(ref2,Fsr2)');

if sound_card==0
   set(play1,'enable','off');
   set(play2,'enable','off');
end

%%%%%%%%%%%%%%%%%%%%%%%% end of analyse %%%%%%%%%%%%%%%%%%%%%%%%



%%%%%%%%%%%%%%%%%%%%%%%%  RECOGNITION  %%%%%%%%%%%%%%%%%%%%%%%%%%%%

costos1=uicontrol(figsound3,...
   'style','text',...
   'back',[0.7843,0.5020,0.4745],...
   'units','norm',...
   'string','cost 1:',...
   'pos',[0.72 0.7 0.25 0.05]);
                

costos2=uicontrol(figsound3,...
   'style','text',...
   'back',[0.7843,0.5020,0.4745],...
   'units','norm',...
   'string','cost 2:',...
   'pos',[0.72 0.25 0.25 0.05]);


recmenu=uimenu(figsound,'label','Recognition','enable','off');
itamenu=uimenu(recmenu,'label','Itakura','call',[...
      'set(waitcontrol,''visible'',''on'');drawnow;',...
      'gcf=figure(figsound3);',...
      'set(figsound2,''visible'',''off'');',...
      'helpstr=help6;',...
      'set(hfig3,''label'',''New Help'');',...
      'set(helpsign3,''visible'',''on'');',...
      'set(figsound3,''visible'',''on'');',...
      'ref1_temp=max(max(abs(bref1(lf:rf,:))));',...
      'ref2_temp=max(max(abs(bref2(lf:rf,:))));',...
      'test_temp=max(max(abs(b(lf:rf,:))));',...
      'N_type1=cost_fun(abs(bref1(lf:rf,:))/ref1_temp,abs(b(lf:rf,:))/test_temp);',...
      'N_type2=cost_fun(abs(bref2(lf:rf,:))/ref2_temp,abs(b(lf:rf,:))/test_temp);',...
      'subplot(2,1,1);[bp1,cost1]=itakura(N_type1,''r'');',...
      'set(gca,''pos'',[0.1 0.6 0.6 0.35],''xcolor'',''k'',''ycolor'',''k'');',...
      'ylabel(''Reference template Love'',''fontsize'',[8]);',...
      'title(''Best Path using Itakura local constraints'',''fontsize'',[8]);',...
      'subplot(2,1,2);[bp2,cost2]=itakura(N_type2,''r'');',...
      'set(gca,''pos'',[0.1 0.1 0.60 0.35],''xcolor'',''k'',''ycolor'',''k'');',...
      'ylabel(''Reference template Kiss'',''fontsize'',[8]);',...
      'title(''Best Path using Itakura local constraints'',''fontsize'',[8]);',...
      'set(costos1,''string'',[''"love" cost: '',num2str(cost1)]);',...
      'set(costos2,''string'',[''"kiss" cost: '',num2str(cost2)]);',...
      'set(waitcontrol,''visible'',''off'');drawnow;']);

                       
sacmenu=uimenu(recmenu,'label','Sakoe-Chiba','call',[...
      'set(waitcontrol,''visible'',''on'');drawnow;',...
      'gcf=figure(figsound3);',...
      'helpstr=help7;',...
      'set(hfig3,''label'',''New Help'');',...
      'set(helpsign3,''visible'',''on'');',...
      'set(figsound2,''visible'',''off'');',...
      'set(figsound3,''visible'',''on'');',...
      'ref1_temp=max(max(abs(bref1(lf:rf,:))));',...
      'ref2_temp=max(max(abs(bref2(lf:rf,:))));',...
      'test_temp=max(max(abs(b(lf:rf,:))));',...
      'N_type1=cost_fun(abs(bref1(lf:rf,:))/ref1_temp,abs(b(lf:rf,:))/test_temp);',...
      'N_type2=cost_fun(abs(bref2(lf:rf,:))/ref2_temp,abs(b(lf:rf,:))/test_temp);',...
      'subplot(2,1,1);[bp1,cost1]=sakoe(N_type1,''r'');',...
      'ylabel(''Reference template Love'',''fontsize'',[8]);',...
      'title(''Best Path using Sakoe-Chiba local constraints'',''fontsize'',[8]);',...
      'set(gca,''pos'',[0.1 0.6 0.6 0.35],''xcolor'',''k'',''ycolor'',''k'');',...
      'subplot(2,1,2);[bp2,cost2]=sakoe(N_type2,''r'');',...
      'ylabel(''Reference template Kiss'',''fontsize'',[8]);',...
      'title(''Best Path using Sakoe-Chiba local constraints'',''fontsize'',[8]);',...
      'set(costos1,''string'',[''cost 1: '',num2str(cost1)]);',...
      'set(costos2,''string'',[''cost 2: '',num2str(cost2)]);',...
      'set(gca,''pos'',[0.1 0.1 0.6 0.35],''xcolor'',''k'',''ycolor'',''k'');',...
      'set(waitcontrol,''visible'',''off'');drawnow']);
      
                              
h=uimenu(figsound,'label','New Help','call',[...
      'hlp=helpdlg(helpstr);set(h,''label'',''Help'');',...
      'set(helpsign,''visible'',''off'');']);
retu_main=uimenu(figsound,'label','back to main menu','fore','r','call','prdemo');   
ab={'This demo includes a set of '
   'MATLAB examples, associated with'
   'the book Pattern Recognition.   '
   '        '
   'The demo is being used only for '
   'educational purposes in the dept.'
   'of Informatics, University of Athens.'
   'for any questions suggestions  or'
   'problems contact the author of the'
   'book: stpatrec@di.uoa.gr'};

about=uimenu(figsound,'label','About','call','msgbox(ab,''About'')');


   