%							----------------------------------
%							|Copyright : Kopsinis Yannis     |
%							|            Pikrakis Aggelos    |
%							|            Basilas Stratos     |
%							|           -------------------- |
%							|           Dept. of Informatics |
%							|           University of Athens |
%							----------------------------------
%%
%Neural network menu
tsip=exist('tsipikoulia');
if tsip==0
   startdemo;
   break
end


clear all;
close all hidden;
tsipikoulia=1;
load setmat;
main=0;
hol=0;
globcontr
global s1 s2
methstr='';


%-------------------------------------------------------------------
% Help texts
%-------------------------------------------------------------------

info={'The purpose of this demo is to help the student to understand the use of SVM algorithms,'
'for linearly separable and non-linearly separable classification problems.'
'The algorithms that are used in this demo are the Sequential Minimal Optimization (SMO)'
'and two modifications of the SMO proposed by Keerthi. '
'SVM algorithms need a set of training parameters to be chosen a priori. The obtained solution and the'
'resulting number of support vectors depend on the choice of these parameters. Furthermore, the fact' 
'that the algorithms which are used here, lead to suboptimal solutions, makes them more "sensitive" '
'to the selection of these parameters as well as to the choice of the constants that control the accuracy '
'of the approximation and the termination of the algorithm.      '
'There are six different examples of classification tasks in this demo. For each of them, pressing' 
'the button "New Help" in the top left of the "Example" figure, a message will appear with information '
'concerning the specific example and the recommended values for the parameters.'
'To begin click the OK button in this info window and then select the examples menu to choose one   '
'of the available example cases. After the training (which in some cases may take some time),'
'a figure will appear with the resulting classification surface. The solid line represents the hyperplane H: w*x+b=0,'
'and the dotted lines the hyperplanes  H1:w*x+b=1, H2:w*x+b=-1.'
'The support vectors resulting from the algorithm, are denoted by black circles'
'and correspond to samples with non-zero coefficients.'};

   
help1={'select the examples menu to choose one of the six examples'};   
  
help2={'Select the appropriate values for the variance and the number of   '
       'patterns corresponding to each one of the Gaussian clusters, by using'
       'the sliders standing on the bottom of the figure named EXAMPLE,    '
       'For more information about this example press the "help" button in the EXAMPLE figure'  
       'After that, use the classifier menu to determine if the classifier '
       'will be linear or non linear, and then the training method you prefer'};

   
help3={'Selected the appropriate values for the variance and the number of   '
       'patterns corresponding to each one of the Gaussian clusters, by using'
       'the sliders standing on the bottom of the figure named `EXAMPLE`,    '
       '                                                                     '
       'This is the typical XOR problem, so you have to choose'
       ' non-linear classification'};


help4={'Use the "Classifier" menu to choose linear or non linear classification'
        'This depends on the problem you are trying to solve'
        'Usually non-linear classification is slower (due to the need for'
        'kernel calculations) but it can solve more difficult problems. '};

help21={'In this example a two-class problem is treated. Each class consists of '
        'three clusters. The samples in each cluster are drawn randomly, from a ' 
        'Gaussian distribution, with variance that you can change by moving the '
        'slider in the down left of the figure.'
        '                                             '
        'For most values of the variance, the problem is linearly separable and '
        'thus a linear classifier can solve it. If the data are linearly separable, '
        'the parameter C must have a large value (ideally infinity). '
        'This is justified as follows:'
        'For large C the second term in the cost function (eq. 3.81 page 84 of the '
        'book) dominates and the algorithm finds a solution which is error free.' 
        'This makes the second term zero and then the optimisation is focussed'
        'entirely on the first term.'
        ''
        '***Choose for C: 1-10 (if non-separable) or >50 (if separable)' 
        ''
        'Now choose an algorithm to be used and press start.'};

help22={'In this example, a two-class task is treated '
         '                         '
        'The samples in each class are created randomly, following a Gaussian' 
        'distribution. The variance of the distribution is constant, =0.5, but' 
        'using the sliders at the bottom of the figure you can change the'
        'horizontal position of the mean of each distribution.' 
        'In this way the classification problem can become linearly separable'
        'or non linearly separable. If the data are linearly separable the'
        'parameter C must have a large value (ideally infinite)'
        ''
        'Now choose an algorithm to be used and press start.'};

    
help23={'In this example a two-class task is presented. Each class consists'  
        'of two clusters. The samples in each cluster are created randomly,'
        'via a Gaussian distribution. Moving the slider at the bottom of the '
        'figure you can change the variance of the distribution . '
        'This is a XOR type of problem, so you have to use a non-linear'
        'classifier. Choose the Gaussian kernel in the "Kernel Type" menu,'
        'and also a value for the kernel parameter , and for C.'
        ''
        'Now choose an algorithm to be used and press start.'};

help24={'In this example a harder two-class task is presented.' 
        'The samples in each cluster are created randomly, following a Gaussian ' 
        'distribution. Moving the slider at the bottom of the figure you can'
        'change the variance and the number of samples.'
        'Since the problem is non-linearly separable you have to choose one of the' 
        'non-linear classifiers. Choose the Gaussian kernel in the "Kernel Type" ' 
        'menu and also a value for the kernel parameter , and for C.'
        ''
        'Now choose an algorithm to be used and press start.'};

    
help25={'In this example a two-class task is treated. '
         '                         '
        'The samples in each cluster are created randomly, following a Gaussian ' 
        'distribution. In this example you can change the variance of each' 
        'distribution both, in the vertical and in the horizontal direction.'
        'In addition by changing sxy1 and sxy2 you can alter the shape '
        'of the distributions. In this way, the classification problem can become  '
        'linearly separable or non-linearly separable.'
        'Choose linear or non-linear classification from the classifier menu.'
        'If the data are linearly separable the parameter C must have a large value.'
        ''
        'Now choose an algorithm to be used and press start.'};
    
   
help26={'In this example the clusters are created in a way that reminds a ' 
        'chessboard. The samples are drawn randomly, following ' 
        'a uniform distribution. '
        'You can change the number of clusters in each direction, as well as' 
        'the number of training patterns and the distance between the classes' 
        'by moving the sliders at the bottom of the figure. The distance "dist" is' 
        'allowed to take negative values, which means that the data are '
        'overlapping. Since the problem is non-linearly separable you have' 
        ' to choose one of the non-linear classifiers. ' 
        ' Choose the Gaussian kernel in the "Kernel Type" menu and also a '
        'value for the kernel parameter , and for C.'
        ''
        'Now choose an algorithm to be used and press start.'};
    

help9={'Click start simulation button to begin.'};

help10={'Now you can click the "Reset Initial Conditions" button to go over'
'again with the same configuration but different initial conditions.'
'                                                           '
'At the same time you can  change some of the training parameters'
' by using the pop up menus, shown on the top of the screen'
'                                            '
'If you want to start again with a new example, or with a new' 
'training method, click on the "Reset All" button to start'};

Result_help={'The solid line represents the hyperplane H: w*x+b=0,' 
    'and the dotted lines the hyperplanes  H1:w*x+b=1, H2:w*x+b=-1.'
'The "support vectors" resulting from the algorithm, are denoted' 
'by black circles and correspond to samples with non-zero coefficients.'};
%-------------------------------------------------------------------




helpstr=help1;
global method;


%ARXIKOPOIHSH METABLHTWN
%-------------------------------------------------------------------
max_step=10000;
tol_constant=0.001;
kernel_parameter_1=0.5;
kernel_parameter_2=0.5;
kernel=1;
epsilon=1e-10;
regularisation_factor=20;
%-------------------------------------------------------------------



%-------------------------------------------------------------------
%MAKE menus
%-------------------------------------------------------------------

%NEURAL MENU
global figmain

%Dhmiourgei to basiko parathyro (figmain) kai ta properties tou
figmain=figure('visible','on','units','normalized');
set(figmain,'userdata','off');
gcf=figmain;
set(gcf,'name','C L A S S I F I C A T I O N   W I T H   SVMs',...
    'color',[0.5689 0.4578 0.6933],...
    'position',[0 0 1 0.93],...
    'numbertitle','off',...
    'menubar','none');

global figt1 axt1

%DHMIOURGEI THN FIG1 KAI TIS BASIKES THW IDIOTHTES(ARISTERA STHN OTHONH)
figt1=figure('visible','off','units','normalized');
axt1=gca;
set(axt1,'fontsize',[8]);
set(figt1,...
    'position',[0.005 0.23 0.48875 0.49],...
    'numbertitle','off',...
    'menubar','none');

%DHMIOURGEI TO MYNHMA PANW ARISTERA KAI TA PROPERTIES TOY
helpsign=uicontrol(figmain,...
   'style','text',...
   'string',{'Click on the','New Help','Menu'},...
   'units','norm',...
   'fontweight','demi',...
   'fore','b',...
   'pos',[0.75 0.73 0.2 0.15],...
   'back',[0.5689 0.4578 0.6933],...
   'visible','off','HorizontalAlignment','center');

% DHMIOURGEI THN FIG2 KAI TIS IDIOTHTES THS (DEKSIA STHN OTHONH)
hl=helpsign;
set(hl,'fontsize',[10]);
global figt2 axt2
figt2=figure('visible','off','units','normalized');
axt2=gca;
set(axt2,'fontsize',[8]);
set(figt2,...
    'position',[0.50625 0.23 0.48875 0.49],...
    'numbertitle','off',...
    'menubar','none');

% DHMIOURGEI THN FIG3 POU TYPONONTAI TA EXAMPLES)
global figt3 axt3
figt3=figure('visible','off','units','normalized','name','EXAMPLE');
axt3=gca;
set(axt3,'fontsize',[8]);
set(figt3,...
    'position',[0.155 0.16 0.67625 0.67],...
    'numbertitle','off',...
    'menubar','none');
hfig3=uimenu(figt3,'label','New Help','call','helpdlg(helpstr3);set(hfig3,''label'',''Help'')'); 


% DHMIOURGEI THN FIG4 POU TYPONONTAI TA APOTELESMATA)
global figt4 axt4
figt4=figure('visible','off','units','normalized','name','RESULT');
axt4=gca;
set(axt4,'fontsize',[8]);
set(figt4,...
    'position',[0.155 0.16 0.67625 0.67],...
    'numbertitle','off');
% 'menubar','none'
hfig4=uimenu(figt4,'label','New Help','call','helpdlg(Result_help);set(hfig4,''label'',''Help'')'); 




%DHMIOURGEI TO PARATHYRO TOU HELP
fighelp=figure('name','info','windowstyle','modal',...
   'units','norm','pos',[0.225 0.2 0.55 0.5],'menubar','none',...
   'numbertitle','off');

%DHMIOYRGEI TO KEIMENO STO fighelp
helpstring=uicontrol(fighelp,'style','listbox','units','norm',...
   'back','white','pos',[0.05 0.15 0.9 0.82],'string',info);

%DHMIOURGEI TO KOUMPAKI OK STO fighelp
okhelp=uicontrol(fighelp,'style','push','string','OK','units','norm',...
   'pos',[0.4 0.01 0.2 0.1],'call',[...
   'set(fighelp,''visible'',''off'');',...
   'gcf=figure(figmain);set(helpsign,''visible'',''on'');']);



 %DHMIOURGEI TO KOUMPAKI "start simulation"
           
start=uicontrol(figmain,'style','push',...
               'string','Start Simulation',...
               'units','normalized',...
               'enable','off',...
               'position',[0.4    0.19    0.1875    0.0442],...
               'call',[...
               'set(start,''enable'',''off'');',...
               'helpstr=help10;set(h,''label'',''New Help'');',...
               'set(helpsign,''visible'',''on'');',...
               'fcheck=0;scheck=0;',...
               'set(reset_in,''enable'',''on'');',...
               'start_algorithm;']);
               

 %DHMIOURGEI TO KOUMPAKI "Reset All" TO KOUMPI AYTO KSANATREXEI TO SMOMENU 
 reset=uicontrol(figmain,'style','push',...
               'string','Reset All',...
               'units','normalized',...
               'position',[0.28    0.11    0.2    0.05],...
               'call','smomenu');
         
%DHMIOURGEI TO KOUMPAKI "Reset INITIAL Conditions"          
reset_in=uicontrol(figmain,'style','push',...
               'string','Reset Initial Conditions',...
               'enable','off',...
               'units','normalized',...
               'position',[0.5    0.11    0.2    0.05],...
               'call',[...
               'set(start,''enable'',''on'');',...
               'set(helpsign,''visible'',''on'');',...
               'helpstr=help9;set(h,''label'',''New Help'');']);
        

%exambles menu
%DHMIOURGEI MENU EXAMPLES STO BASIKO FIGURE(FIGMAIN)  
exambles=uimenu(figmain,'label','Examples');

educ1=uimenu(exambles,'label','Example #1','callback',[...
      'slider1;',...
      'main=3;',...
      'newmenu=bptmenu;',...
      'set(exambles,''enable'',''off'');',...
      'helpstr=help2;',...
      'set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'set(bptmenu,''enable'',''on'');',...
      'helpstr3=help21;']);

educ2=uimenu(exambles,'label','Example #2','callback',[...
      'slider4;',...
      'main=3;',...
      'newmenu=bptmenu;',...
      'set(exambles,''enable'',''off'');',...
      'helpstr=help2;',...
      'set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'set(bptmenu,''enable'',''on'');',...
      'helpstr3=help22;']);


xor=uimenu(exambles,'label','Example #3','callback',[...
      'slider;',...
      'main=3;',...
      'newmenu=bptmenu;',...
      'set(exambles,''enable'',''off'');',...
      'helpstr=help3;',...
      'set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'set(bptmenu,''enable'',''on'');'...
      ' helpstr3=help23;']);


three_d=uimenu(exambles,'label','Example #4','callback',[...
      'slider3;',...
      'main=3;',...
      'newmenu=bptmenu;',...
      'set(exambles,''enable'',''off'');',...
      'helpstr=help2;',...
      'set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'set(bptmenu,''enable'',''on'');',...
      'helpstr3=help24;']);

      
myexam=uimenu(exambles,'label','Example #5','callback',[...
      'slider5;',...
      'main=3;',...
      'newmenu=bptmenu;',...
      'set(exambles,''enable'',''off'');',...
      'helpstr=help2;',...
      'set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'set(bptmenu,''enable'',''on'');',...
      'helpstr3=help25;']);

     
myexam2=uimenu(exambles,'label','Example #6','callback',[...
      'slider6;',...
      'main=3;',...
      'newmenu=bptmenu;',...
      'set(exambles,''enable'',''off'');',...
      'helpstr=help2;',...
      'set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'set(bptmenu,''enable'',''on'');',...
      'helpstr3=help26;']);



%DHMIOURGEI TO MENU CLASIFIER KAI TA YPOLOIPA POU AKOLOUTHOYN
%Backpropagation training menu
bptmenu=uimenu(figmain,'label','Classifier','enable','off','call',[...
      'main=0;',...
      'helpstr=help4;',...
      'set(helpsign,''visible'',''on'');',...
      'set(h,''label'',''New Help'');']);



%MYNHMATA GIA TO MENOU CLASIFIER
plat_lin= {'You have selected a linear SVM. The kernel is automatically set to linear '
           'and the separating surface, will be a line in the two dimensional case. '   
           ''
           'The Algorithm that is used, is the Sequential Minimal Optimization'
           '(SMO) developed by Platt for SVM classifiers.' 
           '                                        '
           'Choose the appropriate values for the parameters: Regularization factor C,'
           'tolerance, epsilon and max step, by using the corresponding pop up menus, '
           'and then press start to begin simulation. For appropriate values of the' 
           'parameters press "Help" in the example window '};
   
       
Keerthi_lin={'You have selected a linear SVM. The kernel is automatically set to linear '
           'and the separating surface, will be a line in the two dimensional case.'
            ''
           'The Algorithm that is used, is a modification of the SMO, developed by '
           'Keerthi, in order to speed up the algorithm. There are differences in the  ' 
           'conditions for terminating the algorithm as well as in the choice of the ' 
           'samples to be optimized in each iteration. Therefore in general a ' 
           'different to SMO solution is obtained. This modified version of the SMO '
           'algorithm is much faster than the original one and is recommended '
           'for difficult problems. Choose the appropriate values for the parameters: '
           'Regularization Factor C, tolerance, epsilon and max step, by using'
           'the corresponding pop up menus and then press start to begin simulation.'
           'For appropriate values of the parameters press "Help" in the example window.'   };
       
       
Keerthi_lin2={'You have selected a linear SVM. The kernel is automatically set to linear '
           'and the separating surface, will be a line in the two dimensional case.'
            ''
           'The Algorithm that is used, is a modification of the SMO, developed by '
           'Keerthi, in order to speed up the algorithm. There are differences in the  ' 
           'conditions for terminating the algorithm as well as in the choice of the ' 
           'samples to be optimized in each iteration. Therefore in general a ' 
           'different to SMO solution is obtained. This modified version of the SMO '
           'algorithm is much faster than the original one and is recommended '
           'for difficult problems. Choose the appropriate values for the parameters: '
           'Regularization Factor C, tolerance, epsilon and max step, by using'
           'the corresponding pop up menus and then press start to begin simulation.'
           'For appropriate values of the parameters press "Help" in the example window.'   };
       
       
          
             
plat_non_lin={'You have selected a non-linear SVM. Choose the Gaussian kernel in '
              'the menu "Kernel Type" below and a value for the kernel parameter '
              ''         
              'The Algorithm that is used, is Sequential Minimal Optimization'
              '(SMO) developed by Platt for SVM classifiers.'
              '                                        '
              'Choose the appropriate values for the parameters: Regularization factor C,'
              'tolerance, epsilon and max step, by using the corresponding pop up menus, '
              'and then press start to begin simulation. For appropriate values of the' 
              'parameters press "Help" in the example window ' };
          
   
Keerthi_non_lin={'You have selected a non-linear SVM. Choose the Gaussian kernel in '
               'the menu "Kernel Type" below and a value for the kernel parameter .'
                '                                                '
                'The Algorithm that is going to be used, is a modification of SMO,  '
                'developed byKeerthi, in order to speed up the algorithm.  ' 
                'There are differences in the ending conditions as well as in  '
                'the choice of the samples that are being optimized in every step.' 
                'Therefore it is expected that even for the same values of training '
                'parameters the separating surface may not be exactly the same.'
                'The modification makes the algorithm much faster than the simple SMO'
                'and is recommended for difficult problems.'
                'Choose the appropriate values for the parameters, Regularization Factor C'
                'tolerance, epsilon and max step, by using the corresponding pop up menus'
                'and then press start to begin simulation.'};
         
Keerthi_non_lin2={'You have selected a non-linear SVM. Choose the Gaussian kernel in '
               'the menu "Kernel Type" below and a value for the kernel parameter .'
                '                                                '
                'The Algorithm that is going to be used, is a modification of SMO, developed by '
                'Keerthi, in order to speed up the algorithm. There are differences in the ending ' 
                'conditions as well as in the choice of the samples that are being optimized in '
                'every step. Therefore it is expected that even for the same values of training '
                'parameters the separating surface may not be exactly the same.'
                'The modification makes the algorithm much faster than the'
                'simple SMO, and is recommended for difficult problems.'
                'Choose the appropriate values for the parameters, Regularization Factor C,'
                'tolerance, epsilon and max step, by using the corresponding pop up menus  '
                'and then press start to begin simulation.'};
 
   
linear=uimenu(bptmenu,'label','Linear Classification');              
nonlinear=uimenu(bptmenu,'label','Non linear Classfication');

                     

Plattlinear=uimenu(linear,'label','Platt ','separator','on',...
                     'callback',[...
                     'set(slayertxt,''enable'',''off'');',...
                     'algorithm=''start_algorithm'';set(flayertxt,''enable'',''on'');',...
                     'myenableon(''flayer3'');',...
                     'myenableon(''popmax_step'');myenableon(''popreg_factor'');',...
                     'myenableon(''pop_tol'');myenableof(''popkernel_type'');',...
                     'myenableof(''popker_par_2'');myenableof(''slayer3'');',...
                     'myenableon(''popepsilon'');myenableon(''popker_par'');',...
                     'newmenu=arx;',...
                     'set(bptmenu,''enable'',''off'');',...
                     'set(start,''enable'',''on'');'...
                     'helpstr=plat_lin;',...
                     'method=0;',...
                     'set(arx,''enable'',''on'');',...
                     'set(helpsign,''visible'',''on'');',...
                     'set(h,''label'',''New Help'');']);
             

Keerthi1linear=uimenu(linear,'label','Keerthi 1st','separator','on',...
                     'callback',[...
                     'set(slayertxt,''enable'',''off'');',...
                     'algorithm=''start_algorithm'';set(flayertxt,''enable'',''on'');',...
                     'myenableon(''flayer3'');',...
                     'myenableon(''popmax_step'');myenableon(''popreg_factor'');',...
                     'myenableon(''pop_tol'');myenableof(''popkernel_type'');',...
                     'myenableof(''popker_par_2'');myenableof(''slayer3'');',...
                     'myenableon(''popepsilon'');myenableon(''popker_par'');',...
                     'newmenu=arx;',...
                     'set(bptmenu,''enable'',''off'');',...
                     'set(start,''enable'',''on'');'...
                     'helpstr=Keerthi_lin;',...
                     'method=1;',...
                     'set(arx,''enable'',''on'');',...
                     'set(helpsign,''visible'',''on'');',...
                     'set(h,''label'',''New Help'');']);
             
Keerthi2linear=uimenu(linear,'label','Keerthi 2nd','separator','on',...
                     'callback',[...
                     'set(slayertxt,''enable'',''off'');',...
                     'algorithm=''start_algorithm'';set(flayertxt,''enable'',''on'');',...
                     'myenableon(''flayer3'');',...
                     'myenableon(''popmax_step'');myenableon(''popreg_factor'');',...
                     'myenableon(''pop_tol'');myenableof(''popkernel_type'');',...
                     'myenableof(''popker_par_2'');myenableof(''slayer3'');',...
                     'myenableon(''popepsilon'');myenableon(''popker_par'');',...
                     'newmenu=arx;',...
                     'set(bptmenu,''enable'',''off'');',...
                     'set(start,''enable'',''on'');'...
                     'helpstr=Keerthi_lin2;',...
                     'method=2;',...
                     'set(arx,''enable'',''on'');',...
                     'set(helpsign,''visible'',''on'');',...
                     'set(h,''label'',''New Help'');']);
         
                  


Platt_non_linear=uimenu(nonlinear,'label','Platt ','separator','on',...
                     'callback',[...
                     'set(slayertxt,''enable'',''off'');',...
                     'algorithm=''start_algorithm'';set(flayertxt,''enable'',''on'');',...
                     'myenableon(''flayer3'');',...
                     'myenableon(''popmax_step'');myenableon(''popreg_factor'');',...
                     'myenableon(''pop_tol'');myenableon(''popkernel_type'');',...
                     'myenableon(''popker_par_2'');myenableof(''slayer3'');',...
                     'myenableon(''popepsilon'');myenableon(''popker_par'');',...
                     'newmenu=arx;',...
                     'set(bptmenu,''enable'',''off'');',...
                     'set(start,''enable'',''on'');'...
                     'helpstr=plat_non_lin;',...
                     'method=0;',...
                     'set(arx,''enable'',''on'');',...
                     'set(helpsign,''visible'',''on'');',...
                     'set(h,''label'',''New Help'');']);
             

Keerthi1_non_linear=uimenu(nonlinear,'label','Keerthi 1st','separator','on',...
                     'callback',[...
                     'set(slayertxt,''enable'',''off'');',...
                     'algorithm=''start_algorithm'';set(flayertxt,''enable'',''on'');',...
                     'myenableon(''flayer3'');',...
                     'myenableon(''popmax_step'');myenableon(''popreg_factor'');',...
                     'myenableon(''pop_tol'');myenableon(''popkernel_type'');',...
                     'myenableon(''popker_par_2'');myenableof(''slayer3'');',...
                     'myenableon(''popepsilon'');myenableon(''popker_par'');',...
                     'newmenu=arx;',...
                     'set(bptmenu,''enable'',''off'');',...
                     'set(start,''enable'',''on'');'...
                     'helpstr=Keerthi_non_lin;',...
                     'method=1;',...
                     'set(arx,''enable'',''on'');',...
                     'set(helpsign,''visible'',''on'');',...
                     'set(h,''label'',''New Help'');']);
             
Keerthi12_non_linear=uimenu(nonlinear,'label','Keerthi 2nd','separator','on',...
                     'callback',[...
                     'set(slayertxt,''enable'',''off'');',...
                     'algorithm=''start_algorithm'';set(flayertxt,''enable'',''on'');',...
                     'myenableon(''flayer3'');',...
                     'myenableon(''popmax_step'');myenableon(''popreg_factor'');',...
                     'myenableon(''pop_tol'');myenableon(''popkernel_type'');',...
                     'myenableon(''popker_par_2'');myenableof(''slayer3'');',...
                     'myenableon(''popepsilon'');myenableon(''popker_par'');',...
                     'newmenu=arx;',...
                     'set(bptmenu,''enable'',''off'');',...
                     'set(start,''enable'',''on'');'...
                     'helpstr=Keerthi_non_lin2;',...
                     'method=2;',...
                     'set(arx,''enable'',''on'');',...
                     'set(helpsign,''visible'',''on'');',...
                     'set(h,''label'',''New Help'');']);
         





h=uimenu(figmain,'label','New Help','call',[...
      'hlp=helpdlg(helpstr);set(h,''label'',''Help'');',...
      'set(helpsign,''visible'',''off'');',...
      'if main==3;gcf=figure(figt3);gcf=figure(hlp);end']);

%BACK TO MAIN MENU- TREXEI THN PRDEMO KSANA
bm=uimenu(figmain,'label','Back to main menu','call','prdemo');
global wt1 wt2 bt1 bt2




%--------------------------------------------------------------------------
%POP MENUS                            
%--------------------------------------------------------------------------

%MAX NUMBER OF STEPS
%globam max_step
tmax_step=uicontrol(figmain,...
   'style','text',...
   'string','max step',...
   'units','norm',...
   'back',[0.5789 0.4578 0.6933],...
   'pos',[0.5463    0.95    0.1162    0.03]);

popmax_step=uicontrol(figmain,...
   'style','popup',...
   'enable','off',...
   'string','step=10000|step=500|step=1000|step=2000|step=5000|step=10000|step=20000|step=30000|step=50000|step=400000',...
   'units','normalized',...
   'position',[0.5563    0.94    0.1162    0.001],...
   'userdata',[10000; 500 ; 1000; 2000; 5000; 10000; 20000; 30000 ;50000; 400000],...
   'callback',[...
         'max_st=get(popmax_step,''userdata'');',...
         'max_step=max_st(get(popmax_step,''value''));',...
         'global max_step']);   



%TOLERANCE
%global tol_constant
ttol=uicontrol(figmain,...
   'style','text',...
   'string','Tolerance',...
   'units','norm',...
   'back',[0.5689 0.4578 0.6933],...
   'pos',[0.4413    0.95    0.1    0.03]);
 
pop_tol=uicontrol(figmain,...
   'style','popup',...
   'enable','off',...   
   'string','tol=0.001|tol=0.1|tol=0.01|tol=0.005|tol=0.001|tol=0.0001|tol=0.000001',...
   'units','normalized',...
   'position',[0.4413    0.94    0.1162    0.001],...
   'userdata',[0.001;0.1; 0.01; 0.005; 0.001; 0.0001; 0.000001],...
   'callback',[...
         'tol_constant_t=get(pop_tol,''userdata'');',...
         'tol_constant=tol_constant_t(get(pop_tol,''value''));',...
         'global tol_constant']);   

 
% 1st KERNEL PARAMETER
% global kernel_parameter_1
tker_par=uicontrol(figmain,...
   'style','text',...
   'string',' Kernel Parameter sigma',...
   'units','norm',...
   'back',[0.5689 0.4578 0.6933],...
   'pos',[0.32    0.95    0.1162    0.03]);
   
popker_par=uicontrol(figmain,...
   'style','popup',...
   'enable','off',...   
   'string','sigma=0.5|sigma=0.05|sigma=0.1|sigma=0.15|sigma=0.2|sigma=0.3|sigma=0.5|sigma=0.8|sigma=1|sigma=1.5',...
   'units','normalized',...
   'position',[0.326    0.94    0.1162    0.001],...
   'userdata',[0.5 ;  0.05; 0.1; 0.15; 0.2; 0.3; 0.5; 0.8; 1; 1.5],...
   'callback',[...
         'kernel_parameter_1_t=get(popker_par,''userdata'');',...
         'kernel_parameter_1=kernel_parameter_1_t(get(popker_par,''value''));',...
         'global kernel_parameter_1']);   

 %REGULARISATION FACTOR
   %global regularisation_factor
treg_factor=uicontrol(figmain,...
   'style','text',...
   'string','Regularisation Factor C',...
   'units','norm',...
   'back',[0.5689 0.4578 0.6933],...
   'pos',[0.20    0.95    0.1162    0.03]);
   
popreg_factor=uicontrol(figmain,...
   'style','popup',...
   'enable','off',...   
   'string','C=20|C=0.05|C=0.1|C=0.2|C=0.5|C=1|C=2|C=3|C=5|C=10|C=20|C=50|C=100|C=500|C=1000|C=10000|C=100000|C=10^6',...
   'units','normalized',...
   'position',[0.2013    0.94    0.1262    0.001],...
   'userdata',[20 ;0.05; 0.1; 0.2 ; 0.5 ;1 ;2 ; 3 ;5 ;10 ;20 ;50 ;100 ;500 ;1000 ;10000 ; 100000 ;1e+6 ],...
   'callback',[...
         'regularisation_factor_t=get(popreg_factor,''userdata'');',...
         'regularisation_factor=regularisation_factor_t(get(popreg_factor,''value''));',...
         'global regularisation_factor']);   



%TYPE OF KERNEL
 %global KERNEL
tkernel_type=uicontrol(figmain,...
   'style','text',...
   'string','Kernel Type',...
   'units','norm',...
   'back',[0.5689 0.4578 0.6933],...
   'pos',[0.0863    0.95    0.1162    0.03]);
   
popkernel_type=uicontrol(figmain,...
   'style','popup',...
   'enable','off',...   
   'string','Linear|Gaussian',...
   'units','normalized',...
   'position',[0.0863    0.94    0.1162    0.001],...
   'userdata',[1;2],...                                        %1=> linear
         'callback',[...                                       %2=> rbf
         'kernel_t=get(popkernel_type,''userdata'');',...      %3=> poly
         'kernel=kernel_t(get(popkernel_type,''value''));',... %4=> sigmoid
         'global kernel']);
  
 

   %global epsilon
tepsilon=uicontrol(figmain,...
   'style','text',...
   'string','epsilon',...
   'units','norm',...
   'back',[0.5689 0.4578 0.6933],...
   'pos',[0.66  0.95    0.1162    0.03]);
   
popepsilon=uicontrol(figmain,...
   'style','popup',...
   'enable','off',...   
   'string','eps=10^-10|eps=0.001|eps=0.000001|eps=10^-8|eps=10^-10|eps=10^-15|eps=10^-20|eps=10^-25',...
   'units','normalized',...
   'position',[0.6713    0.94    0.1180    0.001],...
   'userdata',[1e-10 ;0.001;0.000001;1e-8 ;1e-10 ;1e-15;1e-20;1e-25],...
   'callback',[...
         'epsilon_t=get(popepsilon,''userdata'');',...
         'epsilon=epsilon_t(get(popepsilon,''value''));',...
         'global epsilon']);      
   
 
 
 
ab={'This demo includes a set of '
   'MATLAB examples, associated with'
   'the book Pattern Recognition.   '
   '        '
   'The demo is being used only for '
   'educational purposes in the dept.'
   'of Informatics, University of Athens.'
   'for any questions suggestions  or'
   'problems contact the author of the'
   'book: stpatrec@di.uoa.gr'};

about=uimenu(figmain,'label','About','call','msgbox(ab,''About'')');

            
%---------PARAMETERS HELP-----------------------------------------
 ad1={'Kernel Type: The linear kernel is K(x1,x2)=<xi,x2> and the'
     'Gaussian kernel is K(x1,x2)=exp(-0.5|x1-x2|^2/^2).'
     'When a linear Classifier is chosen ahe kernel type is '
     'automaticaly set to "linear".'};
 
 ad2={'Regularization factor C: This factor controls the tradeoff between '
     'complexity of the classifier and the value of the training error. '
     'Furthermore when the problem is solved using the algorithms proposed by '
     'Platt and Keerthi, C is the upper limit for the values of the Lagrange '
     'multipliers, and in this way it controls the dependence of the solution'
     'from individual samples.'};
 
 ad3={'Kernel Parameter  : This parameter has to be set when ' 
      'a Gaussian kernel is used (Non-linear Classification).'
     'A Gaussian kernel is of the form exp(-0.5|x-xi|^2/^2)'
     '"kernel parameter" is the "" in the above formula.'};
 
 ad4={'Tolerance, max_step and epsilon are three parameters that are used in' 
     'SMO and its variants, and control the accuracy of the obtained solution.'
     'The above algorithms will terminate if either the optimal solution has'
     'been reached, or if no further improvement is possible. '
     'The performance of the algorithm depends, to a large extent, on the values  '
     'of epsilon and tolerance, and therefore if these values are not  '
     'properly chosen, the algorithm may terminate either too early, or too late '
     'and with a large number of support vectors. '
     'It is recommended to use the values that are proposed in each example.'
     ''
     'Tolerance: In numerical solutions it is usually not possible to achieve '
     'optimality exactly. The parameter "tolerance" defines approximate optimality conditions.'};

 ad5={'max step : In a difficult problem the algorithm may take a lot of'
    ' time to converge. In order to speed up the process it is allowed '
    'to terminate the algorithm earlier, when "max step" number of steps  '
    'has been executed.'};


 
  ad6={'epsilon: It is a small number. In the calculations that are needed '
      'for the algorithms, two numbers a,b are considered different if |a-b|>epsilon'};


 

 

%---------PARAMETERS HELP-----------------------------------------
   
 
 
 
Parameters_help=uimenu(figmain,'label','Parameters help');
kernelmenu=uimenu(Parameters_help,'label','Kernel Type','call','msgbox(ad1,''kernel type'')');
regumenu=uimenu(Parameters_help,'label','Regularisation Factor C','call','msgbox(ad2,''Regularisation factor'')');
kernelparametermenu=uimenu(Parameters_help,'label','Kernel Parameter','call','msgbox(ad3,''kernel parameter'')');
tolerancemenu=uimenu(Parameters_help,'label','Tolerance','call','msgbox(ad4,''Tolerance'')');
maxstepmenu=uimenu(Parameters_help,'label','max step','call','msgbox(ad5,''max_step'')');
epsilonmenu=uimenu(Parameters_help,'label','epsilon','call','msgbox(ad6,''epsilon'')');

