%							----------------------------------
%							|Copyright : Kopsinis Yannis     |
%							|            Pikrakis Aggelos    |
%							|            Basilas Stratos     |
%							|           -------------------- |
%							|           Dept. of Informatics |
%							|           University of Athens |
%							----------------------------------
%%
%Neural network menu
tsip=exist('tsipikoulia');
if tsip==0
   startdemo;
   break
end


clear all;
close all hidden;
% nntwarn off
tsipikoulia=1;
load setmat;
main=0;
hol=0;
globcontr
global s1 s2
methstr='';
info={'The purpose of this demo is to help the student to understand the'
'use and behavior of the backpropagation algorithm for training'
'multilayer perceptrons.'
'Various forms of the backpropagation algorithm are available, in-'
'cluding the use of a momentum term as well as adaptive learning'
'rate. To run the demo the student must have access to the Neural'
'Network Toolbox Version 3.0 of the MATLAB 5.* .'
'                      '
'To begin click the OK button of this info window and then select'
'the examples menu to choose one of the four available example'
'cases.  '};
   
help1={'select the examples menu to choose one of the four examples'};   
  
help2=['Selected the appropriate values for the variance and the number of   '
       'patterns corresponding to each one of the gaussian clusters, by using'
       'the sliders standing on the bottom of the figure named `EXAMPLE`,    '
       'choose the Backpropagatin menu to determine the training method you  '
       'want.                                                                '];

help3={'Click on Backpropagation menu to select the number of layers'
'that the network will have, and determine the backpropagetion' 
'(BP) method that you want to use, to train the network. '
'The possible combinations are :'
'                                                       '
'2-layer Neural Network (one hidden) trained by '
'a)pure BP with constant or adaptive learning rate '
'b)momentum BP with constant or adaptive learning rate '
   '                                                       '
'3-layer Neural Network (two hidden) trained by '
'a)pure BP with constant or adaptive learning rate '
'b)momentum BP with constant or adaptive learning rate '
'                                                       '
'The "pruning" selection applies the pruning algorithm on a three'
'layer perceptron using the pure BP method with constant learning'
'rate. '};
   
   

help21={'In this example a two-class problem is presented. Each class con-'
'sists of three clusters.'
'                                             '
'The two classes are linearly separable, so a 2-Layer Network with'
'one node in the hidden layer is enough to solve this problem.'
'                         '
'Select the appropriate values for the variance and the number of' 
'patterns corresponding to each one of the clusters, by using the' 
'sliders standing on the bottom of this figure, and then choose the' 
'Backpropagation menu to determine the training method you wish' 
'to employ.                                             '};


help22={'In this example a two-class problem is presented. Each class con-'
'sists of two clusters.'
'                                      '
'It`s an extension of the well known XOR problem. Correct class' 
'classification requires at least a 2-layer Network with two nodes' 
'in the hidden layer'
'                         '
'Select the appropriate values for the variance and the number of' 
'patterns corresponding to each one of the clusters, by using the' 
'sliders standing on the bottom of this figure, and then choose the' 
'Backpropagation menu to determine the training method you wish' 
'to employ.                                             '};

help23={'In this example a two-class problem is presented. Each class con-'
'sists of four clusters. '
'                         '
'Select the appropriate values for the variance and the number of'
'patterns corresponding to each one of the clusters, by using the' 
'sliders standing on the bottom of this figure, and after choose the'
'Backpropagation menu to determine the training method you wish' 
'to employ.'
'                                                      '
'RECOMENDATION: Use a  3-Layer neural network with 3' 
'nodes in the first layer and 2 nodes in the second one. For fast' 
'convergence it is better to use an adaptive learning rate Back-'
'propagation algorithm. For further experimentation use different' 
'number of layers and/or nodes'};



help24={'In this example a more difficult two-class problem is presented.' 
'Select the appropriate values for the variance and the number of' 
'patterns corresponding to each one of the clusters, by using the' 
'sliders standing on the bottom of this figure, and then choose the' 
'Backpropagation menu to determine the training method you wish' 
'to employ.                                             '
'                                   '
'RECOMENDATION: Use a 3-Layer perceptron. Depending on'
'the variance of the clusters, a relatively high number of nodes per' 
'layer may have to be used (e.g. 5 or 6). For fast convergence it is'
'better to use an adaptive learning rate Backpropagation algo'
'rithm.'};






help5=['Choose the appropriate values for the parameters max epoch,       '
       'learning rate, error goal, momentum, learning rate increase,      '
       'learning rate decrease, error ratio by using the corresponding pop' 
       'up menus.                                                         '
       '                                                                  '
       'If you are not able to change some of the above parameters it     ' 
       'means that the selected BP method doesn`t utilize these variables.' 
       'When you are ready, click on the Network Configuration menu       ' 
       'and then choose the number of nodes for each one of the layers    '];

help6={'Click on the Network Configuration menu to choose the number of'
   'nodes for each one of the layers. '};
help7={'You forgot to specify the number of nodes of the FIRST layer !!! '
   'Click on the Network Configuration menu to specify it.'};
help8={'You forgot to specify the number of nodes of the SECOND layer !!! '
   'Click on the Network Configuration menu to specify it.'};
help9={'Click start simulation button to begin.'};
help10={'Now you can click the `Reset Initial conditions` button to go over'
'again with the same configuration but different initial conditions,'
'or, alternatively, you can  change the number of nodes from the' 
'Network Configuration menu.'
'At the same time you can change the parameters that the  BP'
'method utilizes, by using the pop up menus, shown on the top of'
'the screen.'
'                                            '
'If you want to start again with a new example, or with a new' 
'Backpropagation method, click on the `Reset All` button to start'};

helpstr=help1;


s1=0;
s2=0;
global wt1 wt2 bt1 bt2

[wt1,bt1]=arx1hl;
[wt2,bt2]=arx2hl;
wt3=[];
bt3=[];
max_epoch=800;
err_goal=0.1;
lr=0.01;
lr_inc=1.05;
lr_dec=0.8;
mom_const=0.7;
err_ratio=1.05;

%make menus

%NEURAL MENU
global figmain

figmain=figure('visible','on','units','normalized');
set(figmain,'userdata','off');
gcf=figmain;
set(gcf,'name','C L A S S I F I C A T I O N   W I T H   B A C K P R O P A G A T I O N   M E T H O D',...
    'color',[0.5689 0.4578 0.6933],...
    'position',[0 0 1 0.93],...
    'numbertitle','off',...
    'menubar','none');
global figt1 axt1

figt1=figure('visible','off','units','normalized');
axt1=gca;
set(axt1,'fontsize',[8]);
set(figt1,...
    'position',[0.5 0.23 0.48875 0.49],...
    'numbertitle','off',...
    'menubar','none');
 

%neurmenu=[neurmenu figt1];
helpsign=uicontrol(figmain,...
   'style','text',...
   'string',{'Click on the','New Help','Menu'},...
   'units','norm',...
   'fontweight','demi',...
   'fore','b',...
   'pos',[0.8 0.73 0.2 0.15],...
   'back',[0.5689 0.4578 0.6933],...
   'visible','off');

hl=helpsign;
set(hl,'fontsize',[10]);
global figt2 axt2
figt2=figure('visible','off','units','normalized');
axt2=gca;
set(axt2,'fontsize',[8]);
set(figt2,...
    'position',[0.50625 0.23 0.48875 0.49],...
    'numbertitle','off',...
    'menubar','none');

global figt3 axt3
figt3=figure('visible','off','units','normalized','name','EXAMPLE');
axt3=gca;
set(axt3,'fontsize',[8]);
set(figt3,...
    'position',[0.155 0.16 0.67625 0.67],...
    'numbertitle','off',...
    'menubar','none');
hfig3=uimenu(figt3,'label','New Help','call','helpdlg(helpstr3);set(hfig3,''label'',''Help'')'); 


fighelp=figure('name','info','windowstyle','modal',...
   'units','norm','pos',[0.225 0.2 0.55 0.5],'menubar','none',...
   'numbertitle','off');
helpstring=uicontrol(fighelp,'style','listbox','units','norm',...
   'back','white','pos',[0.05 0.15 0.9 0.82],'string',info);
okhelp=uicontrol(fighelp,'style','push','string','OK','units','norm',...
   'pos',[0.4 0.01 0.2 0.1],'call',[...
   'set(fighelp,''visible'',''off'');',...
   'gcf=figure(figmain);set(helpsign,''visible'',''on'');']);



            
start=uicontrol(figmain,'style','push',...
               'string','Start Simulation',...
               'units','normalized',...
               'enable','off',...
               'position',[0.4    0.19    0.1875    0.0442],...
               'call',[...
               'set(start,''enable'',''off'');',...
               'helpstr=help10;set(h,''label'',''New Help'');',...
               'set(helpsign,''visible'',''on'');',...
               'fcheck=0;scheck=0;',...
               'set(reset_in,''enable'',''on'');',...
               'startscript;']);
               

 reset=uicontrol(figmain,'style','push',...
               'string','Reset All',...
               'units','normalized',...
               'position',[0.28    0.11    0.2    0.05],...
               'call','neuralmenu');
         
         
reset_in=uicontrol(figmain,'style','push',...
               'string','Reset Initial Conditions',...
               'enable','off',...
               'units','normalized',...
               'position',[0.5    0.11    0.2    0.05],...
               'call',[...
               '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;',...
               'set(start,''enable'',''on'');',...
               'set(helpsign,''visible'',''on'');',...
               'helpstr=help9;set(h,''label'',''New Help'');']);

           


%exambles menu

exambles=uimenu(figmain,'label','Examples');

first=uimenu(exambles,'label','Example #1','callback',[...
      'slider1;',...
      'main=3;',...
      'newmenu=bptmenu;',...
      'set(exambles,''enable'',''off'');',...
      'helpstr=help2;',...
      'set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'set(bptmenu,''enable'',''on'');',...
      'helpstr3=help21;']);

xor=uimenu(exambles,'label','Example #2','callback',[...
      'slider;',...
      'main=3;',...
      'newmenu=bptmenu;',...
      'set(exambles,''enable'',''off'');',...
      'helpstr=help2;',...
      'set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'set(bptmenu,''enable'',''on'');',...
      'helpstr3=help22;']);


three_d=uimenu(exambles,'label','Example #3','callback',[...
      'slider3;',...
      'main=3;',...
      'newmenu=bptmenu;',...
      'set(exambles,''enable'',''off'');',...
      'helpstr=help2;',...
      'set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'set(bptmenu,''enable'',''on'');',...
      'helpstr3=help23;']);

    
prun=uimenu(exambles,'label','Example #4','callback',[...
      'slider4;',...
      'main=3;',...
      'newmenu=bptmenu;',...
      'set(exambles,''enable'',''off'');',...
      'helpstr=help2;',...
      'set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'set(bptmenu,''enable'',''on'');',...
      'helpstr3=help24;']);
      

%Backpropagation training menu

bptmenu=uimenu(figmain,'label','Backpropagation','enable','off','call',[...
      'main=0;',...
      'helpstr=help3;',...
      'set(helpsign,''visible'',''on'');',...
      'set(h,''label'',''New Help'');']);


pru=['You`ve selected a 3-Layer Neural Network with pure BackPropagation'
     'and constant learning rate, supplied with the pruning ability.    '];
pur2=['You`ve selected a 2-Layer Neural Network with pure '
      'BackPropagation and constant learning rate.        '];
pura2=['You`ve selected a 2-Layer Neural Network with pure  '
       'BackPropagation and adaptive learning rate.         '];
mom2=['You`ve selected a 2-Layer Neural Network, BackPropagation'
      'with momentum and constant learning rate.                '];
moma2=['You`ve selected a 2-Layer Neural Network, BackPropagation'
       'with momentum and adaptive learning rate.                '];

pur3=['You`ve selected a 3-Layer Neural Network with pure '
      'BackPropagation and constant learning rate.        '];
pura3=['You`ve selected a 3-Layer Neural Network with pure  '
       'BackPropagation and adaptive learning rate.         '];
mom3=['You`ve selected a 3-Layer Neural Network, BackPropagation'
      'with momentum and constant learning rate.                '];
moma3=['You`ve selected a 3-Layer Neural Network, BackPropagation'
       'with momentum and adaptive learning rate.                '];
     
purebpmenu=uimenu(bptmenu,'label','2L-Pure backpropagation');
                   
momenbpmenu=uimenu(bptmenu,'label','2L-Momentum backpropagation');
purebpmenu2=uimenu(bptmenu,'label','3L-Pure backpropagation');
momenbpmenu2=uimenu(bptmenu,'label','3L-Momentum backpropagation');
prunningmenu=uimenu(bptmenu,'label','prunning','separator','on','call',[...
                     'algorithm=''bptr3pr'';myenableof(''popmom_const'');',...      
                     'set(flayertxt,''enable'',''on'');',...
                     'set(slayertxt,''enable'',''on'');',...
                     'myenableon(''flayer3'');',...
                     'myenableon(''slayer3'');myenableon(''popmax_epoch'');',...
                     'myenableof(''poplr_inc'');myenableof(''poplr_dec'');',...
                     'myenableof(''poperr_ratio'');myenableon(''slayer3'');',...
                     'myenableon(''pop_lr'');myenableon(''poperr_goal'');',...
                     'newmenu=arx;',...
                     'set(bptmenu,''enable'',''off'');',...
                     'help5={pru,'''',help5};',...
                     'helpstr=help5;',...
                     'set(arx,''enable'',''on'');',...
                     'set(helpsign,''visible'',''on'');',...
                     'set(h,''label'',''New Help'');']);
                     

puresubmenu=uimenu(purebpmenu,'label','constant lr','separator','on',...
                     'callback',[...
                     'set(slayertxt,''enable'',''off'');',...
                     'algorithm=''bptr'';set(flayertxt,''enable'',''on'');',...
                     'myenableon(''flayer3'');',...
                     'myenableon(''popmax_epoch'');myenableof(''popmom_const'');',...
                     'myenableof(''poplr_inc'');myenableof(''poplr_dec'');',...
                     'myenableof(''poperr_ratio'');myenableof(''slayer3'');',...
                     'myenableon(''pop_lr'');myenableon(''poperr_goal'');',...
                     'newmenu=arx;',...
                     'set(bptmenu,''enable'',''off'');',...
                     'help5={pur2,'''',help5};',...
                     'helpstr=help5;',...
                     'set(arx,''enable'',''on'');',...
                     'set(helpsign,''visible'',''on'');',...
                     'set(h,''label'',''New Help'');']);
      

                   
pureasubmenu=uimenu(purebpmenu,'label','adaptive lr','separator','on',...
                     'callback',[...
                     'set(flayertxt,''enable'',''on'');',...
                     'set(slayertxt,''enable'',''off'');',...   
                     'algorithm=''bptra'';myenableof(''slayer3'');',...
                     'myenableon(''flayer3'');',...
                     'myenableon(''popmax_epoch'');myenableon(''poplr_inc'');',...
                     'myenableon(''poplr_dec'');myenableon(''poperr_ratio'');',...
                     'myenableof(''popmom_const'');',...
                     'myenableon(''pop_lr'');myenableon(''poperr_goal'');',...
                     'newmenu=arx;',...
                     'set(bptmenu,''enable'',''off'');',...
                     'help5={pura2,'''',help5};',...
                     'helpstr=help5;',...
                     'set(arx,''enable'',''on'');',...
                     'set(helpsign,''visible'',''on'');',...
                     'set(h,''label'',''New Help'');']);
      

momensubmenu=uimenu(momenbpmenu,'label','constant lr','separator','on',...
                     'callback',[...
                     'set(flayertxt,''enable'',''on'');',...
                     'set(slayertxt,''enable'',''off'');',...   
                     'algorithm=''bptrm'';',...
                     'myenableon(''flayer3'');',...
                     'myenableon(''popmax_epoch'');myenableon(''popmom_const'');',...
                     'myenableof(''poplr_inc'');myenableof(''poplr_dec'');',...
                     'myenableof(''poperr_ratio'');myenableof(''slayer3'');',...
                     'myenableon(''pop_lr'');myenableon(''poperr_goal'');',...
                     'newmenu=arx;',...
                     'set(bptmenu,''enable'',''off'');',...
                     'help5={mom2,'''',help5};',...
                     'helpstr=help5;',...
                     'set(arx,''enable'',''on'');',...
                     'set(helpsign,''visible'',''on'');',...
                     'set(h,''label'',''New Help'');']);


momenasubmenu=uimenu(momenbpmenu,'label','adaptive lr','separator','on',...
                     'callback',[...
                     'set(flayertxt,''enable'',''on'');',...
                     'set(slayertxt,''enable'',''off'');',...   
                     'algorithm=''bptrx'';myenableof(''slayer3'');',...
                     'myenableon(''flayer3'');',...
                     'myenableon(''popmax_epoch'');myenableon(''poplr_inc'');',...
                     'myenableon(''poplr_dec'');myenableon(''poperr_ratio'');',...
                     'myenableon(''popmom_const'');',...
                     'myenableon(''pop_lr'');myenableon(''poperr_goal'');',...
                     'newmenu=arx;',...
                     'set(bptmenu,''enable'',''off'');',...
                     'help5={moma2,'''',help5};',...
                     'helpstr=help5;',...
                     'set(arx,''enable'',''on'');',...
                     'set(helpsign,''visible'',''on'');',...
                     'set(h,''label'',''New Help'');']);
      

nolayer=2;
puresubmenu3=uimenu(purebpmenu2,'label','constant lr','separator','on',...
                     'callback',[...
                     'set(flayertxt,''enable'',''on'');',...
                     'set(slayertxt,''enable'',''on'');',...   
                     'algorithm=''bptr3'';',...
                     'nolayer=3;',...
                     'myenableon(''flayer3'');',...
                     'myenableon(''popmax_epoch'');myenableon(''slayer3'');',...
                     'myenableof(''poplr_inc'');myenableof(''poplr_dec'');',...
                     'myenableof(''poperr_ratio'');myenableon(''slayer3'');',...
                     'myenableof(''popmom_const'');',...
                     'myenableon(''pop_lr'');myenableon(''poperr_goal'');',...
                     'newmenu=arx;',...
                     'set(bptmenu,''enable'',''off'');',...
                     'help5={pur3,'''',help5};',...
                     'helpstr=help5;',...
                     'set(arx,''enable'',''on'');',...
                     'set(helpsign,''visible'',''on'');',...
                     'set(h,''label'',''New Help'');']);
      
      
pureasubmenu3=uimenu(purebpmenu2,'label','adaptive lr','separator','on',...
                     'callback',[...
                     'set(flayertxt,''enable'',''on'');',...
                     'set(slayertxt,''enable'',''on'');',...   
                     'algorithm=''bptra3'';myenableon(''slayer3'');',...
                     'myenableon(''flayer3'');',...
                     'nolayer=3;',...
                     'myenableon(''popmax_epoch'');myenableon(''poplr_inc'');',...
                     'myenableon(''poplr_dec'');myenableon(''poperr_ratio'');',...
                     'myenableof(''popmom_const'');',...
                     'myenableon(''pop_lr'');myenableon(''poperr_goal'');',...
                     'newmenu=arx;',...
                     'set(bptmenu,''enable'',''off'');',...
                     'help5={pura3,'''',help5};',...
                     'helpstr=help5;',...
                     'set(arx,''enable'',''on'');',...
                     'set(helpsign,''visible'',''on'');',...
                     'set(h,''label'',''New Help'');']);
      
momensubmenu3=uimenu(momenbpmenu2,'label','constant lr','separator','on',...
                     'callback',[...
                     'set(flayertxt,''enable'',''on'');',...
                     'set(slayertxt,''enable'',''on'');',...   
                     'algorithm=''bptrm3'';myenableon(''slayer3'');',...
                     'myenableon(''flayer3'');',...
                     'nolayer=3;',...
                     'myenableon(''popmax_epoch'');myenableon(''popmom_const'');',...
                     'myenableof(''poplr_inc'');myenableof(''poplr_dec'');',...
                     'myenableof(''poperr_ratio'');',...
                     'myenableon(''pop_lr'');myenableon(''poperr_goal'');',...
                     'newmenu=arx;',...
                     'set(bptmenu,''enable'',''off'');',...
                     'help5={mom3,'''',help5};',...
                     'helpstr=help5;',...
                     'set(arx,''enable'',''on'');',...
                     'set(helpsign,''visible'',''on'');',...
                     'set(h,''label'',''New Help'');']);
      
momenasubmenu3=uimenu(momenbpmenu2,'label','adaptive lr','separator','on',...
                     'callback',[...
                     'set(flayertxt,''enable'',''on'');',...
                     'set(slayertxt,''enable'',''on'');',...   
                     'algorithm=''bptrx3'';myenableon(''slayer3'');',...
                     'myenableon(''flayer3'');',...
                     'nolayer=3;',...
                     'myenableon(''popmax_epoch'');myenableon(''poplr_inc'');',...
                     'myenableon(''poplr_dec'');myenableon(''poperr_ratio'');',...
                     'myenableon(''popmom_const'');',...
                     'myenableon(''pop_lr'');myenableon(''poperr_goal'');',...
                     'newmenu=arx;',...
                     'set(bptmenu,''enable'',''off'');',...
                     'help5={moma3,'''',help5};',...
                     'helpstr=help5;',...
                     'set(arx,''enable'',''on'');',...
                     'set(helpsign,''visible'',''on'');',...
                     'set(h,''label'',''New Help'');']);
      

% Network configuration menu


flayertxt=uicontrol(figmain,'style','text',...
   'enable','off',...
   'units','norm',...
   'string',[num2str(s1),' nodes in the first layer'],...
   'pos',[0.30    0.03    0.15  0.07],...
   'back',[0.5689 0.4578 0.6933]);
slayertxt=uicontrol(figmain,'style','text',...
   'enable','off',...
   'units','norm',...
   'string',[num2str(s2),' nodes in the second layer'],...
   'pos',[0.5    0.03    0.2    0.07],...
   'back',[0.5689 0.4578 0.6933]);
   
arx=uimenu(figmain,'label','network configuration','enable','off',...
   'call',[...
      'set(fch,''checked'',''off'');',...
      'set(sch,''checked'',''off'');',...
      'set(reset_in,''enable'',''off'');',...
      'helpstr=help6;',...
      'set(helpsign,''visible'',''on'');',...
      'set(h,''label'',''New Help'');']);


fch=[];
sch=[];
fcheck=0;
scheck=0;
flayer3=uimenu(arx,'separator','on','label','first hidden layer',...
   'enable','off');
slayer3=uimenu(arx,'checked','off','label','second hidden layer',...
   'enable','off');

first1=uimenu(flayer3,'label','1 neuron','call',[...
      'set(fch,''checked'',''off'');set(first1,''checked'',''on''),',...
      'set(flayertxt,''string'',''1 nodes in the first layer'');',...
      'fcheck=1;',...
      'if (scheck==1) | (nolayer==2);',...
      'set(start,''enable'',''on'');',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help8;set(h,''label'',''New Help'');end;',...      
      's1=1;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
fch=[fch first1];
first2=uimenu(flayer3,'label','2 neurons','separator','on','call',[...
      'set(fch,''checked'',''off'');set(first2,''checked'',''on''),',...
      'set(flayertxt,''string'',''2 nodes in the first layer'');',...
      'fcheck=1;',...
      'if (scheck==1) | (nolayer==2);',...
      'set(start,''enable'',''on'');',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help8;set(h,''label'',''New Help'');end;',...
      's1=2;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
fch=[fch first2];
first3=uimenu(flayer3,'label','3 neurons','checked','off','separator','on','call',[...
      'set(fch,''checked'',''off'');set(first3,''checked'',''on''),',...
      'set(flayertxt,''string'',''3 nodes in the first layer'');',...
      'fcheck=1;',...
      'if (scheck==1) | (nolayer==2);',...
      'set(start,''enable'',''on'');',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help8;set(h,''label'',''New Help'');end;',...
      's1=3;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
fch=[fch first3];
first4=uimenu(flayer3,'label','4 neurons','checked','off','separator','on','call',[...
      'set(fch,''checked'',''off'');set(first4,''checked'',''on''),',...
      'set(flayertxt,''string'',''4 nodes in the first layer'');',...
      'fcheck=1;',...
      'if (scheck==1) | (nolayer==2);',...
      'set(start,''enable'',''on'');',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help8;set(h,''label'',''New Help'');end;',...
      's1=4;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
fch=[fch first4];
first5=uimenu(flayer3,'label','5 neurons','checked','off','separator','on','call',[...
      'set(fch,''checked'',''off'');set(first5,''checked'',''on''),',...
      'set(flayertxt,''string'',''5 nodes in the first layer'');',...
      'fcheck=1;',...
      'if (scheck==1) | (nolayer==2);',...
      'set(start,''enable'',''on'');',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help8;set(h,''label'',''New Help'');end;',...
      's1=5;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
fch=[fch first5];
first6=uimenu(flayer3,'label','6 neurons','checked','off','separator','on','call',[...
      'set(fch,''checked'',''off'');set(first6,''checked'',''on''),',...
      'set(flayertxt,''string'',''6 nodes in the first layer'');',...
      'fcheck=1;',...
      'if (scheck==1) | (nolayer==2);',...
      'set(start,''enable'',''on'');',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help8;set(h,''label'',''New Help'');end;',...
      's1=6;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
fch=[fch first6];
first7=uimenu(flayer3,'label','7 neurons','checked','off','separator','on','call',[...
      'set(fch,''checked'',''off'');set(first7,''checked'',''on''),',...
      'set(flayertxt,''string'',''7 nodes in the first layer'');',...
      'fcheck=1;',...
      'if (scheck==1) | (nolayer==2);',...
      'set(start,''enable'',''on'');',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help8;set(h,''label'',''New Help'');end;',...
      's1=7;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
fch=[fch first7];
first10=uimenu(flayer3,'label','10 neurons','checked','off','separator','on','call',[...
      'set(fch,''checked'',''off'');set(first10,''checked'',''on''),',...
      'set(flayertxt,''string'',''10 nodes in the first layer'');',...
      'fcheck=1;',...
      'if (scheck==1) | (nolayer==2);',...
      'set(start,''enable'',''on'');',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help8;set(h,''label'',''New Help'');end;',...
      's1=10;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
fch=[fch first10];
first15=uimenu(flayer3,'label','15 neurons','checked','off','separator','on','call',[...
      'set(fch,''checked'',''off'');set(first15,''checked'',''on''),',...
      'set(flayertxt,''string'',''15 nodes in the first layer'');',...
      'fcheck=1;',...
      'if (scheck==1) | (nolayer==2);',...
      'set(start,''enable'',''on'');',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help8;set(h,''label'',''New Help'');end;',...
      's1=15;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
fch=[fch first15];
first20=uimenu(flayer3,'label','20 neurons','checked','off','separator','on','call',[...
      'set(fch,''checked'',''off'');set(first20,''checked'',''on''),',...
      'set(flayertxt,''string'',''20 nodes in the first layer'');',...
      'fcheck=1,',...
      'scheck,',...
      'if (scheck==1) | (nolayer==2);',...
      'set(start,''enable'',''on'');',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help8;set(h,''label'',''New Help'');end;',...
      's1=20;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
fch=[fch first20];

second2=uimenu(slayer3,'checked','off','label','2 neurons','call',[...
      'set(sch,''checked'',''off'');set(second2,''checked'',''on''),',...
      'set(slayertxt,''string'',''2 nodes in the second layer'');',...
      'scheck=1,',...
      'if fcheck==1,',...
      'set(start,''enable'',''on'');',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help7;set(h,''label'',''New Help'');end;',...
      's2=2;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
sch=[sch second2];
second3=uimenu(slayer3,'checked','off','label','3 neurons','separator','on','call',[...
      'set(sch,''checked'',''off'');set(second3,''checked'',''on''),',...
      'set(slayertxt,''string'',''3 nodes in the second layer'');',...
      's2=3;',...
      'scheck=1;',...
      'if fcheck==1,',...
      'set(start,''enable'',''on'');',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help7;set(h,''label'',''New Help'');end;',...
    '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
sch=[sch second3];
second4=uimenu(slayer3,'checked','off','label','4 neurons','separator','on','call',[...
      'set(sch,''checked'',''off'');set(second4,''checked'',''on''),',...
      'set(slayertxt,''string'',''4 nodes in the second layer'');',...
      's2=4;',...
      'scheck=1;',...
      'if fcheck==1,',...
      'set(start,''enable'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help7;set(h,''label'',''New Help'');end;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
sch=[sch second4];
second5=uimenu(slayer3,'checked','off','label','5 neurons','separator','on','call',[...
      'set(sch,''checked'',''off'');set(second5,''checked'',''on''),',...
      'set(slayertxt,''string'',''5 nodes in the second layer'');',...
      's2=5;',...
      'scheck=1;',...
      'if fcheck==1,',...
      'set(start,''enable'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help7;set(h,''label'',''New Help'');end;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
sch=[sch second5];
second6=uimenu(slayer3,'checked','off','label','6 neurons','separator','on','call',[...
      'set(sch,''checked'',''off'');set(second6,''checked'',''on''),',...
      'set(slayertxt,''string'',''6 nodes in the second layer'');',...
      's2=6;',...
      'scheck=1;',...
      'if fcheck==1,',...
      'set(start,''enable'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help7;set(h,''label'',''New Help'');end;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
sch=[sch second6];
second7=uimenu(slayer3,'checked','off','label','7 neurons','separator','on','call',[...
      'set(sch,''checked'',''off'');set(second7,''checked'',''on''),',...
      'set(slayertxt,''string'',''7 nodes in the second layer'');',...
      's2=7;',...
      'scheck=1;',...
      'if fcheck==1,',...
      'set(start,''enable'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help7;set(h,''label'',''New Help'');end;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
sch=[sch second7];
second8=uimenu(slayer3,'checked','off','label','8 neurons','separator','on','call',[...
      'set(sch,''checked'',''off'');set(second8,''checked'',''on''),',...
      'set(slayertxt,''string'',''8 nodes in the second layer'');',...
      's2=8;',...
      'scheck=1;',...
      'if fcheck==1,',...
      'set(start,''enable'',''on'');',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help7;set(h,''label'',''New Help'');end;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
sch=[sch second8];
second9=uimenu(slayer3,'checked','off','label','9 neurons','separator','on','call',[...
      'set(sch,''checked'',''off'');set(second9,''checked'',''on''),',...
      'set(slayertxt,''string'',''9 nodes in the second layer'');',...
      's2=9;',...
      'scheck=1;',...
      'if fcheck==1,',...
      'set(start,''enable'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help7;set(h,''label'',''New Help'');end;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
sch=[sch second9];
second15=uimenu(slayer3,'checked','off','label','15 neurons','separator','on','call',[...
      'set(sch,''checked'',''off'');set(second9,''checked'',''on''),',...
      'set(slayertxt,''string'',''15 nodes in the second layer'');',...
      's2=15;',...
      'scheck=1;',...
      'if fcheck==1,',...
      'set(start,''enable'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help7;set(h,''label'',''New Help'');end;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
sch=[sch second15];
second20=uimenu(slayer3,'checked','off','label','20 neurons','separator','on','call',[...
      'set(sch,''checked'',''off'');set(second9,''checked'',''on''),',...
      'set(slayertxt,''string'',''20 nodes in the second layer'');',...
      's2=20;',...
      'scheck=1;',...
      'if fcheck==1,',...
      'set(start,''enable'',''on'');',...
      'helpstr=help9;set(h,''label'',''New Help'');',...
      'set(helpsign,''visible'',''on'');',...
      'else,',...
      'set(helpsign,''visible'',''on'');',...
      'helpstr=help7;set(h,''label'',''New Help'');end;',...
      '[wt1 bt1]=arx1hl;[wt2 bt2]=arx2hl;']);
sch=[sch second20];
h=uimenu(figmain,'label','New Help','call',[...
      'hlp=helpdlg(helpstr);set(h,''label'',''Help'');',...
      'set(helpsign,''visible'',''off'');',...
      'if main==3;gcf=figure(figt3);gcf=figure(hlp);end']);

bm=uimenu(figmain,'label','Back to main menu','call','prdemo');
global wt1 wt2 bt1 bt2
%pop menus               
               


%global max_epoch
tmax_epoch=uicontrol(figmain,...
   'style','text',...
   'string','max epoch',...
   'units','norm',...
   'back',[0.5689 0.4578 0.6933],...
   'pos',[0.0863    0.95    0.1162    0.03]);
popmax_epoch=uicontrol(figmain,...
   'style','popup',...
   'enable','off',...
   'string','ep=800|ep=100|ep=800|ep=1000|ep=1500|ep=3000|ep=5000|ep=10000|ep=20000',...
   'units','normalized',...
   'position',[0.0863    0.94    0.1162    0.001],...
   'userdata',[800  ;100  ; 800 ; 1000; 1500; 3000; 5000;10000;20000],...
   'callback',[...
         'max_ep=get(popmax_epoch,''userdata'');',...
         'max_epoch=max_ep(get(popmax_epoch,''value''));',...
         'global max_epoch']);   





   %global lr
tlr=uicontrol(figmain,...
   'style','text',...
   'string','learning rate',...
   'units','norm',...
   'back',[0.5689 0.4578 0.6933],...
   'pos',[0.2013    0.95    0.1162    0.03]);
   
pop_lr=uicontrol(figmain,...
   'style','popup',...
   'enable','off',...   
   'string','lr=0.01|lr=0.02|lr=0.05|lr=0.08|lr=0.1|lr=0.2|lr=0.3|lr=0.4|lr=0.5|lr=0.6|lr=0.7|lr=0.9|lr=1|lr=1.5',...
   'units','normalized',...
   'position',[0.2013    0.94    0.1162    0.001],...
   'userdata',[0.01;0.02;0.05;0.08;0.1 ;0.2 ;0.3 ;0.4 ;0.5 ;0.6 ;0.7 ;0.9 ;1   ;1.5 ],...
   'callback',[...
         'lr_t=get(pop_lr,''userdata'');',...
         'lr=lr_t(get(pop_lr,''value''));',...
         'global lr']);   





   %global err_goal
terr_goal=uicontrol(figmain,...
   'style','text',...
   'string','error goal',...
   'units','norm',...
   'back',[0.5689 0.4578 0.6933],...
   'pos',[0.3163    0.95    0.1162    0.03]);
   
poperr_goal=uicontrol(figmain,...
   'style','popup',...
   'enable','off',...   
   'string','err_g=0.01|err_g=10|err_g=1|err_g=0.1|err_g=0.05|err_g=0.01|err_g=0.005|err_g=0.001|err_g=0.0001|err_g=0.00001',...
   'units','normalized',...
   'position',[0.3163    0.94    0.1162    0.001],...
   'userdata',[0.1    ;10     ;1      ;0.1    ;0.05   ;0.01   ;0.005  ;0.001  ;0.0001 ;0.00001],...
   'callback',[...
         'err_go=get(poperr_goal,''userdata'');',...
         'err_goal=err_go(get(poperr_goal,''value''));',...
         'global err_goal']);   




   %global mom_const
tmom_const=uicontrol(figmain,...
   'style','text',...
   'string','momentum',...
   'units','norm',...
   'back',[0.5689 0.4578 0.6933],...
   'pos',[0.4313    0.95    0.1162    0.03]);
   
popmom_const=uicontrol(figmain,...
   'style','popup',...
   'enable','off',...   
   'string','mom=0.8|mom=0.1|mom=0.2|mom=0.3|mom=0.4|mom=0.5|mom=0.6|mom=0.65|mom=0.7|mom=0.75|mom=0.8|mom=0.85|mom=0.9|mom=0.95',...
   'units','normalized',...
   'position',[0.4313    0.94    0.1162    0.001],...
   'userdata',[0.8 ;0.1 ;0.2 ;0.3 ;0.4 ;0.5 ;0.6 ;0.65;0.7 ;0.75;0.8 ;0.85;0.9 ;0.95],...
   'callback',[...
         'mom_c=get(popmom_const,''userdata'');',...
         'mom_const=mom_c(get(popmom_const,''value''));',...
         'global mom_const']);   




   %global lr_inc
tlr_inc=uicontrol(figmain,...
   'style','text',...
   'string','lr increase',...
   'units','norm',...
   'back',[0.5689 0.4578 0.6933],...
   'pos',[0.5463    0.95    0.1162    0.03]);
   
poplr_inc=uicontrol(figmain,...
   'style','popup',...
   'enable','off',...   
   'string','lr_inc=5%|lr_inc=0.5%|lr_inc=1%|lr_inc=2%|lr_inc=3%|lr_inc=4%|lr_inc=5%|lr_inc=6%|lr_inc=8%|lr_inc=9%|lr_inc=10%|lr_inc=15%',...
   'units','normalized',...
   'position',[0.5463    0.94    0.1162    0.001],...
   'userdata',[1.05 ;1.005;1.01 ;1.02 ;1.03 ;1.04 ;1.05 ;1.06 ;1.08 ;1.09 ;1.1  ;1.15 ],...
         'callback',[...
         'lr_i=get(poplr_inc,''userdata'');',...
         'lr_inc=lr_i(get(poplr_inc,''value''));',...
         'global lr_inc']);





   %global err_ratio
terr_ratio=uicontrol(figmain,...
   'style','text',...
   'string','error ratio',...
   'units','norm',...
   'back',[0.5689 0.4578 0.6933],...
   'pos',[0.7772    0.95    0.1162    0.03]);
   
poperr_ratio=uicontrol(figmain,...
   'style','popup',...
   'enable','off',...   
   'string','err_r=1.05|err_r=0.9|err_r=0.92|err_r=0.95|err_r=0.98|err_r=1|err_r=1.02|err_r=1.04|err_r=1.05|err_r=1.08|err_r=1.1',...
   'units','normalized',...
   'position',[0.7772    0.94    0.1168    0.001],...
   'userdata',[1.05;0.9 ;0.92;0.95;0.98;1   ;1.02;1.04;1.05;1.08;1.1 ],...
   'callback',[...
         'err_r=get(poperr_ratio,''userdata'');',...
         'err_ratio=err_r(get(poperr_ratio,''value''));',...
         'global err_ratio']);




   %global lr_dec
tlr_dec=uicontrol(figmain,...
   'style','text',...
   'string','lr decrease',...
   'units','norm',...
   'back',[0.5689 0.4578 0.6933],...
   'pos',[0.6613    0.95    0.1162    0.03]);
   
poplr_dec=uicontrol(figmain,...
   'style','popup',...
   'enable','off',...   
   'string','lr_dec=20%|lr_dec=0.5%|lr_dec=1%|lr_dec=5%|lr_dec=8%|lr_dec=10%|lr_dec=15%|lr_dec=20%|lr_dec=25%|lr_dec=30%|lr_dec=35%|lr_dec=40%',...
   'units','normalized',...
   'position',[0.6613    0.94    0.1180    0.001],...
   'userdata',[0.8  ;0.995;0.99 ;0.95 ;0.92;0.9  ;0.85 ;0.8  ;0.75 ;0.7  ;0.65 ;0.6  ;],...
   'callback',[...
         'lr_d=get(poplr_dec,''userdata'');',...
         'lr_dec=lr_d(get(poplr_dec,''value''));',...
         'global lr_dec']);      
   
ab={'This demo includes a set of '
   'MATLAB examples, associated with'
   'the book Pattern Recognition.   '
   '        '
   'The demo is being used only for '
   'educational purposes in the dept.'
   'of Informatics, University of Athens.'
   'for any questions suggestions  or'
   'problems contact the author of the'
   'book: stpatrec@di.uoa.gr'};

about=uimenu(figmain,'label','About','call','msgbox(ab,''About'')');
