(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    153802,       4168]*)
(*NotebookOutlinePosition[    154679,       4198]*)
(*  CellTagsIndexPosition[    154635,       4194]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Drawing Schematics of Filters and Systems", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["Prof. Dr Miroslav D. Lutovac and Prof. Dr Dejan V. Tosic", "Subsubtitle",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["Info", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
(*  DrawMath                                                      
 Schematic generated from DrawFilt version 2.8                    
                                                                  
 Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic   
 lutovac@kondor.etf.bg.ac.yu  http://kondor.etf.bg.ac.yu/~lutovac/
 tosic@galeb.etf.bg.ac.yu     http://www.rcub.bg.ac.yu/~tosicde/  
 Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic       
 $Revision: 2.8 $  $Date: 2005/03/04                              
                                                                  
   Reference:                                                     
   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans            
        Filter Design for Signal Processing                       
           Using MATLAB and Mathematica                           
        Prentice Hall    ISBN 0-201-36130-2                       
                                                                *)\
\>", "Info",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
Initialize: Copy drawflib.mma from DrawFilt to working directory (folder)\
\>", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
SetDirectory[\"c:\\\\afd\\\\drawfilt\"];                            
<<drawflib.mma                                                 
<<untitled.mma                                          \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["Schematic", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["DrawMath[0,0,1,5,10];", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .3741 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.034087 0.0274066 -0.0322028 0.0274066 [
[.02381 .35149 -11.375 -6.625 ]
[.02381 .35149 0 6.625 ]
[.1026 .35834 0 0 ]
[.1026 .35834 20.4375 13.25 ]
[.1026 .34464 0 -13.25 ]
[.1026 .34464 6.5 0 ]
[.14508 .35286 0 0 ]
[.14508 .35286 6.5 13.25 ]
[.26248 .36519 0 0 ]
[.26248 .36519 6.5 13.25 ]
[.22593 .28297 -6.5 -6.625 ]
[.22593 .28297 0 6.625 ]
[.25334 .28297 -8.4375 -6.625 ]
[.25334 .28297 0 6.625 ]
[.25334 .28297 0 0 ]
[.25334 .28297 16.5625 12.125 ]
[.26248 .22816 0 0 ]
[.26248 .22816 6.5 13.25 ]
[.26248 .17335 0 0 ]
[.26248 .17335 6.5 13.25 ]
[.22593 .09113 -6.5 -6.625 ]
[.22593 .09113 0 6.625 ]
[.25334 .09113 -8.4375 -6.625 ]
[.25334 .09113 0 6.625 ]
[.25334 .09113 0 0 ]
[.25334 .09113 16.5625 12.125 ]
[.26248 .03631 0 0 ]
[.26248 .03631 6.5 13.25 ]
[.18482 .1665 0 0 ]
[.18482 .1665 21.625 13.25 ]
[.18482 .15279 0 -13.25 ]
[.18482 .15279 6.5 0 ]
[.32186 .22131 -21.0625 0 ]
[.32186 .22131 0 13.25 ]
[.32186 .20761 -6.5 -13.25 ]
[.32186 .20761 0 0 ]
[.32186 .02946 -21.0625 0 ]
[.32186 .02946 0 13.25 ]
[.32186 .01576 -6.5 -13.25 ]
[.32186 .01576 0 0 ]
[.36434 .35286 0 0 ]
[.36434 .35286 6.5 13.25 ]
[.36434 .21583 0 0 ]
[.36434 .21583 6.5 13.25 ]
[.14508 .16101 0 0 ]
[.14508 .16101 6.5 13.25 ]
[.97619 .35149 0 -6.625 ]
[.97619 .35149 11.375 6.625 ]
[.43148 .1665 0 0 ]
[.43148 .1665 21.625 13.25 ]
[.43148 .15279 0 -13.25 ]
[.43148 .15279 6.5 0 ]
[.50914 .17335 0 0 ]
[.50914 .17335 6.5 13.25 ]
[.50914 .22816 0 0 ]
[.50914 .22816 6.5 13.25 ]
[.47259 .28297 -6.5 -6.625 ]
[.47259 .28297 0 6.625 ]
[.5 .28297 -8.4375 -6.625 ]
[.5 .28297 0 6.625 ]
[.5 .28297 0 0 ]
[.5 .28297 16.5625 12.125 ]
[.50914 .36519 0 0 ]
[.50914 .36519 6.5 13.25 ]
[.39174 .35286 0 0 ]
[.39174 .35286 6.5 13.25 ]
[.47259 .09113 -6.5 -6.625 ]
[.47259 .09113 0 6.625 ]
[.5 .09113 -8.4375 -6.625 ]
[.5 .09113 0 6.625 ]
[.5 .09113 0 0 ]
[.5 .09113 16.5625 12.125 ]
[.50914 .03631 0 0 ]
[.50914 .03631 6.5 13.25 ]
[.56852 .22131 -21.0625 0 ]
[.56852 .22131 0 13.25 ]
[.56852 .20761 -6.5 -13.25 ]
[.56852 .20761 0 0 ]
[.56852 .02946 -21.0625 0 ]
[.56852 .02946 0 13.25 ]
[.56852 .01576 -6.5 -13.25 ]
[.56852 .01576 0 0 ]
[.39174 .16101 0 0 ]
[.39174 .16101 6.5 13.25 ]
[.611 .35286 0 0 ]
[.611 .35286 6.5 13.25 ]
[.611 .21583 0 0 ]
[.611 .21583 6.5 13.25 ]
[.7558 .22816 0 0 ]
[.7558 .22816 6.5 13.25 ]
[.71925 .28297 -6.5 -6.625 ]
[.71925 .28297 0 6.625 ]
[.74666 .28297 -8.4375 -6.625 ]
[.74666 .28297 0 6.625 ]
[.74666 .28297 0 0 ]
[.74666 .28297 16.5625 12.125 ]
[.7558 .36519 0 0 ]
[.7558 .36519 6.5 13.25 ]
[.6384 .35286 0 0 ]
[.6384 .35286 6.5 13.25 ]
[.81518 .22131 -21.0625 0 ]
[.81518 .22131 0 13.25 ]
[.81518 .20761 -6.5 -13.25 ]
[.81518 .20761 0 0 ]
[.8974 .35834 0 0 ]
[.8974 .35834 20.4375 13.25 ]
[.8974 .34464 0 -13.25 ]
[.8974 .34464 6.5 0 ]
[.85766 .35286 0 0 ]
[.85766 .35286 6.5 13.25 ]
[.67814 .1665 0 0 ]
[.67814 .1665 16.5 13.25 ]
[.67814 .15279 0 -13.25 ]
[.67814 .15279 6.5 0 ]
[ 0 0 0 0 ]
[ 1 .3741 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.06149 .35149 m
.04779 .35149 L
s
newpath
.04094 .35149 .00685 0 365.73 arc
s
gsave
.02381 .35149 -72.375 -10.625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
70.375 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.11174 .35149 m
.09347 .36519 L
.09347 .33779 L
.11174 .35149 L
.14371 .35149 L
s
.06149 .35149 m
.09347 .35149 L
s
gsave
.1026 .35834 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(s_) show
71.938 13.875 moveto
(1) show
79.438 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.1026 .34464 -61 -17.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
3 Mabswid
.14371 .35149 Mdot
gsave
.14508 .35286 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
newpath
.25334 .35149 .0137 0 365.73 arc
s
.24649 .35149 m
.26019 .35149 L
.25334 .35149 L
.25334 .35834 L
.25334 .34464 L
s
gsave
.26248 .36519 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.27161 .35377 m
.27618 .35149 L
.27161 .34921 L
s
.26704 .35149 m
.28075 .35149 L
s
.25334 .36519 Mdot
.2305 .35377 m
.23507 .35149 L
.2305 .34921 L
s
.22593 .35149 m
.23964 .35149 L
s
.25106 .32865 m
.25334 .33322 L
.25562 .32865 L
s
.25334 .32408 m
.25334 .33779 L
s
.25334 .24186 m
.25334 .26242 L
.2739 .26242 L
.2739 .30353 L
.23279 .30353 L
.23279 .26242 L
.2739 .26242 L
.2739 .30353 L
.25334 .30353 L
.25334 .32408 L
s
.25677 .25214 m
.25334 .25899 L
.24991 .25214 L
s
gsave
.22593 .28297 -67.5 -10.625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.25334 .28297 -69.4375 -10.625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
67.438 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.25334 .28297 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.750 13.000 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
75.563 13.000 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
newpath
.25334 .21446 .0137 0 365.73 arc
s
.24649 .21446 m
.26019 .21446 L
.25334 .21446 L
.25334 .22131 L
.25334 .20761 L
s
gsave
.26248 .22816 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.27618 .21674 m
.27161 .21446 L
.27618 .21217 L
s
.26704 .21446 m
.28075 .21446 L
s
.27161 .21902 m
.27618 .21902 L
s
.25106 .23273 m
.25334 .2373 L
.25562 .23273 L
s
.25334 .24186 m
.25334 .22816 L
s
.23964 .21446 Mdot
.25106 .19162 m
.25334 .19619 L
.25562 .19162 L
s
.25334 .18705 m
.25334 .20075 L
s
newpath
.25334 .15964 .0137 0 365.73 arc
s
.24649 .15964 m
.26019 .15964 L
.25334 .15964 L
.25334 .1665 L
.25334 .15279 L
s
gsave
.26248 .17335 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.26704 .15964 Mdot
.25106 .17791 m
.25334 .18248 L
.25562 .17791 L
s
.25334 .18705 m
.25334 .17335 L
s
.2305 .16193 m
.23507 .15964 L
.2305 .15736 L
s
.22593 .15964 m
.23964 .15964 L
s
.25106 .1368 m
.25334 .14137 L
.25562 .1368 L
s
.25334 .13224 m
.25334 .14594 L
s
.25334 .05002 m
.25334 .07057 L
.2739 .07057 L
.2739 .11168 L
.23279 .11168 L
.23279 .07057 L
.2739 .07057 L
.2739 .11168 L
.25334 .11168 L
.25334 .13224 L
s
.25677 .06029 m
.25334 .06715 L
.24991 .06029 L
s
gsave
.22593 .09113 -67.5 -10.625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.25334 .09113 -69.4375 -10.625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
67.438 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.25334 .09113 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.750 13.000 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
75.563 13.000 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
newpath
.25334 .02261 .0137 0 365.73 arc
s
.24649 .02261 m
.26019 .02261 L
.25334 .02261 L
.25334 .02946 L
.25334 .01576 L
s
gsave
.26248 .03631 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.27618 .02489 m
.27161 .02261 L
.27618 .02033 L
s
.26704 .02261 m
.28075 .02261 L
s
.27161 .02718 m
.27618 .02718 L
s
.25106 .04088 m
.25334 .04545 L
.25562 .04088 L
s
.25334 .05002 m
.25334 .03631 L
s
.2305 .02489 m
.23507 .02261 L
.2305 .02033 L
s
.22593 .02261 m
.23964 .02261 L
s
.25334 .00891 Mdot
.19396 .15964 m
.17569 .17335 L
.17569 .14594 L
.19396 .15964 L
.22593 .15964 L
s
.14371 .15964 m
.17569 .15964 L
s
gsave
.18482 .1665 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(b_) show
73.125 13.875 moveto
(1) show
80.625 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.18482 .15279 -61 -17.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.31272 .21446 m
.33099 .22816 L
.33099 .20075 L
.31272 .21446 L
.28075 .21446 L
s
.36297 .21446 m
.33099 .21446 L
s
gsave
.32186 .22131 -82.0625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a_) show
72.563 13.875 moveto
(1) show
80.063 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.32186 .20761 -67.5 -17.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.31272 .02261 m
.33099 .03631 L
.33099 .00891 L
.31272 .02261 L
.28075 .02261 L
s
.36297 .02261 m
.33099 .02261 L
s
gsave
.32186 .02946 -82.0625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a_) show
72.563 13.875 moveto
(2) show
80.063 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.32186 .01576 -67.5 -17.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
3 Mabswid
.36297 .35149 Mdot
gsave
.36434 .35286 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.36297 .21446 Mdot
gsave
.36434 .21583 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
.36297 .35149 m
.36297 .21446 L
s
.36297 .21446 m
.36297 .02261 L
s
3 Mabswid
.14371 .15964 Mdot
gsave
.14508 .16101 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
.14371 .35149 m
.14371 .15964 L
s
.14371 .35149 m
.22593 .35149 L
s
.28075 .35149 m
.36297 .35149 L
s
.14371 .15964 m
.14371 .02261 L
.22593 .02261 L
s
.93851 .35149 m
.95221 .35149 L
s
newpath
.95906 .35149 .00685 0 365.73 arc
s
gsave
.97619 .35149 -61 -10.625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.063 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
70.375 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.36297 .35149 m
.39037 .35149 L
s
.39037 .35149 m
.39037 .15964 L
s
.44062 .15964 m
.42235 .17335 L
.42235 .14594 L
.44062 .15964 L
.47259 .15964 L
s
.39037 .15964 m
.42235 .15964 L
s
gsave
.43148 .1665 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(b_) show
73.125 13.875 moveto
(2) show
80.625 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.43148 .15279 -61 -17.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
newpath
.5 .15964 .0137 0 365.73 arc
s
.49315 .15964 m
.50685 .15964 L
.5 .15964 L
.5 .1665 L
.5 .15279 L
s
gsave
.50914 .17335 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5137 .15964 Mdot
.49772 .17791 m
.5 .18248 L
.50228 .17791 L
s
.5 .18705 m
.5 .17335 L
s
.47716 .16193 m
.48173 .15964 L
.47716 .15736 L
s
.47259 .15964 m
.4863 .15964 L
s
.49772 .1368 m
.5 .14137 L
.50228 .1368 L
s
.5 .13224 m
.5 .14594 L
s
newpath
.5 .21446 .0137 0 365.73 arc
s
.49315 .21446 m
.50685 .21446 L
.5 .21446 L
.5 .22131 L
.5 .20761 L
s
gsave
.50914 .22816 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.52284 .21674 m
.51827 .21446 L
.52284 .21217 L
s
.5137 .21446 m
.52741 .21446 L
s
.51827 .21902 m
.52284 .21902 L
s
.49772 .23273 m
.5 .2373 L
.50228 .23273 L
s
.5 .24186 m
.5 .22816 L
s
.4863 .21446 Mdot
.49772 .19162 m
.5 .19619 L
.50228 .19162 L
s
.5 .18705 m
.5 .20075 L
s
.5 .24186 m
.5 .26242 L
.52055 .26242 L
.52055 .30353 L
.47945 .30353 L
.47945 .26242 L
.52055 .26242 L
.52055 .30353 L
.5 .30353 L
.5 .32408 L
s
.50343 .25214 m
.5 .25899 L
.49657 .25214 L
s
gsave
.47259 .28297 -67.5 -10.625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .28297 -69.4375 -10.625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
67.438 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .28297 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.750 13.000 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
75.563 13.000 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
newpath
.5 .35149 .0137 0 365.73 arc
s
.49315 .35149 m
.50685 .35149 L
.5 .35149 L
.5 .35834 L
.5 .34464 L
s
gsave
.50914 .36519 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.51827 .35377 m
.52284 .35149 L
.51827 .34921 L
s
.5137 .35149 m
.52741 .35149 L
s
.5 .36519 Mdot
.47716 .35377 m
.48173 .35149 L
.47716 .34921 L
s
.47259 .35149 m
.4863 .35149 L
s
.49772 .32865 m
.5 .33322 L
.50228 .32865 L
s
.5 .32408 m
.5 .33779 L
s
3 Mabswid
.39037 .35149 Mdot
gsave
.39174 .35286 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
.39037 .35149 m
.47259 .35149 L
s
.5 .05002 m
.5 .07057 L
.52055 .07057 L
.52055 .11168 L
.47945 .11168 L
.47945 .07057 L
.52055 .07057 L
.52055 .11168 L
.5 .11168 L
.5 .13224 L
s
.50343 .06029 m
.5 .06715 L
.49657 .06029 L
s
gsave
.47259 .09113 -67.5 -10.625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .09113 -69.4375 -10.625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
67.438 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .09113 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.750 13.000 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
75.563 13.000 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
newpath
.5 .02261 .0137 0 365.73 arc
s
.49315 .02261 m
.50685 .02261 L
.5 .02261 L
.5 .02946 L
.5 .01576 L
s
gsave
.50914 .03631 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.52284 .02489 m
.51827 .02261 L
.52284 .02033 L
s
.5137 .02261 m
.52741 .02261 L
s
.51827 .02718 m
.52284 .02718 L
s
.49772 .04088 m
.5 .04545 L
.50228 .04088 L
s
.5 .05002 m
.5 .03631 L
s
.47716 .02489 m
.48173 .02261 L
.47716 .02033 L
s
.47259 .02261 m
.4863 .02261 L
s
.5 .00891 Mdot
.39037 .15964 m
.39037 .02261 L
.47259 .02261 L
s
.55938 .21446 m
.57765 .22816 L
.57765 .20075 L
.55938 .21446 L
.52741 .21446 L
s
.60963 .21446 m
.57765 .21446 L
s
gsave
.56852 .22131 -82.0625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a_) show
72.563 13.875 moveto
(3) show
80.063 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.56852 .20761 -67.5 -17.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.55938 .02261 m
.57765 .03631 L
.57765 .00891 L
.55938 .02261 L
.52741 .02261 L
s
.60963 .02261 m
.57765 .02261 L
s
gsave
.56852 .02946 -82.0625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a_) show
72.563 13.875 moveto
(4) show
80.063 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.56852 .01576 -67.5 -17.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
3 Mabswid
.39037 .15964 Mdot
gsave
.39174 .16101 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
.60963 .21446 m
.60963 .02261 L
s
.52741 .35149 m
.60963 .35149 L
s
3 Mabswid
.60963 .35149 Mdot
gsave
.611 .35286 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
.60963 .35149 m
.60963 .21446 L
s
3 Mabswid
.60963 .21446 Mdot
gsave
.611 .21583 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
.60963 .35149 m
.63703 .35149 L
s
newpath
.74666 .21446 .0137 0 365.73 arc
s
.73981 .21446 m
.75351 .21446 L
.74666 .21446 L
.74666 .22131 L
.74666 .20761 L
s
gsave
.7558 .22816 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.7695 .21674 m
.76493 .21446 L
.7695 .21217 L
s
.76036 .21446 m
.77407 .21446 L
s
.76493 .21902 m
.7695 .21902 L
s
.74438 .23273 m
.74666 .2373 L
.74894 .23273 L
s
.74666 .24186 m
.74666 .22816 L
s
.73296 .21446 Mdot
.74438 .19162 m
.74666 .19619 L
.74894 .19162 L
s
.74666 .18705 m
.74666 .20075 L
s
.74666 .24186 m
.74666 .26242 L
.76721 .26242 L
.76721 .30353 L
.7261 .30353 L
.7261 .26242 L
.76721 .26242 L
.76721 .30353 L
.74666 .30353 L
.74666 .32408 L
s
.75009 .25214 m
.74666 .25899 L
.74323 .25214 L
s
gsave
.71925 .28297 -67.5 -10.625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.74666 .28297 -69.4375 -10.625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
67.438 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.74666 .28297 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
68.750 13.000 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
75.563 13.000 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 9.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
newpath
.74666 .35149 .0137 0 365.73 arc
s
.73981 .35149 m
.75351 .35149 L
.74666 .35149 L
.74666 .35834 L
.74666 .34464 L
s
gsave
.7558 .36519 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.76493 .35377 m
.7695 .35149 L
.76493 .34921 L
s
.76036 .35149 m
.77407 .35149 L
s
.74666 .36519 Mdot
.72382 .35377 m
.72839 .35149 L
.72382 .34921 L
s
.71925 .35149 m
.73296 .35149 L
s
.74438 .32865 m
.74666 .33322 L
.74894 .32865 L
s
.74666 .32408 m
.74666 .33779 L
s
.63703 .35149 m
.71925 .35149 L
s
3 Mabswid
.63703 .35149 Mdot
gsave
.6384 .35286 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
.80604 .21446 m
.82431 .22816 L
.82431 .20075 L
.80604 .21446 L
.77407 .21446 L
s
.85629 .21446 m
.82431 .21446 L
s
gsave
.81518 .22131 -82.0625 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a_) show
72.563 13.875 moveto
(5) show
80.063 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.81518 .20761 -67.5 -17.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.85629 .21446 m
.85629 .35149 L
s
.77407 .35149 m
.85629 .35149 L
s
.90653 .35149 m
.88826 .36519 L
.88826 .33779 L
.90653 .35149 L
.93851 .35149 L
s
.85629 .35149 m
.88826 .35149 L
s
gsave
.8974 .35834 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(s_) show
71.938 13.875 moveto
(2) show
79.438 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.8974 .34464 -61 -17.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
3 Mabswid
.85629 .35149 Mdot
gsave
.85766 .35286 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
.63703 .35149 m
.63703 .15964 L
s
.68728 .15964 m
.66901 .17335 L
.66901 .14594 L
.68728 .15964 L
.71925 .15964 L
s
.63703 .15964 m
.66901 .15964 L
s
gsave
.67814 .1665 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(b3) show
75.500 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.67814 .15279 -61 -17.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.875 moveto
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
65.500 13.875 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.71925 .15964 m
.74666 .15964 L
.74666 .18705 L
s
0 0 m
1 0 L
1 .3741 L
0 .3741 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{500.625, 187.063},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000;^000162000`400?l00000o`00003oo`3ooooo
0?oooo00oooo003o0?ooool0ooool03oool00?l0ooooo`3oooo`0?ooo`00o`3ooooo0?oooo00oooo
003o0?ooool0ooool03oool00?l0ooooo`3oooo`0?ooo`00o`3ooooo0?oooo00oooo003o0?ooool0
ooool03oool00?l0ooooo`3oooo`0?ooo`00o`3ooooo0?oooo00oooo003o0?ooool0ooool03oool0
0?l0ooooo`3oooo`0?ooo`00o`3ooooo0?oooo00oooo003o0?ooool0ooool03oool00?l0ooooo`3o
ooo`0?ooo`00c03oool500000340oooo00<000000?ooo`3oool0L03oool500000380oooo00<00000
0?ooo`3oool0o`3ooom00?ooo`00b03oool4000000D0oooo00<000000?ooo`3oool0;@3oool20000
06l0oooo0`0000050?ooo`800000;`3oool200000?l0oooo@P3oool00<L0oooo00<000000?ooo`3o
ool0203oool2000002`0oooo00<000000?ooo`000000K@3oool2000000X0oooo0P00000[0?ooo`80
000000<0oooo0000003oool0o`3ooom10?ooo`00aP3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo02L0oooo0P0000020?ooo`030000003oool0oooo06X0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0W0?ooo`050000003oool0oooo0?ooo`000000o`3ooom20?ooo`00
aP3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0oooo@03oool00<D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02@0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`0S0?ooo`8000001@3oool00`000000oooo0?oo
o`3o0?oood00oooo00340?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0J03oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool08P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo@03oool00<@0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0240oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool0o`3ooom00?ooo`00_P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01P0
oooo0P0000080?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0H0?ooo`8000002@3oool00`000000oooo0?ooo`3o0?oood00oooo002o0?ooo`800000
0`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool0
oooo0P00000J0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0H`3oool2000000<0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo0?oo
o`8000006P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0?l0oooo@03oool00880
oooo@`0000030?ooo`/00000103ooolP000000/0oooo5`00000B0?oood<00000103oool:000000@0
oooo8000000<0?oooaL00000o`3oool/0?ooo`00PP3oool00`000000oooo0?ooo`0i0?ooo`800000
103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
0`3oool2000001T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0>@3oool2000000@0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0080oooo0P00000I0?ooo`800000
2P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<0
00000?ooo`3oool0?`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool07`3oool2000000P0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0?`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool0oooo1000
000L0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`060?ooo`040000003oool0oooo0?ooo`@00000703oool2000000L0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`3o0?ooobX0oooo00220?ooo`030000003oool0oooo0400oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02<0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool0@03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0903oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool0o`3ooolZ0?ooo`00PP3oool00`000000oooo0?ooo`100?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool0903oool2000000@0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`3o0?ooobX0oooo00220?ooo`030000003oool0oooo0440oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0W0?ooo`050000003oool0oooo0?ooo`0000005@3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0W0?ooo`8000000`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0@P3oool2000000T0oooo0P00000C0?oo
o`P00000403oool010000000oooo0?ooo`00000E0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0@`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0140oooo2000000A
0?ooo`040000003oool0oooo000001D0oooo00<000000?ooo`3oool0o`3ooolZ0?ooo`00PP3oool0
0`000000oooo0?ooo`140?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0;03oool3
000001D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`140?ooo`8000001P3oool2
000002h0oooo0`00000E0?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?oo
o`3oool0A@3oool700000340oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo04H0oooo1P00000b0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool0o`3ooolZ0?ooo`00PP3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0180
oooo1@0000080?ooo`D00000903oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0
oooo00<000000?ooo`3oool04P3oool5000000/0oooo00<000000?ooo`3oool0903oool00`000000
oooo0?ooo`3o0?ooobX0oooo00220?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0
4@3oool01@000000oooo0?ooo`3oool0000000T0oooo00D000000?ooo`3oool0oooo0000000T0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0A0?oo
o`050000003oool0oooo0?ooo`000000303oool00`000000oooo0?ooo`0T0?ooo`030000003oool0
oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0A`3oool2000000030?ooo`000000oooo
0100oooo00D000000?ooo`3oool0oooo0000000:0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`170?ooo`80000000<0oooo0000003oool0403oool0
1@000000oooo0?ooo`3oool0000000`0oooo00<000000?ooo`3oool0903oool00`000000oooo0?oo
o`3o0?ooobX0oooo00220?ooo`030000003oool0oooo04L0oooo0`00000C0?ooo`@000002`3oool0
0`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0A`3oool3
000001<0oooo100000080?ooo`H000009@3oool00`000000oooo0?ooo`3o0?ooobX0oooo00220?oo
o`030000003oool0oooo04P0oooo0P00000F0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool08`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo0P00000F0?oo
o`030000003oool0oooo00H0oooo00D000000?ooo`3oool0oooo0000000V0?ooo`030000003oool0
oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0A0?oo
o`050000003oool0oooo0?ooo`000000303oool00`000000oooo0?ooo`0S0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0A0?ooo`050000003oool0
oooo0?ooo`0000002@3oool010000000oooo0?ooo`00000V0?ooo`030000003oool0oooo0?l0oooo
:P3oool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0B0?ooo`<000003P3o
ool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03o
ool00`000000oooo0?ooo`0B0?ooo`<000002`3oool00`000000oooo0000000V0?ooo`030000003o
ool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0S
0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`18
0?ooo`030000003oool0oooo0200oooo00<000000?ooo`0000009P3oool00`000000oooo0?ooo`3o
0?ooobX0oooo00220?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool07`3oool01@00
0000oooo0?ooo`3oool0000002@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`18
0?ooo`030000003oool0oooo0240oooo0P00000V0?ooo`030000003oool0oooo0?l0oooo:P3oool0
0880oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0P0?ooo`<000009@3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool08P3oool00`00
0000oooo0?ooo`0T0?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3o
ool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool0B03oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo
00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0?l0oooo
:P3oool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`030000003o
ool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`18
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`19
0?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0B03oool00`00
0000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`00
0000oooo0?ooo`190?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3o
ool0AP3oool00`000000oooo000000020?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`160?ooo`030000003oool000000080oooo00<000000?ooo`3o
ool0AP3oool00`000000oooo0?ooo`3o0?ooobX0oooo00220?ooo`030000003oool0oooo04H0oooo
00D000000?ooo`000000oooo000000180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool0AP3oool01@000000oooo0000003oool0000004T0oooo00<000000?ooo`3oool0o`3ooolZ0?oo
o`00PP3oool00`000000oooo0?ooo`170?ooo`80000000<0oooo0000003oool0A`3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo04L0oooo0P0000000`3oool000000?ooo`180?ooo`03
0000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0A`3oool3000004T0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`170?ooo`<00000BP3oool00`000000oooo
0?ooo`3o0?ooobX0oooo00220?ooo`030000003oool0oooo04P0oooo0P0000190?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0B03oool2000004X0oooo00<000000?ooo`3oool0o`3o
oolZ0?ooo`00PP3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04P0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04T0oooo00<00000
0?ooo`3oool0o`3ooolZ0?ooo`00PP3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo
04P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo
04T0oooo00<000000?ooo`3oool0o`3ooolZ0?ooo`00PP3oool00`000000oooo0?ooo`0j0?oooad0
0000?03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03X0oooo7P00000l0?ooo`03
0000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0>P3oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0j0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo
0?ooo`3o0?ooobX0oooo00220?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0o`3o
oolZ0?ooo`00PP3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01T0oooo00<00000
0?ooo`3oool0>P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03X0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0?l0oooo:P3oool0
0880oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
01X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`3o0?ooobX0oooo00220?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0J0?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool0o`3ooolZ0?ooo`00PP3oool00`000000oooo
0?ooo`0j0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0>P3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool06P3oool00`000000oooo
0?ooo`0j0?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`3o0?ooobX0oooo00220?ooo`030000003oool0oooo03X0oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0>P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo03X0oooo00<00000
0?ooo`3oool0o`3ooolZ0?ooo`00PP3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo01X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`3o0?ooobX0
oooo00220?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool00P3oool600000140oooo
00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03X0oooo
00<000000?ooo`3oool00P3oool600000180oooo00<000000?ooo`3oool0>P3oool00`000000oooo
0?ooo`3o0?ooobX0oooo00220?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool00`3o
ool01@000000oooo0?ooo`3oool000000140oooo00<000000?ooo`3oool0>P3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool00`3oool01@000000oooo
0?ooo`3oool000000180oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`3o0?ooobX0
oooo00220?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`0B0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0j0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04`3oool00`000000oooo
0?ooo`0j0?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0o`3o
oolZ0?ooo`00PP3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0>P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool0>P3oool00`000000oooo0?ooo`3o0?ooobX0oooo00220?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00000B0?ooo`030000003oool0
oooo03X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0j0?ooo`030000003oool0
oooo00<0oooo00@000000?ooo`3oool000004`3oool00`000000oooo0?ooo`0j0?ooo`030000003o
ool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`03
0?ooo`D000004@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0>P3oool00`000000oooo0?ooo`030?ooo`D000004P3oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0>P3oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0j0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0>P3oool00`00
0000oooo0?ooo`3o0?ooobX0oooo00220?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool06@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool0>P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool0o`3ooolZ0?ooo`00PP3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01T0oooo
0`00000j0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0>P3oool00`000000oooo
0?ooo`0I0?ooo`<00000>`3oool00`000000oooo0?ooo`3o0?ooobX0oooo00220?ooo`030000003o
ool0oooo03X0oooo00<000000?ooo`3oool06@3oool2000003/0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`3o0?ooobX0oooo00220?ooo`030000003oool0oooo03X0oooo00<00000
0?ooo`3oool06@3oool2000003/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`3o
0?ooobX0oooo00220?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool03`3oool70000
00<0oooo0P00000k0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0>P3oool00`00
0000oooo0?ooo`0?0?ooo`L00000103oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0I0?ooo`80
0000>`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool06P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo
00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0I0?ooo`800000>`3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool06P3oool00`000000oooo
0?ooo`0j0?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`0I0?ooo`800000>`3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo03X0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0j0?ooo`030000003o
ool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0I
0?ooo`800000>`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03X0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0?l0oooo:P3oool0
0880oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0I0?ooo`800000>`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool06@3oool20000
03`0oooo00<000000?ooo`3oool0o`3ooolZ0?ooo`00PP3oool00`000000oooo0?ooo`0j0?oooah0
0000>`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03X0oooo7P00000l0?ooo`03
0000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo
0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo
0?ooo`190?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0B03o
ool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03o
ool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<00000
0?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0?l0oooo:P3oool0
0880oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo
0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`03
0000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo
0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo
0?ooo`190?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0B03o
ool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03o
ool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<00000
0?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0?l0oooo:P3oool0
0880oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo
0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`03
0000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo
0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo
0?ooo`190?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0B03o
ool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03o
ool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<00000
0?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0?l0oooo:P3oool0
0880oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo
0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`03
0000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo
0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo
0?ooo`190?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool0A`3o
ool2000000030?ooo`000000oooo04L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`170?ooo`80000000<0oooo0000003oool0B03oool00`000000oooo0?ooo`3o0?ooobX0oooo0022
0?ooo`030000003oool0oooo04L0oooo0`0000190?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0A`3oool3000004X0oooo00<000000?ooo`3oool0o`3ooolZ0?ooo`00PP3oool00`00
0000oooo0?ooo`180?ooo`800000B@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
04P0oooo0P00001:0?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3o
ool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool0B03oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0?l0oooo:P3oool00880oooo
00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0?l0oooo
:P3oool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`030000003o
ool0oooo0?l0oooo:P3oool00880oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0a
0?ooo`<00000B@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool0<@3oool3000004X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`3o
0?ooo`80oooo00220?ooo`030000003oool0oooo01<0oooo0P00000^0?ooo`@000000`3oool30000
04H0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0C0?ooo`800000;`3oool30000
00<0oooo100000160?ooo`030000003oool0oooo02D0oooo0P00003o0?ooo`<0oooo00220?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`000000;03oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo04<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0C0?ooo`04
0000003oool00000000002`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`130?oo
o`030000003oool0oooo02D0oooo00@000000?ooo`0000000000o`3oool10?ooo`00PP3oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo00800000:P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo0480oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0C0?oo
o`050000003oool0oooo0?ooo`000000:P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo0480oooo00<000000?ooo`3oool09@3oool01@000000oooo0?ooo`3oool000000?l0oooo0022
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0o03oool00880oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02@0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0400oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00<0oooo0P00000U0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`100?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool00`3oool200000?`0oooo00220?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0R0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`100?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0240oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo0400oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0?T0oooo00220?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0
9@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0?P0oooo00210?ooo`8000005@3o
ool00`000000oooo0?ooo`060?ooo`8000006`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0o0?ooo`030000003o
ool0oooo00l0oooo0P00000E0?ooo`030000003oool0oooo00L0oooo0P00000J0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo0400oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`070?ooo`800000n03o
ool00800oooo1000000D0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool06@3oool2
000000<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo03h0oooo00<000000?ooo`3oool03P3oool4000001@0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0H0?ooo`8000000`3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0m@3oool00800oooo6@00000;0?ooob4000000`3oool;0000
00@0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0>0?oooaT00000303ooolP0000
00@0oooo2P0000040?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0403ooolF0000
00`0oooo:P00003=0?ooo`00P@3oool2000001D0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0H0?ooo`800000103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0?0?ooo`8000005@3oool00`000000
oooo0?ooo`080?ooo`8000006@3oool2000000@0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0B0?ooo`030000003oool0oooo00P0oooo0P00000Y0?ooo`030000003oool0oooo0</0
oooo00220?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool01P3oool200000240oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo03l0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0</0oooo
00220?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0Q0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`0o0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04`3oool00`000000oooo0?oo
o`050?ooo`8000008`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool0@03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool01@3oool2000002`0oooo00<000000?ooo`3oool0b`3oool00880oooo00<00000
0?ooo`3oool04`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02<0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0400oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool08`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0@@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo0</0oooo00220?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool00P3oool2000002H0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02D0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02d0oooo00<000000?oo
o`3oool0b`3oool00880oooo00<000000?ooo`3oool04`3oool01@000000oooo0?ooo`3oool00000
02T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool04`3oool010000000oooo0?ooo`3oool2000002T0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool04P3oool010000000oooo0?ooo`3oool200000300oooo00<000000?ooo`3oool0b`3o
ool00880oooo00<000000?ooo`3oool04`3oool010000000oooo0?ooo`00000<0?ooo`P000005`3o
ool2000000T0oooo0P0000140?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04`3o
ool010000000oooo0?ooo`00000<0?ooo`P00000603oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo04<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0B0?ooo`040000
003oool0oooo00000380oooo00<000000?ooo`3oool0b`3oool00880oooo00<000000?ooo`3oool0
4`3oool3000002h0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`140?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool04`3oool3000002h0oooo0P0000060?ooo`800000
AP3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0180oooo0`00000c0?ooo`030000
003oool0oooo0</0oooo00220?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0;`3o
ool7000004L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo0300oooo1P0000180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo0</0oooo00220?ooo`030000003oool0
oooo01h0oooo0`00000<0?ooo`<00000603oool00`000000oooo0?ooo`180?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool07P3oool3000000`0oooo1@00000F0?ooo`030000003oool0
oooo04T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0N0?ooo`<000000`3oool4
00000200oooo00<000000?ooo`3oool0b`3oool00880oooo00<000000?ooo`3oool07@3oool01@00
0000oooo0?ooo`3oool0000000`0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`18
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool07@3oool01@000000oooo0?ooo`3o
ool0000000/0oooo00D000000?ooo`3oool0oooo0000000F0?ooo`030000003oool0oooo04T0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M0?ooo`050000003oool0oooo0?ooo`00
00001P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0</0oooo00220?ooo`030000
003oool0oooo01d0oooo00D000000?ooo`3oool0oooo0000000<0?ooo`030000003oool0oooo01H0
oooo0P0000000`3oool000000?ooo`170?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool07@3oool01@000000oooo0?ooo`3oool0000000`0oooo00<000000?ooo`3oool05P3oool20000
00030?ooo`000000oooo04P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M0?oo
o`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0
oooo0</0oooo00220?ooo`030000003oool0oooo01d0oooo00D000000?ooo`3oool0oooo0000000<
0?ooo`030000003oool0oooo01H0oooo0`0000190?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool07@3oool01@000000oooo0?ooo`3oool0000000d0oooo00<000000?ooo`3oool05@3o
ool3000004X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M0?ooo`050000003o
ool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0</0oooo
00220?ooo`030000003oool0oooo01d0oooo00D000000?ooo`3oool0oooo0000000<0?ooo`030000
003oool0oooo01L0oooo0P0000190?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
7@3oool01@000000oooo0?ooo`3oool0000000h0oooo00<000000?ooo`3oool05@3oool2000004X0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M0?ooo`050000003oool0oooo0?oo
o`0000001P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0</0oooo00220?ooo`03
0000003oool0oooo01d0oooo0P0000020?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool07@3oool200000080oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0E0?ooo`03
0000003oool0oooo04T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M0?ooo`80
00000P3oool00`000000oooo0?ooo`020?ooo`800000803oool00`000000oooo0?ooo`3;0?ooo`00
PP3oool00`000000oooo0?ooo`0M0?ooo`040000003oool00000000000d0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool07@3oool010000000oooo00000000000@0?ooo`030000003oool0oooo01@0oooo00<000000?oo
o`3oool0B@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01d0oooo00@000000?oo
o`00000000001P3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo0</0oooo00220?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo04P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M0?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`190?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool0b`3oool00880oooo00<000000?ooo`3o
ool07@3oool00`000000oooo0?ooo`0=0?ooo`8000006@3oool00`000000oooo0?ooo`180?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0=0?ooo`05
0000003oool0oooo0?ooo`0000005P3oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo
0?ooo`0000007`3oool00`000000oooo0?ooo`3;0?ooo`00PP3oool00`000000oooo0?ooo`0L0?oo
o`800000403oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo04P0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0L0?ooo`800000403oool3000001L0oooo00<000000?oo
o`3oool0B@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01`0oooo0P0000070?oo
o`<00000803oool00`000000oooo0?ooo`3;0?ooo`00PP3oool00`000000oooo0?ooo`0M0?ooo`03
0000003oool0oooo02P0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`190?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0X0?ooo`03
0000003oool0oooo0</0oooo00220?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0
B03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0
B@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0
b`3oool00880oooo00<000000?ooo`3oool0A`3oool2000000030?ooo`000000oooo04L0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`170?ooo`80000000<0oooo0000003oool0B03o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04H0oooo00@000000?ooo`0000000000
c03oool00880oooo00<000000?ooo`3oool0A`3oool3000004T0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`170?ooo`<00000BP3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo04L0oooo0`00003<0?ooo`00PP3oool00`000000oooo0?ooo`180?ooo`800000B@3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo0P00001:0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0A`3oool200000<d0oooo00220?ooo`030000003oool0oooo
04P0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
04P0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
04P0oooo00<000000?ooo`3oool0b`3oool00880oooo00<000000?ooo`3oool0B03oool00`000000
oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000
oooo0?ooo`190?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000
oooo0?ooo`3;0?ooo`00PP3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04P0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04T0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0</0oooo
00220?ooo`030000003oool0oooo04D0oooo1`00000a0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`150?ooo`L00000<P3oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0A@3oool600000380oooo00<0
00000?ooo`3oool0UP3oool00880oooo00<000000?ooo`3oool0@`3oool2000000L0oooo00<00000
0?ooo`3oool0;@3oool2000001D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`14
0?ooo`030000003oool0oooo00D0oooo0P00000^0?ooo`<000005@3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo04<0oooo0P0000060?ooo`800000;`3oool2000009P0oooo00220?oo
o`030000003oool0oooo0480oooo00<000000?ooo`3oool0203oool2000002/0oooo0P0000000`3o
ool000000?ooo`0D0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0@P3oool20000
00X0oooo0P00000[0?ooo`040000003oool0oooo000001D0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`120?ooo`030000003oool0oooo00P0oooo0P00000[0?ooo`80000000<0oooo
0000003oool0U`3oool00880oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo02L0oooo00D000000?ooo`3oool0oooo0000000E0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo02H0oooo0P0000030?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`110?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool09`3oool0
1@000000oooo0?ooo`3oool0000009P0oooo00220?ooo`030000003oool0oooo0440oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0@@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0UP3oool00880oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool08`3oool2000000D0oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0400oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo02<0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0?`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool08`3oool2000000D0oooo00<000000?ooo`3oool0UP3oool00880oooo00<000000?ooo`3o
ool0?`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool08@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`0Q0?ooo`8000001`3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo09H0oooo00220?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
?`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
803oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
UP3oool00880oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool00P3oool2000001T0oooo0P0000090?ooo`030000003o
ool0oooo01<0oooo0P00000A0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0080oooo0P00000I0?ooo`8000002P3o
ool00`000000oooo0?ooo`0B0?ooo`8000004P3oool00`000000oooo0?ooo`0n0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`8000006P3o
ool2000000T0oooo00<000000?ooo`3oool0UP3oool00880oooo00<000000?ooo`3oool0?`3oool0
10000000oooo0?ooo`3oool;000000@0oooo8000000;0?oooaT00000403oool00`000000oooo0?oo
o`0o0?ooo`030000003oool0oooo0080oooo2P0000040?ooob000000303ooolH00000140oooo00<0
00000?ooo`3oool0?P3oool00`000000oooo0?ooo`020?ooo`X00000103ooolQ000000/0oooo5`00
00220?ooo`00PP3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01P3oool2000000<0oooo0P00000J0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool04P3oool400000100oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool0oooo0P00000J0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool04@3oool400000140oooo00<000000?ooo`3oool0?P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool0oooo
0P00000K0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool04`3oool00`000000oooo
0?ooo`200?ooo`00PP3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0C0?ooo`8000004@3oool00`000000oooo0?oo
o`0o0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo01P0oooo0P0000090?ooo`030000003oool0oooo0180oooo0P00
000B0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0P03oool00880oooo00<00000
0?ooo`3oool0?`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00@00000
0?ooo`3oool0oooo1000000K0?ooo`8000001`3oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00H0oooo00@000000?ooo`3oool0oooo1000000L0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03l0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo0?ooo`@0
0000703oool2000000L0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`200?ooo`00
PP3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
?`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
8`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
P03oool00880oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`100?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0T0?ooo`8000001@3o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0@03o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0903o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0P03o
ool00880oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo02L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo0800oooo00220?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0W0?ooo`050000003oool0oooo0?ooo`0000005@3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0X
0?ooo`050000003oool0oooo0?ooo`0000005@3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0440oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0X0?ooo`050000003o
ool0oooo0?ooo`0000005@3oool00`000000oooo0?ooo`200?ooo`00PP3oool00`000000oooo0?oo
o`120?ooo`8000002@3oool2000001<0oooo2000000@0?ooo`80000000<0oooo0000003oool0503o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0A0?ooo`P000004@3oool2000000030?ooo`000000oooo01@0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool04@3oool800000140oooo0P0000000`3oool000000?ooo`0D0?ooo`030000003o
ool0oooo0800oooo00220?ooo`030000003oool0oooo04@0oooo0`0000030?ooo`<00000;`3oool2
000001D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`140?ooo`<000000`3oool4
000002l0oooo0P00000E0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0@`3oool4
00000080oooo1000000_0?ooo`8000005@3oool00`000000oooo0?ooo`200?ooo`00PP3oool00`00
0000oooo0?ooo`170?ooo`<00000<`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0A`3oool3000003@0oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo04L0oooo0P00000d0?ooo`030000003oool0oooo
01<0oooo00<000000?ooo`3oool0P03oool00880oooo00<000000?ooo`3oool0B03oool00`000000
oooo0?ooo`0B0?ooo`D000002@3oool3000002D0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`180?ooo`030000003oool0oooo0180oooo1@0000080?ooo`@000009P3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool04@3oool5000000P0
oooo0`00000W0?ooo`030000003oool0oooo0800oooo00220?ooo`030000003oool0oooo04P0oooo
00<000000?ooo`3oool04@3oool01@000000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3o
ool0903oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3o
ool04@3oool01@000000oooo0?ooo`3oool0000000d0oooo00<000000?ooo`3oool08`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0403oool01@00
0000oooo0?ooo`3oool0000000`0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`20
0?ooo`00PP3oool00`000000oooo0?ooo`170?ooo`80000000<0oooo0000003oool0403oool01@00
0000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo04L0oooo0P0000000`3oool000000?ooo`0@0?ooo`050000003oool0
oooo0?ooo`0000003@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool0AP3oool010000000oooo00000000000A0?ooo`050000003oool0oooo0?ooo`00
00003@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0800oooo00220?ooo`030000
003oool0oooo04L0oooo0`00000C0?ooo`@000002`3oool00`000000oooo0?ooo`0T0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0A`3oool3000001<0oooo1000000=0?ooo`030000
003oool0oooo02<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`170?ooo`<00000
4P3oool4000000d0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`200?ooo`00PP3o
ool00`000000oooo0?ooo`180?ooo`8000005P3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo02@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`180?ooo`8000005P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`170?ooo`8000005P3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo02<0oooo00<000000?ooo`3oool0P03oool00880oooo00<000000?ooo`3oool0B03oool0
0`000000oooo0?ooo`0A0?ooo`050000003oool0oooo0?ooo`0000002`3oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?oo
o`0A0?ooo`050000003oool0oooo0?ooo`0000002`3oool2000002H0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00D000000?ooo`3oool0
oooo0000000<0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0P03oool00880oooo
00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0B0?ooo`<00000303oool00`000000oooo
0?ooo`0T0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo
0?ooo`0B0?ooo`<000003@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0A0?ooo`<000002P3oool3000002L0oooo
00<000000?ooo`3oool0P03oool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo0?oo
o`0Q0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`180?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo0800oooo00220?ooo`030000003oool0oooo04P0oooo00<00000
0?ooo`3oool0803oool2000002H0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`18
0?ooo`030000003oool0oooo01l0oooo00D000000?ooo`3oool0oooo0000000U0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0O0?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool0P03oool00880oooo00<000000?ooo`3oool0B03oool0
0`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`180?ooo`030000003oool0oooo0200oooo0`00000V0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0P0?ooo`<000009@3oool0
0`000000oooo0?ooo`200?ooo`00PP3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo
04P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo
04T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo
04P0oooo00<000000?ooo`3oool0P03oool00880oooo00<000000?ooo`3oool0B03oool00`000000
oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000
oooo0?ooo`190?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000
oooo0?ooo`180?ooo`030000003oool0oooo0800oooo00220?ooo`030000003oool0oooo04P0oooo
00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo
00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo
00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`200?ooo`00PP3oool00`000000oooo0?oo
o`180?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`180?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`180?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0P03oool00880oooo00<00000
0?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0800oooo00220?oo
o`030000003oool0oooo04H0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`150?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool0AP3oool00`000000oooo000000020?oo
o`030000003oool0oooo04H0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`150?oo
o`060000003oool0oooo0000003oool00000B03oool00`000000oooo0?ooo`200?ooo`00PP3oool0
0`000000oooo0?ooo`160?ooo`050000003oool000000?ooo`000000B03oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo04H0oooo00D000000?ooo`000000oooo000000190?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0AP3oool01@000000oooo0000003oool0000004P0
oooo00<000000?ooo`3oool0P03oool00880oooo00<000000?ooo`3oool0A`3oool2000000030?oo
o`000000oooo04L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`170?ooo`800000
00<0oooo0000003oool0B03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04H0oooo
00@000000?ooo`0000000000B@3oool00`000000oooo0?ooo`200?ooo`00PP3oool00`000000oooo
0?ooo`170?ooo`<00000B@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04L0oooo
0`00001:0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0A`3oool3000004T0oooo
00<000000?ooo`3oool0P03oool00880oooo00<000000?ooo`3oool0B03oool2000004T0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`180?ooo`800000BP3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo04L0oooo0P00001:0?ooo`030000003oool0oooo0800oooo0022
0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`20
0?ooo`00PP3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04P0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04T0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04P0oooo00<000000?oo
o`3oool0P03oool00880oooo00<000000?ooo`3oool0>P3ooolM000003`0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0j0?oooah00000?03oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo03X0oooo7@00000l0?ooo`030000003oool0oooo0800oooo00220?ooo`030000
003oool0oooo03X0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0j0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0J0?ooo`030000
003oool0oooo03X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0j0?ooo`030000
003oool0oooo01T0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`200?ooo`00PP3o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool06P3o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0P03o
ool00880oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo03X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0j0?ooo`030000003oool0
oooo01X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo03X0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0
oooo0800oooo00220?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`0j0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0>P3oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0j0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0>P3oool00`00
0000oooo0?ooo`200?ooo`00PP3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03X0
oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo03X0
oooo00<000000?ooo`3oool0P03oool00880oooo00<000000?ooo`3oool0>P3oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0j0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0j0?ooo`030000003oool0oooo0800oooo00220?ooo`030000003oool0oooo03X0oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool0>P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo03X0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`3oool0>P3oool00`000000oooo0?ooo`200?ooo`00PP3oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0I
0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0P03oool00880oooo00<000000?oo
o`3oool0>P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo03X0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool0>P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03X0oooo00<000000?oo
o`3oool06@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0800oooo00220?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool00P3oool600000140oooo00<000000?ooo`3o
ool0>P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool00P3oool600000180oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo03X0oooo00@000000?ooo`3oool0oooo1P00000B0?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool0P03oool00880oooo00<000000?ooo`3oool0>P3oool00`000000
oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000004@3oool00`000000oooo0?ooo`0j0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`030?oo
o`050000003oool0oooo0?ooo`0000004P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`0000004P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0800oooo0022
0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`20
0?ooo`00PP3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0>P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool0>P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03X0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03X0oooo00<000000?oo
o`3oool0P03oool00880oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo0800oooo00220?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0
0`3oool010000000oooo0?ooo`00000B0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3o
ool000004`3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0>P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000001<0oooo00<00000
0?ooo`3oool0>P3oool00`000000oooo0?ooo`200?ooo`00PP3oool00`000000oooo0?ooo`0j0?oo
o`030000003oool0oooo00<0oooo1@00000A0?ooo`030000003oool0oooo03X0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo00<0oooo1@00000B0?oo
o`030000003oool0oooo03X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0j0?oo
o`030000003oool0oooo0080oooo1@00000B0?ooo`030000003oool0oooo03X0oooo00<000000?oo
o`3oool0P03oool00880oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo01X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo0800oooo00220?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
>P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0
>P3oool00`000000oooo0?ooo`200?ooo`00PP3oool00`000000oooo0?ooo`0j0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo03X0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0j0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo03X0oooo00<000000?ooo`3oool0P03oool00880oooo00<000000?ooo`3oool0>P3oool0
0`000000oooo0?ooo`0I0?ooo`<00000>P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo03X0oooo00<000000?ooo`3oool06@3oool3000003/0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01P0oooo0`00000k0?ooo`030000003oool0
oooo0800oooo00220?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool06@3oool20000
03/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
01X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
0800oooo00220?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool06@3oool2000003/0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01X0
oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03X0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0800
oooo00220?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool03`3oool7000000<0oooo
0P00000k0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0>P3oool00`000000oooo
0?ooo`0?0?ooo`L00000103oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0?0?ooo`L000000`3oool00`000000oooo
0?ooo`0j0?ooo`030000003oool0oooo0800oooo00220?ooo`030000003oool0oooo03X0oooo00<0
00000?ooo`3oool06@3oool2000003/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0j0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`0j0?ooo`030000003oool0oooo0800oooo00220?ooo`030000003oool0oooo03X0oooo00<00000
0?ooo`3oool06@3oool2000003/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo0800oooo00220?ooo`030000003oool0oooo03X0oooo00<000000?oo
o`3oool06@3oool2000003/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0j0?oo
o`030000003oool0oooo01X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo03X0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0j0?oo
o`030000003oool0oooo0800oooo00220?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool06@3oool2000003/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo01X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo0800oooo00220?ooo`030000003oool0oooo03X0oooo7P00000k0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0>P3ooolN000003`0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0j0?oooad00000?03oool00`000000oooo0?ooo`200?ooo`00PP3o
ool00`000000oooo0?ooo`180?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0>@3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0P03o
ool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0
oooo0800oooo00220?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0B03oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0B@3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0B03oool00`00
0000oooo0?ooo`200?ooo`00PP3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04P0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04T0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04P0
oooo00<000000?ooo`3oool0P03oool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo
0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo
0?ooo`190?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo
0?ooo`180?ooo`030000003oool0oooo0800oooo00220?ooo`030000003oool0oooo04P0oooo00<0
00000?ooo`3oool0B03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo00<0
00000?ooo`3oool0B@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo00<0
00000?ooo`3oool0B03oool00`000000oooo0?ooo`200?ooo`00PP3oool00`000000oooo0?ooo`18
0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`18
0?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`18
0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0P03oool00880oooo00<000000?oo
o`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0B03oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0800oooo00220?ooo`03
0000003oool0oooo04P0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo04P0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo04P0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`200?ooo`00
PP3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0
P03oool00880oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003o
ool0oooo0800oooo00220?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0B03oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0B@3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0B03oool0
0`000000oooo0?ooo`200?ooo`00PP3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo
04P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo
04T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo
04P0oooo00<000000?ooo`3oool0P03oool00880oooo00<000000?ooo`3oool0B03oool00`000000
oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000
oooo0?ooo`190?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03oool00`000000
oooo0?ooo`180?ooo`030000003oool0oooo0800oooo00220?ooo`030000003oool0oooo04P0oooo
00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo
00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04P0oooo
00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`200?ooo`00PP3oool00`000000oooo0?oo
o`180?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`180?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`180?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0P03oool00880oooo00<00000
0?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0B03oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0B03oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0800oooo00220?oo
o`030000003oool0oooo04L0oooo0P0000000`3oool000000?ooo`170?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0A`3oool2000000030?ooo`000000oooo04P0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`160?ooo`040000003oool00000000004T0oooo00<00000
0?ooo`3oool0P03oool00880oooo00<000000?ooo`3oool0A`3oool3000004T0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`170?ooo`<00000BP3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo04L0oooo0`0000190?ooo`030000003oool0oooo0800oooo00220?ooo`03
0000003oool0oooo04P0oooo0P0000190?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool0B03oool2000004X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`170?ooo`80
0000BP3oool00`000000oooo0?ooo`200?ooo`00PP3oool00`000000oooo0?ooo`180?ooo`030000
003oool0oooo04P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`180?ooo`030000
003oool0oooo04T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`180?ooo`030000
003oool0oooo04P0oooo00<000000?ooo`3oool0P03oool00880oooo00<000000?ooo`3oool0B03o
ool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03o
ool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0B03o
ool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0800oooo00220?ooo`030000003oool0
oooo04P0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo04P0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo04P0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`200?ooo`00G`3oool00`00
0000oooo0?ooo`0P0?ooo`030000003oool0oooo04D0oooo1`0000170?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0A@3oool7000004P0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`150?ooo`H00000B03oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo
06X0oooo001O0?ooo`<00000803oool00`000000oooo0?ooo`130?ooo`8000001`3oool00`000000
oooo0?ooo`140?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0A03oool00`000000
oooo0?ooo`050?ooo`800000AP3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04<0
oooo0P0000060?ooo`800000AP3oool00`000000oooo0?ooo`0C0?ooo`800000J`3oool005l0oooo
00@000000?ooo`3oool000007`3oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo00P0
oooo0P0000140?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0@P3oool2000000X0
oooo0P0000140?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0@P3oool00`000000
oooo0?ooo`080?ooo`800000A03oool00`000000oooo0?ooo`0C0?ooo`040000003oool000000000
03/0oooo0P00000/0?ooo`00G`3oool010000000oooo0?ooo`3oool2000001d0oooo00<000000?oo
o`3oool0@@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0440oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool0@@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0440oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo01<0oooo00D000000?oo
o`3oool0oooo0000000l0?ooo`030000003oool0oooo02T0oooo001O0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
0440oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
0440oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool0:03oool00280oooo0`000000103oool0000000000000000A0?oo
o`D00000803oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01T0oooo00<000000?oo
o`3oool0@03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0@03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0400oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0400oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool00`3oool2000002L0oooo1@00000>0?ooo`030000003oool0oooo02P0oooo000S0?ooo`05
0000003oool0oooo0?ooo`000000403oool2000000D0oooo00<000000?ooo`3oool07@3oool00`00
0000oooo0?ooo`050?ooo`8000006@3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
03l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
03l0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0280oooo0P0000050?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0:03oool002@0
oooo00<000000?ooo`000000403oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01d0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03l0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo03l0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`000000:@3oool002D0oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0203oool2000001D0oooo
0P00000k0?ooo`800000103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool00P00000l0?ooo`800000403oool2000003/0oooo0P0000040?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`02000003`0oooo
0P00000A0?ooo`800000>P3oool2000000@0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00800000?03oool2000001D0oooo00<000000?ooo`3oool0
1`3oool200000200oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?ooo`030000
003oool0000002T0oooo000T0?ooo`030000003oool000000100oooo00<000000?ooo`3oool01P3o
oolP000000`0ooooF@0000030?ooo`/00000103ooonG000000@0oooo2P0000040?oooiL00000103o
ool:000000@0ooooF@00000;0?ooob400000203oool00`000000oooo0?ooo`080?ooo`050000003o
ool0oooo0?ooo`000000:03oool002<0oooo00D000000?ooo`3oool0oooo0000000?0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo0180oooo1000000k0?ooo`8000000`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00H0oooo0P0000030?ooo`800000>P3oool4000000h0oooo1000000k0?ooo`800000
0`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool0
oooo0P00000j0?ooo`@000003`3oool4000003X0oooo0P0000030?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`3oool2000003X0oooo1000000D0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00P0oooo00D000000?ooo`3oool0oooo0000000X0?ooo`008P3oool30000
00040?ooo`0000000000000000h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0L
0?ooo`030000003oool0oooo00L0oooo0P00000F0?ooo`800000>`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool01@000000oooo0?ooo`3o
ool0000003d0oooo0P00000@0?ooo`800000>`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`00000m0?ooo`800000
4@3oool2000003X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00H0oooo00@000000?ooo`3oool00000?@3oool2000001D0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01`3oool3000000040?ooo`0000000000000002L0oooo000h0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo05T0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo09D0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo09D0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo05H0
oooo00<000000?ooo`3oool01@3oool2000002<0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0f0?ooo`00>03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01d0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2E0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2E0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0903oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo03H0oooo
000i0?ooo`H00000803oool00`000000oooo0?ooo`030?ooo`800000GP3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0UP3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0U`3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo02H0oooo1@00000i0?ooo`00G`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`2G
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0U`3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1U
0?ooo`00G`3oool01@000000oooo0?ooo`3oool000000680oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`2I0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0V@3oool0
0`000000oooo0?ooo`0:0?ooo`800000F@3oool01@000000oooo0?ooo`3oool0000006P0oooo001O
0?ooo`040000003oool00000000000`0oooo2000001@0?ooo`8000002@3oool2000009d0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`2K0?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool0F@3oool010000000oooo00000000000;0?ooo`P00000EP3oool005l0oooo0P00
001X0?ooo`<0000000<0oooo0000003oool00`00002P0?ooo`<000000P3oool5000009l0oooo1000
00000`3oool0000000000003000005`0oooo0P00001[0?ooo`00G`3oool00`000000oooo0?ooo`1Z
0?ooo`<00000YP3oool300000:L0oooo0P00001P0?ooo`030000003oool0oooo06X0oooo001Z0?oo
o`<000002`3oool300000?l0ooooo`3ooolB0?ooo`<000002`3oool500000500oooo001Z0?ooo`04
0000003oool0oooo000000/0oooo00<000000?ooo`3oool0o`3ooooo0?oooa40oooo00@000000?oo
o`3oool000002P3oool01@000000oooo0?ooo`3oool000000500oooo001]0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0o`3ooooo0?oooa@0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`1A0?ooo`00J`3oool2000000`0oooo00<000000?ooo`3oool0o`3ooooo0?oo
oa80oooo0P00000=0?ooo`030000003oool0oooo0500oooo001Z0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0o`3ooooo0?oooa40oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`1?0?ooo`00JP3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0?l0
ooooo`3ooolA0?ooo`040000003oool0oooo000000d0oooo00<000000?ooo`3oool0C`3oool006/0
oooo0`00000;0?ooo`030000003oool0oooo0?l0ooooo`3ooolB0?ooo`<000003P3oool00`000000
oooo0?ooo`1>0?ooo`00N@3oool00`000000oooo0?ooo`3o0?ooool0oooo8`3oool00`000000oooo
0?ooo`1>0?ooo`00N03oool200000?l0ooooo`3ooolQ0?ooo`050000003oool0oooo0?ooo`000000
D03oool007T0oooo00<000000?ooo`3oool0o`3ooooo0?ooob00oooo0`00001A0?ooo`00o`3ooooo
0?oooo00oooo003o0?ooool0ooool03oool00?l0ooooo`3oooo`0?ooo`00o`3ooooo0?oooo00oooo
003o0?ooool0ooool03oool00?l0ooooo`3oooo`0?ooo`00o`3ooooo0?oooo00oooo003o0?ooool0
ooool03oool00?l0ooooo`3oooo`0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 749.938}, {279.563, 0}} -> {-2.93572, 0.693299, \
0.0797497, 0.0797497}}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 681}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{1016, 647},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.5
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 116, 2, 222, "Title"],
Cell[1873, 55, 137, 2, 44, "Subsubtitle"],
Cell[2013, 59, 56, 1, 109, "Section"],
Cell[2072, 62, 1084, 18, 342, "Info"],

Cell[CellGroupData[{
Cell[3181, 84, 133, 3, 148, "Section"],
Cell[3317, 89, 270, 6, 87, "Input"]
}, Open  ]],
Cell[3602, 98, 61, 1, 109, "Section"],

Cell[CellGroupData[{
Cell[3688, 103, 71, 1, 41, "Input"],
Cell[3762, 106, 150024, 4059, 293, 73679, 3112, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

