% scalbut.m  GENERATE BUTTONS: ALBUM OF SC FILTER REALIZATIONS (script)
%            Album of Analog SC Filter Realizations
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 

x0 = 0; y0 = 0; dx = 2; ds = 2.5; F  = 10;
pathnamea = lower(pwd);
pathnameaopamp = lower([pathnamea '\album\opamp']);
pathnameasc = lower([pathnamea '\album\sc']);
pathnameaota = lower([pathnamea '\album\ota']);
pathnameacc = lower([pathnamea '\album\cc']);
pathnamearlc = lower([pathnamea '\album\rlc']);
pathnameadrawdraw = lower([pathnamea '\album\utility']);

uiLPLQ = uicontrol('String', 'SC1', 'Units', 'normalized' ...
  , 'Position', [0.0 0.90 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawsc1(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiLPMQ = uicontrol('String', 'SC1a', 'Units', 'normalized' ...
     , 'Position', [0.0 0.84 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawsc1a(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiLPHQ = uicontrol('String', 'SC1b', 'Units', 'normalized' ...
     , 'Position', [0.0 0.78 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawsc1b(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiLPNMQ = uicontrol('String', 'SC1c', 'Units', 'normalized' ...
     , 'Position', [0.0 0.72 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawsc1c(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiLPNHQ = uicontrol('String', 'SC1d', 'Units', 'normalized' ...
     , 'Position', [0.0 0.66 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawsc1d(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiHPLQ = uicontrol('String', 'SC2', 'Units', 'normalized' ...
     , 'Position', [0.0 0.58 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawsc2(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiHPMQ = uicontrol('String', 'SC2a', 'Units', 'normalized' ...
     , 'Position', [0.0 0.52 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawsc2a(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiHPHQ = uicontrol('String', 'SC2b', 'Units', 'normalized' ...
     , 'Position', [0.0 0.46 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawsc2b(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiHPNMQ = uicontrol('String', 'SC3', 'Units', 'normalized' ...
     , 'Position', [0.0 0.38 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawsc3(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiHPNHQ = uicontrol('String', 'SC3a', 'Units', 'normalized' ...
     , 'Position', [0.0 0.32 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawsc3a(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiAPLQ = uicontrol('String', 'SC4', 'Units', 'normalized' ...
     , 'Position', [0.0 0.24 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawsc4(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiAPMQ = uicontrol('String', 'SC4a', 'Units', 'normalized' ...
     , 'Position', [0.0 0.18 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawsc4a(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiAPHQ = uicontrol('String', 'SC5', 'Units', 'normalized' ...
     , 'Position', [0.0 0.10 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawsc5(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiBPLQ = uicontrol('String', 'SC6a', 'Units', 'normalized' ...
     , 'Position', [0.0 0.01 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawsc6a(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiBPMQ = uicontrol('String', 'SC6b', 'Units', 'normalized' ...
     , 'Position', [0.085 0.01 0.09 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawsc6b(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiBPHQ = uicontrol('String', 'SC7', 'Units', 'normalized' ...
     , 'Position', [0.18 0.01 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawsc7(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiBRLQ = uicontrol('String', 'SCu1', 'Units', 'normalized' ...
     , 'Position', [0.275 0.01 0.10 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawscu1(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');

uiBPMQ = uicontrol('String', 'SCu2', 'Units', 'normalized' ...
     , 'Position', [0.38 0.01 0.10 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''drawscu2(x0,x0,dx,ds,F)''); cd ..; cd ..; scalbut');



uiSK2B = uicontrol('String', 'SK2B', 'Units', 'normalized' ...
     , 'Position', [0.92 0.01 0.08 0.05], 'CallBack', ...
  'cd(pathnameadrawdraw);clf;eval(''drawsk2b''); cd ..; cd ..; scalbut');


uiCLOSE = uicontrol('String', 'close', 'Units', 'normalized' ...
     , 'Position', [0.92 0.92 0.07 0.06] ...
     , 'CallBack', 'close(gcf)');

uiINFO = uicontrol('String', 'info', 'Units', 'normalized' ...
     , 'Position', [0.92 0.82 0.07 0.06] ...
     , 'CallBack', 'scalbum');

