function mydrawnodetag = drawnode(a,b,t,p,s,f,dc)
% drawnode.m  DRAW NODE
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 

mydrawnodetag = ['drawnodex' num2str(a) 'y' num2str(b) 'p' num2str(p)];

xy = 0:0.05:1;
x1 = a + s*0.02*sin(2*pi*xy);
y1 = b + s*0.02*cos(2*pi*xy);
line(x1,y1,'LineWidth',2*s,'Color',dc,'Tag',mydrawnodetag)

if p == 0
 text(a+s*0.075,b,t,'FontName','Times','FontSize',f,...
   'HorizontalAlignment','left','VerticalAlignment','middle','Tag',mydrawnodetag)
elseif p == 1
 text(a+s*0.05,b+s*0.05,t,'FontName','Times','FontSize',f,...
   'HorizontalAlignment','left','VerticalAlignment','bottom','Tag',mydrawnodetag)
elseif p == 2
 text(a,b+s*0.05,t,'FontName','Times','FontSize',f,...
   'HorizontalAlignment','center','VerticalAlignment','bottom','Tag',mydrawnodetag)
elseif p == 3
 text(a-s*0.05,b+s*0.05,t,'FontName','Times','FontSize',f,...
   'HorizontalAlignment','right','VerticalAlignment','bottom','Tag',mydrawnodetag)
elseif p == 4
 text(a-s*0.075,b,t,'FontName','Times','FontSize',f,...
   'HorizontalAlignment','right','VerticalAlignment','middle','Tag',mydrawnodetag)
elseif p == 5
 text(a-s*0.05,b-s*0.05,t,'FontName','Times','FontSize',f,...
   'HorizontalAlignment','right','VerticalAlignment','top','Tag',mydrawnodetag)
elseif p == 6
 text(a,b-s*0.05,t,'FontName','Times','FontSize',f,...
   'HorizontalAlignment','center','VerticalAlignment','top','Tag',mydrawnodetag)
else
 text(a+s*0.05,b-s*0.05,t,'FontName','Times','FontSize',f,...
   'HorizontalAlignment','left','VerticalAlignment','top','Tag',mydrawnodetag)
end
