function mydrawmulttag = drawmult(varargin)
% drawmult.m  DRAW MULTIPLIER
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 
%                                                                   
% function dr = drawmult(x, y, z,           LabelString, ValueString,  P_orientation,s, F, dc)
% argument               1, 2, 3,           4,           5,            6,            7, 8, 9
% function dr = drawmult(X, Y, LabelString, ValueString, P_orientation,s,            F, dc)

narginmydraw = length(varargin);

if narginmydraw == 8
    dc = varargin{8};
    F  = varargin{7};
    s  = varargin{6};
    P_orientation = varargin{5};
    ValueString   = varargin{4};
    LabelString   = varargin{3};
    if (length(varargin{1}) ~= 2)|(length(varargin{2}) ~= 2)
        disp('Warning: number of input arguments should be 8 or 9, for example:')
        disp('drawmult(x, y, z, LabelString, ValueString, P_orientation, Scale, FontSize, color)   or')
        disp('drawmult([x1 x2], [y1 y2], LabelString, ValueString, P_orientation, Scale, FontSize, color)')
        return
    end
    x = varargin{1}(1);
    z = varargin{1}(2);
    y = varargin{2}(1);
    v = varargin{2}(2);
elseif narginmydraw == 9
    dc = varargin{9};
    F  = varargin{8};
    s  = varargin{7};
    P_orientation = varargin{6};
    ValueString   = varargin{5};
    LabelString   = varargin{4};
    z = varargin{3};
    v = varargin{3};
    y = varargin{2};
    x = varargin{1};
else
    disp('Warning: number of input arguments should be 8 or 9, for example:')
    disp('drawmult(x, y, z, LabelString, ValueString, P_orientation, Scale, FontSize, color)   or')
    disp('drawmult([x1 x2], [y1 y2], LabelString, ValueString, P_orientation, Scale, FontSize, color)')
    dc = 'k'; F = 8; s = 5;
    P_orientation = 0;
    ValueString = 'V'; LabelString = 'L';
    z = 2; v = 1; y = 1; x = 1;
    drawdemomult
    return
end

mydrawmulttag = ['drawmultx' num2str(x) 'y' num2str(y) 'z' num2str(z) 'v' num2str(v) 'p' num2str(P_orientation)];

p = abs(round(P_orientation));
if (p<0)|(p>15)
    p = 0;
end
if     p == 0
    L = ValueString;
    V = LabelString;
elseif p == 1
    V = ValueString;
    L = LabelString;
elseif p == 2
    V = ValueString;
    L = LabelString;
elseif p == 3
    L = ValueString;
    V = LabelString;
elseif p == 4
    V = ValueString;
    L = LabelString;
elseif p == 5
    L = ValueString;
    V = LabelString;
elseif p == 6
    L = ValueString;
    V = LabelString;
elseif p == 7
    V = ValueString;
    L = LabelString;
elseif p == 8
    L = strvcat(LabelString,ValueString);
    V = ' ';
elseif p == 9
    V = strvcat(LabelString,ValueString);
    L = ' ';
elseif p == 10
    V = strvcat(LabelString,ValueString);
    L = ' ';
elseif p == 11
    L = strvcat(ValueString,LabelString);
    V = ' ';
elseif p == 12
    V = strvcat(ValueString,LabelString);
    L = ' ';
elseif p == 13
    L = strvcat(LabelString,ValueString);
    V = ' ';
elseif p == 14
    L = strvcat(ValueString,LabelString);
    V = ' ';
elseif p == 15
    V = strvcat(ValueString,LabelString);
    L = ' ';
end
p8 = p  - 8*fix(p/8);
p4 = p8 - 4*fix(p8/4);
p2 = p4 - 2*fix(p4/2);
if narginmydraw == 9
    if p2 == 0
        v = y;
    else
        z = x;
    end
end
if (x == z) & (y == v)
    disp('Error using draw: output node should be different from input node');
    return
end

d = 0.2*s;
dd = (2/sqrt(3))*d;
xm = xymean(x,z);
ym = xymean(y,v);
[K,Kp] = line2points(x,y,z,v);
Ka = abs(K);
Kpa = abs(Kp);
at = 6*atan2((v-y),(z-x))/pi;
if Ka <= Kpa
    [X1x,Y1x] = dotonlined(d,xm,ym,K);
    [X2x,Y2x] = dotonlined(-d,xm,ym,K);
else
    [Y1x,X1x] = dotonlined(-d,ym,xm,-Kp);
    [Y2x,X2x] = dotonlined(d,ym,xm,-Kp);
end
d1 = distance(x,y,X1x,Y1x);
d2 = distance(x,y,X2x,Y2x);
if (p4 == 0)|(p4 == 1)
    if d1 > d2
        X1 = X1x;
        Y1 = Y1x;
        X2 = X2x;
        Y2 = Y2x;
        xy = 1;
    else
        X1 = X2x;
        Y1 = Y2x;
        X2 = X1x;
        Y2 = Y1x;
        xy = -1;
    end
    line([x X2],[y Y2],'Color',dc,'Tag',mydrawmulttag);
    line([z X1],[v Y1],'Color',dc,'Tag',mydrawmulttag);
else
    if d1 < d2
        X1 = X1x;
        Y1 = Y1x;
        X2 = X2x;
        Y2 = Y2x;
        xy = 1;
    else
        X1 = X2x;
        Y1 = Y2x;
        X2 = X1x;
        Y2 = Y1x;
        xy = -1;
    end
    line([z X2],[v Y2],'Color',dc,'Tag',mydrawmulttag);    
    line([x X1],[y Y1],'Color',dc,'Tag',mydrawmulttag);    
end

if Kpa < Ka
    [X3,Y3] = dotonlined(dd*xy,X2,Y2,Kp);
    [X4,Y4] = dotonlined(-dd*xy,X2,Y2,Kp);
else
    [Y3,X3] = dotonlined(dd*xy,Y2,X2,-K);
    [Y4,X4] = dotonlined(-dd*xy,Y2,X2,-K);
end
X5 = xymean(X1,X3);
Y5 = xymean(Y1,Y3);
X6 = xymean(X1,X4);
Y6 = xymean(Y1,Y4);

%line(xm,ym,'Marker','o','Color','b'); % Marker -> LineStyle
line([X3 X4 X1 X3],[Y3 Y4 Y1 Y3],'LineStyle','-','Color',dc,'Tag',mydrawmulttag);

if (p4 == 0)|(p4 == 1)
    if  (at<=1)&(at>=-2)
        text(X5,Y5,L,'FontName','Times','FontSize',F,'HorizontalAlignment','left','VerticalAlignment','bottom','Tag',mydrawmulttag)
    elseif (at>=1)&(at<=4)
        text(X5,Y5,L,'FontName','Times','FontSize',F,'HorizontalAlignment','right','VerticalAlignment','bottom','Tag',mydrawmulttag)
    elseif (at>=-5)&(at<=-2)
        text(X5,Y5,L,'FontName','Times','FontSize',F,'HorizontalAlignment','left','VerticalAlignment','top','Tag',mydrawmulttag)
    else
       text(X5,Y5,L,'FontName','Times','FontSize',F,'HorizontalAlignment','right','VerticalAlignment','top','Tag',mydrawmulttag)
    end
else
    if  (at<=1)&(at>=-2)
        text(X5,Y5,L,'FontName','Times','FontSize',F,'HorizontalAlignment','right','VerticalAlignment','top','Tag',mydrawmulttag)
    elseif (at>=1)&(at<=4)
        text(X5,Y5,L,'FontName','Times','FontSize',F,'HorizontalAlignment','left','VerticalAlignment','top','Tag',mydrawmulttag)
    elseif (at>=-5)&(at<=-2)
        text(X5,Y5,L,'FontName','Times','FontSize',F,'HorizontalAlignment','right','VerticalAlignment','bottom','Tag',mydrawmulttag)
    else
       text(X5,Y5,L,'FontName','Times','FontSize',F,'HorizontalAlignment','left','VerticalAlignment','bottom','Tag',mydrawmulttag)
    end
end
    
if (p4 == 0)|(p4 == 1)
    if  (at<=2)&(at>=-1)
        text(X6,Y6,V,'FontName','Times','FontSize',F,'HorizontalAlignment','left','VerticalAlignment','top','Tag',mydrawmulttag)
    elseif (at>=2)&(at<=5)
        text(X6,Y6,V,'FontName','Times','FontSize',F,'HorizontalAlignment','left','VerticalAlignment','bottom','Tag',mydrawmulttag)
    elseif (at>=-4)&(at<=-1)
        text(X6,Y6,V,'FontName','Times','FontSize',F,'HorizontalAlignment','right','VerticalAlignment','top','Tag',mydrawmulttag)
    else
       text(X6,Y6,V,'FontName','Times','FontSize',F,'HorizontalAlignment','right','VerticalAlignment','bottom','Tag',mydrawmulttag)
    end
else
    if  (at<=2)&(at>=-1)
        text(X6,Y6,V,'FontName','Times','FontSize',F,'HorizontalAlignment','right','VerticalAlignment','bottom','Tag',mydrawmulttag,'Tag',mydrawmulttag)
    elseif (at>=2)&(at<=5)
        text(X6,Y6,V,'FontName','Times','FontSize',F,'HorizontalAlignment','right','VerticalAlignment','top','Tag',mydrawmulttag)
    elseif (at>=-4)&(at<=-1)
        text(X6,Y6,V,'FontName','Times','FontSize',F,'HorizontalAlignment','left','VerticalAlignment','bottom','Tag',mydrawmulttag)
    else
       text(X6,Y6,V,'FontName','Times','FontSize',F,'HorizontalAlignment','left','VerticalAlignment','top','Tag',mydrawmulttag)
    end
end

function [K,Kp] = line2points(x,y,z,v)
if x == z
    K  = 1e33;
    Kp = -1e-33;
elseif y == v
    K  = 1e-33;
    Kp = -1e33;
else
    K = (v-y)/(z-x);
    Kp = -1/K;
end

function [x,y] = dotonlined(D,X,Y,K)
x = D/sqrt(1+K^2) + X;
y = K*(x - X) + Y;

function [myx] = xymean(myX,myY)
myx = (myX+myY)/2;

function d = distance(x,y,z,v)
    d = sqrt((v-y).^2 + (z-x).^2);

function drdrawdemomult = drawdemomult
figure
x0=0; y0=0; dx=4; ds=5; F=8; dc='b';
Nx = 100; Ny = 100; whitebg(figure(gcf),[1 1 1]); 
x = (1:4*Nx)*dx/4 + x0; y = (1:4*Ny)*dx/4 + y0;
drawline(x(1), y(19), x(36), y(19), dc);                     
drawline(x(9), y(10), x(9), y(1), dc);                       
drawline(x(9), y(10), x(1), y(10), dc);                      
drawmult(x(3), y(24),x(8), 'L_0','V0',0, ds/2,F-1,dc);       
drawmult(x(14),y(21),y(26),'L_1','V1',1, ds/2,F-1,dc);       
drawmult(x(21),y(24),x(26),'L_2','V2',2, ds/2,F-1,dc);       
drawmult(x(33),y(21),y(26),'L_3','V3',3, ds/2,F-1,dc);       
drawmult(x(3), y(15),x(8), 'L_4','V4',4, ds/2,F-1,dc);       
drawmult(x(14),y(12),y(17),'L_5','V5',5, ds/2,F-1,dc);       
drawmult(x(21),y(15),x(26),'L_6','V6',6, ds/2,F-1,dc);       
drawmult(x(33),y(12),y(17),'L_7','V7',7, ds/2,F-1,dc);       
drawmult(x(3), y(7), x(7), ' ' ,'a0',0, ds/3,F-1,'c');       
drawmult(x(7), y(3), y(7), ' ' ,'a1',1, ds/3,F-1,'g');       
drawmult(x(3), y(3), x(7), ' ' ,'a2',2, ds/3,F-1,'m');       
drawmult(x(3), y(3), y(7), ' ' ,'a3',3, ds/3,F-1,'k');       
drawtext(x(2), y(7), '(x,y)', F-2, dc);                      
drawtext(x(8), y(7), '(x_2,y_2)', F-2, dc);                  
drawtext(x(2), y(2),'(x_2,y_2)', F-2, dc);                   
drawtext(x(8), y(2),'(x,y)', F-2, dc);                       
drawnode(x(14), y(21),'input', 6, 1, F-1, dc);               
drawnode(x(14), y(26),'output', 2, 1, F-1, dc);              
drawnode(x(26), y(24),' input', 0, 1, F-1, dc);              
drawnode(x(21), y(24),'output ', 4, 1, F-1, dc);             
drawtext(x(14), y(11), '(x,y)', F-1, dc);                    
drawtext(x(14), y(17), '(x_2,y_2)', F-1, dc);                
drawtext(x(20), y(15), '(x_2,y_2)', F-1, dc);                
drawtext(x(27), y(15), '(x,y)', F-1, dc);                    
drawtext(x(17),y(9),'drawmult(x,y,z,L,V,P,S,F,C)',F,dc);     
drawtext(x(17),y(8),'(x,y) - MULTIPLIER input ',F-2,dc);     
drawtext(x(17),y(6),'(x_2,y_2) - MULTIPLIER output',F-2,dc); 
drawtext(x(17),y(5),'x_2=x, y_2=z, P\in (0,2,4,6)',F-2,dc);  
drawtext(x(17),y(4),'x_2=z, y_2=y, P\in (1,3,5,7)',F-2,dc);  
drawtext(x(14),y(3), 'L - Label', F-2,dc);                   
drawtext(x(14),y(2), 'V - Value', F-2,dc);                   
drawtext(x(14),y(1), 'P - Orientation', F-2,dc);             
drawtext(x(21),y(3), 'S - Scale', F-2,dc);                   
drawtext(x(21),y(2), 'F - Font Size', F-2,dc);               
drawtext(x(21),y(1), 'C - Draw Color', F-2,dc);              
drawtext(x(31),y(9),'x=x(25), y=y(8), z=x(34)',F-1,dc);      
drawtext(x(31),y(8),'L=^,Label \\mu^,, V=^,Value^,',F-1,dc); 
drawtext(x(31),y(7),'P=0, S=6*ds/7, F=7, C=^,r^, ',F-1,dc);  
drawmult(x(25),y(3),x(34),'Label \mu','Value',0,6*ds/7,7,'r')
drawtext(x(3), y(26), 'P=0', F-1, dc);                       
drawtext(x(11),y(26), 'P=1', F-1, dc);                       
drawtext(x(21),y(26), 'P=2', F-1, dc);                       
drawtext(x(31),y(26), 'P=3', F-1, dc);                       
drawtext(x(3), y(17), 'P=4', F-1, dc);                       
drawtext(x(11),y(17), 'P=5', F-1, dc);                       
drawtext(x(21),y(17), 'P=6', F-1, dc);                       
drawtext(x(31),y(17), 'P=7', F-1, dc);                       
drawtext(x(6),y(19),'Draw using button Mult',F,dc);          
drawtext(x(7),y(10),'Change using button EDIT',F,dc);        
axis('equal')
axis('off')
