function mydrawlndtag = drawlnd(c,d,f,n,t,p,s,F,dc)
% drawlnd.m  DRAW INDUCTOR
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 

mydrawlndtag = ['drawlndx' num2str(c) 'y' num2str(d) 'z' num2str(f) 'p' num2str(p)];

a=(f+c)/2-0.4*s;
b=d;
g=c;
h=(f+d)/2-0.4*s;
xy01 = ceil(50*(acos(1/1.5)/(2*pi)+0.25))/50;
xy02 = ceil(50*(-acos(1/1.5)/(2*pi)-0.25))/50;
xy = 0:0.02:1;
xy1 = -0.25:0.02: xy01; xy2 = xy02:0.02:xy01;
xy3 = xy02:0.02:0.25;   xy3(length(xy3)+1) = 0.25;

if p == 0
 x = (f+c)/2-0.2*s + s*0.15*sin(2*pi*xy1);
 y = d + s*0.15*cos(2*pi*xy1);
 line(x,y,'Color',dc,'Tag',mydrawlndtag)
 x = (f+c)/2 + s*0.15*sin(2*pi*xy2);
 y = d + s*0.15*cos(2*pi*xy2);
 line(x,y,'Color',dc,'Tag',mydrawlndtag)
 x = (f+c)/2 + 0.2*s + s*0.15*sin(2*pi*xy3);
 y = d + s*0.15*cos(2*pi*xy3);
 line(x,y,'Color',dc,'Tag',mydrawlndtag)
 x2 = a + s*[(c-a)/s, 0.05];
 y2 = b + s*[      0,   0];
 line(x2,y2,'Color',dc,'Tag',mydrawlndtag)
 x3 = a + s*[0.75, (f-a)/s];
 y3 = b + s*[  0, 0];
 line(x3,y3,'Color',dc,'Tag',mydrawlndtag)
 text((c+f)/2,b+s*0.5,n,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','center','VerticalAlignment','bottom','Tag',mydrawlndtag)
 text((c+f)/2,b+s*0.2,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','center','VerticalAlignment','bottom','Tag',mydrawlndtag)
elseif p == 1
 y = (f+d)/2-0.2*s + s*0.15*sin(2*pi*xy1);
 x = c - s*0.15*cos(2*pi*xy1);
 line(x,y,'Color',dc,'Tag',mydrawlndtag)
 y = (f+d)/2 + s*0.15*sin(2*pi*xy2);
 x = c - s*0.15*cos(2*pi*xy2);
 line(x,y,'Color',dc,'Tag',mydrawlndtag)
 y = (f+d)/2 + 0.2*s + s*0.15*sin(2*pi*xy3);
 x = c - s*0.15*cos(2*pi*xy3);
 line(x,y,'Color',dc,'Tag',mydrawlndtag)
 x = g + s*[      0,   0];
 y = h + s*[(d-h)/s, 0.05];
 line(x,y,'Color',dc,'Tag',mydrawlndtag)
 x = g + s*[   0, 0];
 y = h + s*[0.75, (f-h)/s];
 line(x,y,'Color',dc,'Tag',mydrawlndtag)
 text(g-s*0.25,h+s*0.4,n,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','right','VerticalAlignment','top','Tag',mydrawlndtag)
 text(g-s*0.25,h+s*0.4,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','right','VerticalAlignment','bottom','Tag',mydrawlndtag)
elseif p == 2
 x = (f+c)/2-0.2*s + s*0.15*sin(2*pi*xy1);
 y = d + s*0.15*cos(2*pi*xy1);
 line(x,y,'Color',dc,'Tag',mydrawlndtag)
 x = (f+c)/2 + s*0.15*sin(2*pi*xy2);
 y = d + s*0.15*cos(2*pi*xy2);
 line(x,y,'Color',dc,'Tag',mydrawlndtag)
 x = (f+c)/2 + 0.2*s + s*0.15*sin(2*pi*xy3);
 y = d + s*0.15*cos(2*pi*xy3);
 line(x,y,'Color',dc,'Tag',mydrawlndtag)
 x2 = a + s*[(c-a)/s, 0.05];
 y2 = b + s*[      0,   0];
 line(x2,y2,'Color',dc,'Tag',mydrawlndtag)
 x3 = a + s*[0.75, (f-a)/s];
 y3 = b + s*[  0, 0];
 line(x3,y3,'Color',dc,'Tag',mydrawlndtag)
 text((c+f)/2,b-s*0.45,n,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','center','VerticalAlignment','top','Tag',mydrawlndtag)
 text((c+f)/2,b-s*0.15,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','center','VerticalAlignment','top','Tag',mydrawlndtag)
else
 y = (f+d)/2-0.2*s + s*0.15*sin(2*pi*xy1);
 x = c - s*0.15*cos(2*pi*xy1);
 line(x,y,'Color',dc,'Tag',mydrawlndtag)
 y = (f+d)/2 + s*0.15*sin(2*pi*xy2);
 x = c - s*0.15*cos(2*pi*xy2);
 line(x,y,'Color',dc,'Tag',mydrawlndtag)
 y = (f+d)/2 + 0.2*s + s*0.15*sin(2*pi*xy3);
 x = c - s*0.15*cos(2*pi*xy3);
 line(x,y,'Color',dc,'Tag',mydrawlndtag)
 x = g + s*[      0,   0];
 y = h + s*[(d-h)/s, 0.05];
 line(x,y,'Color',dc,'Tag',mydrawlndtag)
 x = g + s*[   0, 0];
 y = h + s*[0.75, (f-h)/s];
 line(x,y,'Color',dc,'Tag',mydrawlndtag)
 text(g+s*0.15,h+s*0.4,n,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','left','VerticalAlignment','top','Tag',mydrawlndtag)
 text(g+s*0.15,h+s*0.4,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','left','VerticalAlignment','bottom','Tag',mydrawlndtag)
end
