function mydrawintag = drawin(varargin)
% drawin.m  DRAW INPUT
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 

narginmydraw = length(varargin);
if narginmydraw == 7
    dc = varargin{7};
    F  = varargin{6};
    s  = varargin{5};
    p  = varargin{4};
    t  = varargin{3};
    b  = varargin{2};
    a  = varargin{1};
else
    disp('Warning: number of input arguments should be 7, for example:')
    disp('drawin(x(1), y(1), ''Value'', Orientation, Size, FontSize, DrawColor);')
    disp('drawin(8, 15, '' In'', 0, 8, 12, ''r'');')
    drawdemoin
    return
end

mydrawintag = ['drawinx' num2str(a) 'y' num2str(b) 'p' num2str(p)];
if p == 0
 line([a,a+s*0.1],[b,b],'Color',dc,'Tag',mydrawintag)
 rectangle('Position', [a+s*0.1 b-s*0.05 s*0.1 s*0.1],'Curvature', [1 1],'EdgeColor',dc,'Tag',mydrawintag)
 text(a+s*0.25,b,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','left','VerticalAlignment','middle','Tag',mydrawintag)
elseif p == 1
 line([a,a],[b,b+s*0.1],'Color',dc,'Tag',mydrawintag)
 rectangle('Position', [a-s*0.05 b+s*0.1 s*0.1 s*0.1],'Curvature', [1 1],'EdgeColor',dc,'Tag',mydrawintag)
 text(a,b+s*0.2,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','center','VerticalAlignment','bottom','Tag',mydrawintag)
elseif p == 2
 line([a,a-s*0.1],[b,b],'Color',dc,'Tag',mydrawintag)
 rectangle('Position', [a-s*0.2 b-s*0.05 s*0.1 s*0.1],'Curvature', [1 1],'EdgeColor',dc,'Tag',mydrawintag)
 text(a-s*0.25,b,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','right','VerticalAlignment','middle','Tag',mydrawintag)
elseif p == 3
 line([a,a],[b,b-s*0.1],'Color',dc)
 text(a,b-s*0.2,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','center','VerticalAlignment','top','Tag',mydrawintag)
 rectangle('Position', [a-s*0.05 b-s*0.2 s*0.1 s*0.1],'Curvature', [1 1],'EdgeColor',dc,'Tag',mydrawintag)
else
 line([a,a-s*0.1],[b,b],'Color',dc,'Tag',mydrawintag)
 rectangle('Position', [a-s*0.2 b-s*0.05 s*0.1 s*0.1],'Curvature', [1 1],'EdgeColor',dc,'Tag',mydrawintag)
 text(a-s*0.2,b,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','right','VerticalAlignment','middle','Tag',mydrawintag)
end

function demomydrawintag = drawdemoin
figure
drawin(10, 19,' P = 0',  0, 4, 11, 'r');                       
drawin(14, 19, 'P = 1',  1, 4, 11, 'b');                       
drawin(18, 19, 'P = 2 ', 2, 4, 11, 'g');                       
drawin(22, 19, 'P = 3',  3, 4, 11, 'm'); 
axis('equal')
axis('off')
