% drawfilt.m   DRAWING DIGITAL & ANALOG FILTER REALIZATIONS (main script)
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 

close all;
clear all; 
clc

matlabversion = version;
if matlabversion(1)-'6' <0 
   disp ('DrawFilt version 2.8 works with MATLAB version 6 or 7')
end

% Is DrawFilt appended to the MATLAB path?
currentPath = path;
DrawFiltString = 'drawfilt';
isAppended = strfind(lower(currentPath),DrawFiltString);
if length(isAppended) == 0
  disp(' ***** DrawFilt WARNING *****                 ');
  disp(' DrawFilt is not appended to the MATLAB path! ');
  disp(' Add DrawFilt to the MATLAB path. For example ');
  disp('       path(path,''C:\afd\DrawFilt'')         ');
  return;
end

% ---------  INITIALIZATION  ----------------------
mypathname    = lower(pwd);
mypathnameold = lower(pwd);
myfilename    = 'untitled.m';
myfilenamem   = 'untitled';
mytitlefigure = 'DrawFilt version 2.8 - Draw filters and systems in MATLAB';
editString    = [0 1];
matrixEsize   = 61;
matrixE        = blanks(matrixEsize);
matrixEnew     = blanks(matrixEsize);
matrixEdel     = [];
matrixEedit    = [];
matrixEtag     = [];
matrixEdeltag  = [];
matrixEedittag = [];
matrixEeditind = 0;
XS             = blanks(matrixEsize);
digitalanalog  = 0;
txtst = 1;
dc = 'b';
x0 = 0;
y0 = 0;
F =  9;
dx = 4;
ds = 5;
Nx = 9;
Ny = 7;
mybutton{1,1} = 'Adder';
mybutton{2,1} = 'Mult';
mybutton{3,1} = 'Delay';
mybutton{4,1} = 'UP';
mybutton{5,1} = 'down';
mybutton{6,1} = 'LINE';
mybutton{7,1} = 'PolyLine';
mybutton{8,1} = '__I';
mybutton{9,1} = 'I__';
mybutton{10,1} = '>';
mybutton{11,1} = 'In';
mybutton{12,1} = 'Out';
mybutton{13,1} = 'NODE';
mybutton{14,1} = 'TEXT';
mybutton{15,1} = 'Block';
mybutton{16,1} = 'Block 4';
mybutton{17,1} = 'text';
mybutton{18,1} = 'CC';
mybutton{19,1} = 'OTA';
mybutton{20,1} = 'OpAmp';
mybutton{21,1} = 'GRND';
mybutton{22,1} = 'R';
mybutton{23,1} = 'C';
mybutton{24,1} = 'L';
mybutton{25,1} = 'Z';
mybutton{26,1} = '(V)';
mybutton{27,1} = '(I)';
mybutton{28,1} = '<V>';
mybutton{29,1} = '<I>';
mybutton{30,1} = '3';
mybutton{31,1} = '4';
mybutton{32,1} = 'digital';
mybutton{33,1} = 'info';
mybutton{34,1} = 'close';
mybutton{35,1} = 'NEW';
mybutton{36,1} = 'analog';
mybutton{37,1} = '5';
mybutton{38,1} = '6';
mybutton{39,1} = 'OPEN';
mybutton{40,1} = 'EDIT';
mybutton{41,1} = 'myfilenamem';
mybutton{42,1} = 'MA';
mybutton{43,1} = 'EPS';
mybutton{44,1} = 'view';
mybutton{45,1} = 'open';
mybutton{46,1} = '1';
mybutton{47,1} = '2';
mybutton{48,1} = 'DELETE';
mybutton{49,1} = 'UNDO';
mybutton{50,1} = 'redraw';
mybutton{51,1} = 'save';
mybutton{52,1} = 'save as';
mybutton{53,1} = 'mypathname';
mybutton{54,1} = 'myfilename';
bdwidth = 5;
topbdwidth = 30;
rdr = 'clf;[x,y]= drawgrid(x0,y0,dx,ds,F,Nx,Ny);matrixEtag=bdrwredr(x0,y0,dx,ds,F,Nx,Ny,matrixE,dc);butdraw';
trdr = ['if txtst==1;' rdr ';txtst=0; end;'];
% -------------------------------------------------

screensize = get(0, 'ScreenSize');
mypos = [0.1*screensize(3)+bdwidth,0.1*screensize(4)+bdwidth, ...
        0.89*screensize(3)-2*bdwidth,0.9*screensize(4)-(topbdwidth+bdwidth)];
mypos = [mypos;[0.001*screensize(3)+bdwidth,0.05*screensize(4)+bdwidth, ...
        0.1*screensize(3)-bdwidth,0.9*screensize(4)-(topbdwidth+bdwidth)]];
mypos = [mypos;[0.01*screensize(3)+bdwidth,0.3*screensize(4)+bdwidth, ...
        0.5*screensize(3)-2*bdwidth,0.7*screensize(4)-(topbdwidth+bdwidth)]];

mydffig1 = figure('Position',mypos(1,:)); axis off;
set(mydffig1, 'Name', mytitlefigure, 'NextPlot', 'replace','NumberTitle', 'off')
whitebg(mydffig1,[1 1 1]);

[x,y]= drawgrid(x0,y0,dx,ds,F,Nx,Ny);
bdrwinfo(myfilename,myfilenamem,digitalanalog)
butdraw;
