function mydrawcaptag = drawcap(c,d,f,n,t,p,s,F,dc)
% drawcap.m  DRAW CAPACITOR
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 

mydrawcaptag = ['drawcapx' num2str(c) 'y' num2str(d)  'z' num2str(f) 'p' num2str(p)];

a=(f+c)/2-0.4*s;
b=d;
g=c;
h=(f+d)/2-0.4*s;
xy = 1.1*s;

if p == 0
 x1 = a + s*[(c-a)/s, 0.35];   y1 = b + s*[   0,   0];
 x2 = a + s*[   0.35, 0.35];   y2 = b + s*[-0.2, 0.2];
 x3 = a + s*[(f-a)/s, 0.45];   y3 = b + s*[   0,   0];
 x4 = a + s*[   0.45, 0.45];   y4 = b + s*[-0.2, 0.2];
 line(x1,y1,'Color',dc,'Tag',mydrawcaptag)
 line(x3,y3,'Color',dc,'Tag',mydrawcaptag)
 line(x2,y2,'LineWidth',xy,'Color',dc,'Tag',mydrawcaptag)
 line(x4,y4,'LineWidth',xy,'Color',dc,'Tag',mydrawcaptag)
 text(a+s*0.4,b+s*0.55,n,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','center','VerticalAlignment','bottom','Tag',mydrawcaptag)
 text(a+s*0.4,b+s*0.25,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','center','VerticalAlignment','bottom','Tag',mydrawcaptag)
elseif p == 1
 x1 = g + s*[      0, 0   ];  y1 = h + s*[(d-h)/s, 0.35];
 x2 = g + s*[   -0.2, 0.2 ];  y2 = h + s*[   0.35, 0.35];
 x3 = g + s*[      0, 0   ];  y3 = h + s*[(f-h)/s, 0.45];
 x4 = g + s*[   -0.2, 0.2 ];  y4 = h + s*[   0.45, 0.45];
 line(x1,y1,'Color',dc,'Tag',mydrawcaptag)
 line(x3,y3,'Color',dc,'Tag',mydrawcaptag)
 line(x2,y2,'LineWidth',xy,'Color',dc,'Tag',mydrawcaptag)
 line(x4,y4,'LineWidth',xy,'Color',dc,'Tag',mydrawcaptag)
 text(g-s*0.3,h+s*0.4,n,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','right','VerticalAlignment','top','Tag',mydrawcaptag)
 text(g-s*0.3,h+s*0.4,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','right','VerticalAlignment','bottom','Tag',mydrawcaptag)
elseif p == 2
 x1 = a + s*[(c-a)/s, 0.35];   y1 = b + s*[   0,   0];
 x2 = a + s*[   0.35, 0.35];   y2 = b + s*[-0.2, 0.2];
 x3 = a + s*[(f-a)/s, 0.45];   y3 = b + s*[   0,   0];
 x4 = a + s*[   0.45, 0.45];   y4 = b + s*[-0.2, 0.2];
 line(x1,y1,'Color',dc,'Tag',mydrawcaptag)
 line(x3,y3,'Color',dc,'Tag',mydrawcaptag)
 line(x2,y2,'LineWidth',xy,'Color',dc,'Tag',mydrawcaptag)
 line(x4,y4,'LineWidth',xy,'Color',dc,'Tag',mydrawcaptag)
 text(a+s*0.4,b-s*0.55,n,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','center','VerticalAlignment','top','Tag',mydrawcaptag)
 text(a+s*0.4,b-s*0.25,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','center','VerticalAlignment','top','Tag',mydrawcaptag)
else
 x1 = g + s*[      0, 0   ];  y1 = h + s*[(d-h)/s, 0.35];
 x2 = g + s*[   -0.2, 0.2 ];  y2 = h + s*[   0.35, 0.35];
 x3 = g + s*[      0, 0   ];  y3 = h + s*[(f-h)/s, 0.45];
 x4 = g + s*[   -0.2, 0.2 ];  y4 = h + s*[   0.45, 0.45];
 line(x1,y1,'Color',dc,'Tag',mydrawcaptag)
 line(x3,y3,'Color',dc,'Tag',mydrawcaptag)
 line(x2,y2,'LineWidth',xy,'Color',dc,'Tag',mydrawcaptag)
 line(x4,y4,'LineWidth',xy,'Color',dc,'Tag',mydrawcaptag)
 text(g+s*0.3,h+s*0.4,n,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','left','VerticalAlignment','top','Tag',mydrawcaptag)
 text(g+s*0.3,h+s*0.4,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','left','VerticalAlignment','bottom','Tag',mydrawcaptag)
end
