function mydrawaddtag = drawadd(a,b,c0,c1,c2,c3,t,p,s,F,dc)
% drawadd.m  DRAW ADDER
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 

mydrawaddtag = ['drawaddx' num2str(a) 'y' num2str(b) 'p' num2str(p) 'C' num2str(c0) num2str(c1) num2str(c2) num2str(c3)];
xy = 0:0.02:1;
x1 = a+s*0.6 + s*0.3*sin(2*pi*xy);
y1 = b       + s*0.3*cos(2*pi*xy);
line(x1,y1,'Color',dc,'Tag',mydrawaddtag)
x2 = [a+s*0.45, a+s*0.75, a+s*0.6, a+s*0.6,  a+s*0.6];
y2 = [       b,        b,       b, b+s*0.15, b-s*0.15];
line(x2,y2,'Color',dc,'Tag',mydrawaddtag)

if p == 0
 text(a+s,b,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','left','VerticalAlignment','middle','Tag',mydrawaddtag)
elseif p == 1
 text(a+s*0.8,b+s*0.3,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','left','VerticalAlignment','bottom','Tag',mydrawaddtag)
elseif p == 2
 text(a+s*0.6,b+s*0.4,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','center','VerticalAlignment','bottom','Tag',mydrawaddtag)
elseif p == 3
 text(a+s*0.4,b+s*0.3,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','right','VerticalAlignment','bottom','Tag',mydrawaddtag)
elseif p == 4
 text(a+s*0.2,b,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','right','VerticalAlignment','middle','Tag',mydrawaddtag)
elseif p == 5
 text(a+s*0.4,b-s*0.3,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','right','VerticalAlignment','top','Tag',mydrawaddtag)
elseif p == 6
 text(a+s*0.6,b-s*0.4,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','center','VerticalAlignment','top','Tag',mydrawaddtag)
else
 text(a+s*0.8,b-s*0.3,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','left','VerticalAlignment','top','Tag',mydrawaddtag)
end

if c0 == 1
 x3 = [a+s*1.1, a+s, a+s*1.1];  y3 = [b+s*0.05, b, b-s*0.05];  
 line(x3,y3,'Color',dc,'Tag',mydrawaddtag)
 x4 = [a+s*0.9,a+s*1.2];        y4 = [b, b];                   
 line(x4,y4,'Color',dc,'Tag',mydrawaddtag)
elseif c0 == 2
 x3 = [a+s,a+s*1.1,a+s];  y3 = [b+s*0.05,b,b-s*0.05];  
 line(x3,y3,'Color',dc,'Tag',mydrawaddtag)
 x4 = [a+s*0.9,a+s*1.2];  y4 = [b, b];                 
 line(x4,y4,'Color',dc,'Tag',mydrawaddtag)
elseif c0 == 3
 x3 = [a+s*1.1, a+s, a+s*1.1]; y3 = [b+s*0.05, b, b-s*0.05];  line(x3,y3,'Color',dc,'Tag',mydrawaddtag)
 x4 = [a+s*0.9, a+s*1.2];      y4 = [b, b];                   line(x4,y4,'Color',dc,'Tag',mydrawaddtag)
 x5 = [a+s, a+s*1.1];          y5 = [b+s*0.1,b+s*0.1];        line(x5,y5,'Color',dc,'Tag',mydrawaddtag)
end
if c1 == 1
 x3 = [a+s*0.55,a+s*0.6,a+s*0.65];  y3 = [b+s*0.5,b+s*0.4,b+s*0.5]; line(x3,y3,'Color',dc,'Tag',mydrawaddtag)
 x4 = [a+s*0.6, a+s*0.6];        y4 = [b+s*0.6, b+s*0.3];         line(x4,y4,'Color',dc,'Tag',mydrawaddtag)
elseif c1 == 2
 x3 = [a+s*0.55,a+s*0.6,a+s*0.65]; y3 = [b+s*0.4,b+s*0.5,b+s*0.4]; line(x3,y3,'Color',dc,'Tag',mydrawaddtag)
 x4 = [a+s*0.6,a+s*0.6];  y4 = [b+s*0.6,b+s*0.3];                line(x4,y4,'Color',dc,'Tag',mydrawaddtag)
elseif c1 == 3
 x3 = [a+s*0.55,a+s*0.6,a+s*0.65]; y3 = [b+s*0.5,b+s*0.4,b+s*0.5]; line(x3,y3,'Color',dc,'Tag',mydrawaddtag)
 x4 = [a+s*0.6,a+s*0.6];      y4 = [b+s*0.6,b+s*0.3];          line(x4,y4,'Color',dc,'Tag',mydrawaddtag)
 x5 = [a+s*0.7,a+s*0.8];      y5 = [b+s*0.45,b+s*0.45];        line(x5,y5,'Color',dc,'Tag',mydrawaddtag)
end
if c2 == 1
 x3 = [a+s*0.1,a+s*0.2,a+s*0.1]; y3 = [b+s*0.05,b,b-s*0.05];  line(x3,y3,'Color',dc,'Tag',mydrawaddtag)
 x4 = [a,a+s*0.3];        y4 = [b,b];                   line(x4,y4,'Color',dc,'Tag',mydrawaddtag)
elseif c2 == 2
 x3 = [a+s*0.2,a+s*0.1,a+s*0.2]; y3 = [b+s*0.05,b,b-s*0.05];  line(x3,y3,'Color',dc,'Tag',mydrawaddtag)
 x4 = [a,a+s*0.3];  y4 = [b,b];                 line(x4,y4,'Color',dc,'Tag',mydrawaddtag)
elseif c2 == 3
 x3 = [a+s*0.1,a+s*0.2,a+s*0.1]; y3 = [b+s*0.05,b,b-s*0.05]; line(x3,y3,'Color',dc,'Tag',mydrawaddtag)
 x4 = [a,a+s*0.3];         y4 = [b, b];                   line(x4,y4,'Color',dc,'Tag',mydrawaddtag)
 x5 = [a+s*0.2,a+s*0.1];   y5 = [b+s*0.1,b+s*0.1];        line(x5,y5,'Color',dc,'Tag',mydrawaddtag)
end

if c3 == 1
 x3 = [a+s*0.55,a+s*0.6,a+s*0.65]; y3 = [b-s*0.5,b-s*0.4,b-s*0.5]; line(x3,y3,'Color',dc,'Tag',mydrawaddtag)
 x4 = [a+s*0.6,a+s*0.6];        y4 = [b-s*0.6,b-s*0.3];            line(x4,y4,'Color',dc,'Tag',mydrawaddtag)
elseif c3 == 2
 x3 = [a+s*0.55,a+s*0.6,a+s*0.65]; y3 = [b-s*0.4,b-s*0.5,b-s*0.4]; line(x3,y3,'Color',dc,'Tag',mydrawaddtag)
 x4 = [a+s*0.6,a+s*0.6];  y4 = [b-s*0.6,b-s*0.3];                  line(x4,y4,'Color',dc,'Tag',mydrawaddtag)
elseif c3 == 3
 x3 = [a+s*0.55,a+s*0.6,a+s*0.65]; y3 = [b-s*0.5,b-s*0.4,b-s*0.5];  line(x3,y3,'Color',dc,'Tag',mydrawaddtag)
 x4 = [a+s*0.6,a+s*0.6];   y4 = [b-s*0.6,b-s*0.3];          line(x4,y4,'Color',dc,'Tag',mydrawaddtag)
 x5 = [a+s*0.7,a+s*0.8];   y5 = [b-s*0.45,b-s*0.45];        line(x5,y5,'Color',dc,'Tag',mydrawaddtag)
end
