% dfsalbut.m  GENERATE BUTTONS: ALBUM OF DIGITAL FILTER REALIZATIONS (script)
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 

x0 = 0; y0 = 0; dx = 2; ds = 2.5; F  = 10;
pathnamea = lower(pwd);
pathnameasc = lower([pathnamea '\album\dfstruct']);
pathnameadrawdraw = lower([pathnamea '\album\utility']);

uiLPLQ = uicontrol('String', 'df1', 'Units', 'normalized' ...
  , 'Position', [0.0 0.90 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''ddf1(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiLPMQ = uicontrol('String', 'df1t', 'Units', 'normalized' ...
     , 'Position', [0.0 0.84 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''ddf1t(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiLPHQ = uicontrol('String', 'df2', 'Units', 'normalized' ...
     , 'Position', [0.0 0.78 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''ddf2(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiLPNMQ = uicontrol('String', 'df2t', 'Units', 'normalized' ...
     , 'Position', [0.0 0.72 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''ddf2t(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiLPNHQ = uicontrol('String', 'fir', 'Units', 'normalized' ...
     , 'Position', [0.0 0.66 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''dfir(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiHPLQ = uicontrol('String', 'firt', 'Units', 'normalized' ...
     , 'Position', [0.0 0.58 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''dfirt(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiHPMQ = uicontrol('String', 'sym1', 'Units', 'normalized' ...
     , 'Position', [0.0 0.52 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''dsymfiro(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiHPHQ = uicontrol('String', 'sym2', 'Units', 'normalized' ...
     , 'Position', [0.0 0.46 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''dsymfire(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiHPNMQ = uicontrol('String', 'asym3', 'Units', 'normalized' ...
     , 'Position', [0.0 0.38 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''dasymfio(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiHPNHQ = uicontrol('String', 'asym4', 'Units', 'normalized' ...
     , 'Position', [0.0 0.32 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''dasymfie(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiAPLQ = uicontrol('String', 'lat1', 'Units', 'normalized' ...
     , 'Position', [0.0 0.24 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''dlatcar(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiAPMQ = uicontrol('String', 'lat2', 'Units', 'normalized' ...
     , 'Position', [0.0 0.18 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''dlatcall(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiAPHQ = uicontrol('String', 'lat3', 'Units', 'normalized' ...
     , 'Position', [0.0 0.10 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''dlatcma(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiBPLQ = uicontrol('String', 'lat4', 'Units', 'normalized' ...
     , 'Position', [0.0 0.01 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''dlatcmax(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiBPMQ = uicontrol('String', 'lat5', 'Units', 'normalized' ...
     , 'Position', [0.085 0.01 0.09 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''dlatcarm(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiBPHQ = uicontrol('String', 'lat6', 'Units', 'normalized' ...
     , 'Position', [0.18 0.01 0.08 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''dlatcca(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiBRLQ = uicontrol('String', 'lat7', 'Units', 'normalized' ...
     , 'Position', [0.275 0.01 0.10 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''dlatccap(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiBPMQ = uicontrol('String', 'ss', 'Units', 'normalized' ...
     , 'Position', [0.38 0.01 0.10 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''dstatesp(x0,x0,dx,ds,F-2)''); cd ..; cd ..; dfsalbut');

uiBPMX = uicontrol('String', 'sca1', 'Units', 'normalized' ...
     , 'Position', [0.485 0.01 0.10 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''dscale1(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiBPMY = uicontrol('String', 'sca2', 'Units', 'normalized' ...
     , 'Position', [0.59 0.01 0.10 0.05], 'CallBack', ...
  'cd(pathnameasc);clf;eval(''dscale2(x0,x0,dx,ds,F)''); cd ..; cd ..; dfsalbut');

uiCLOSE = uicontrol('String', 'close', 'Units', 'normalized' ...
     , 'Position', [0.92 0.92 0.07 0.06] ...
     , 'CallBack', 'close(gcf)');

uiINFO = uicontrol('String', 'info', 'Units', 'normalized' ...
     , 'Position', [0.92 0.82 0.07 0.06] ...
     , 'CallBack', 'dfsalbum');

