%  DEMODRAW  - DEMO DRAWING FILTER REALIZATIONS
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2
%                                                                  
% call   demodraw
%
   
close all;
clear all; 

mypathname    = lower(pwd);
mypathnameold = lower(pwd);
myfilename    = 'untitled.m';
myfilenamem   = 'untitled';
mytitlefigure = 'DrawFilt version 2.8 - Drawing filters and systems in MATLAB';
matlabversion = version;
matrixEsize = 61;
editString    = [0 1];
matrixE       = blanks(matrixEsize);
matrixEnew    = blanks(matrixEsize);
matrixEdel    = [];
matrixEtag    = [];
matrixEdeltag = [];
XS            = blanks(matrixEsize);
digitalanalog = 0;
txtst = 1;
dc = 'b';
x0 = 0;
y0 = 0;
F =  9;
dx = 4;
ds = 5;
Nx = 9;
Ny = 7;


bdwidth = 5;
topbdwidth = 30;
screensize = get(0, 'ScreenSize');
mypos =        [0.1*screensize(3)+bdwidth,0.1*screensize(4)+bdwidth, ...
        0.89*screensize(3)-2*bdwidth,0.9*screensize(4)-(topbdwidth+bdwidth)];
mypos = [mypos;[0.01*screensize(3)+bdwidth,0.01*screensize(4)+bdwidth, ...
        0.25*screensize(3)-2*bdwidth,0.5*screensize(4)-(topbdwidth+bdwidth)]];
mypos = [mypos;[0.01*screensize(3)+bdwidth,0.3*screensize(4)+bdwidth, ...
        0.5*screensize(3)-2*bdwidth,0.7*screensize(4)-(topbdwidth+bdwidth)]];

mydffig1 = figure('Position',mypos(1,:)); axis off;
set(mydffig1, 'Name', mytitlefigure, 'NextPlot', 'replace','NumberTitle', 'off')
whitebg(mydffig1,[1 1 1]);

demotime1 = 3;  demotime2 = 3;
demotime3 = 3;  demotime4 = 3;

dc = 'b';
matrixEnew = blanks(matrixEsize);
rdr = 'clf;[x,y]= drawgrid(x0,y0,dx,ds,F,Nx,Ny);matrixEtag=bdrwredr(x0,y0,dx,ds,F,Nx,Ny,matrixE,dc);butdraw';
trdr = ['if txtst==1;' rdr ';txtst=0; end;'];

set(mydffig1, 'Name', mytitlefigure, ...
   'NextPlot', 'add','NumberTitle', 'off')
whitebg(mydffig1,[0.95 0.95 1]);
x0 = 0;  y0 = 0; F = 10; dx = 4; ds = 5;
Nx = 7; Ny = 5; dc = 'k'; dc = 'b';

matrixE = blanks(matrixEsize);
XS = blanks(matrixEsize);
txtst = 1;
clf
Nydx = 1;

clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
butdraw
  pause(demotime1)
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  title('CLICK a button','FontSize',14,'FontWeight','Bold','Color','red')
hold on, plot(Nx*dx/2,Ny*dx,'r^',[Nx*dx/2 Nx*dx/2],[(Ny*dx-1) Ny*dx],'r-','LineWidth',2), hold off
  pause(demotime1);
  uvIN = uicontrol('String', 'In', 'Units', 'normalized' ...
  , 'Position', [0.055 0.555 0.04 0.05], 'CallBack', ' ');
  title('INPUT ');
hold on, plot(Nx*dx/2,Ny*dx,'r^',[Nx*dx/2 Nx*dx/2],[(Ny*dx-1) Ny*dx],'r-','LineWidth',2);
         drawlhv(x(2),y(12),Nx*dx/2,(Ny*dx-1),1,'r');
         plot(x(1),y(12),'r<',[x(1) x(2)],[y(12) y(12)],'r-','LineWidth',2), hold off
pause(demotime2);
drawin(x(3),y(10),'X',2,ds/2,F, 'r');
hold on, plot(x(3),y(10),'rv',[x(3) x(3)],[y(10) y(11)],'r-','LineWidth',2); hold off
  pause(demotime3);
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);

  title('CLICK a button');pause(demotime1);
hold on, plot(Nx*dx/2,Ny*dx,'r^',[Nx*dx/2 Nx*dx/2],[(Ny*dx-1) Ny*dx],'r-','LineWidth',2), hold off
  uvADDER = uicontrol('String', 'Adder', 'Units', 'normalized' ...
  , 'Position', [0.01 0.940 0.08 0.05], 'CallBack', ' ');
hold on, plot(Nx*dx/2,Ny*dx,'r^',[Nx*dx/2 Nx*dx/2],[(Ny*dx-1) Ny*dx],'r-','LineWidth',2);
         drawlhv(x(2),y(20),Nx*dx/2,(Ny*dx-1),1,'r');
         plot(x(1),y(20),'r<',[x(1) x(2)],[y(20) y(20)],'r-','LineWidth',2), hold off
  pause(demotime2);title('ADDER input');
hold on, plot(x(3),y(10),'rv',[x(3) x(3)],[y(10) y(11)],'r-','LineWidth',2); hold off
  pause(demotime2);title('ADDER output');
hold on, plot(x(5),y(10),'rv',[x(5) x(5)],[y(10) y(11)],'r-','LineWidth',2); hold off
drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F,'r');

  pause(demotime3)
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);

  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  title('CLICK a button');

% break    % ------------------------------------
  pause(demotime1);
  uvMULT = uicontrol('String', 'Mult', 'Units', 'normalized' ...
  , 'Position', [0.01 0.885 0.08 0.05], 'CallBack',' ');
  pause(demotime2);title('MULTIPLIER input');pause(demotime2); title('MULTIPLIER  output');
drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F,'r');
  pause(demotime3)
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F, dc);
  title('CLICK a button');pause(demotime1);
  uvADDER = uicontrol('String', 'Adder', 'Units', 'normalized' ...
  , 'Position', [0.01 0.940 0.08 0.05], 'CallBack', ' ');
  pause(demotime2);title('ADDER input');pause(demotime2);title('ADDER output');
drawadd(x(8), y(9), 2, 1, 0, 1,' ',4,ds/3,F,'r');
  pause(demotime3)
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F, dc);
  drawadd(x(8), y(9), 2, 1, 0, 1,' ',4,ds/3,F, dc);
  title('CLICK a button');pause(demotime1);
  uvADDER = uicontrol('String', 'Adder', 'Units', 'normalized' ...
  , 'Position', [0.01 0.940 0.08 0.05], 'CallBack', ' ');
  pause(demotime2);title('ADDER input');pause(demotime2);title('ADDER output');
drawadd(x(3) , y(7), 2, 1, 1, 0,' ',6,ds/3,F,'r');
  pause(demotime3)
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F, dc);
  drawadd(x(8), y(9), 2, 1, 0, 1,' ',4,ds/3,F, dc);
  drawadd(x(3) , y(7), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  title('CLICK a button');pause(demotime1);
  uvDELAY = uicontrol('String', 'Delay', 'Units', 'normalized' ...
  , 'Position', [0.01 0.830 0.08 0.05], 'CallBack', ' ');
  pause(demotime2);title('DELAY input');pause(demotime2);title('DELAY  output');
drawdel(x(5),y(7),x(9),' ','-2', 14,ds/2,F,'r');
  pause(demotime3)
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F, dc);
  drawadd(x(8), y(9), 2, 1, 0, 1,' ',4,ds/3,F, dc);
  drawadd(x(3) , y(7), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawdel(x(5),y(7),x(9),' ','-2', 14,ds/2,F, dc);
  title('CLICK a button');pause(demotime1);
  uvLINE = uicontrol('String', 'LINE', 'Units', 'normalized' ...
  , 'Position', [0.01 0.665 0.08 0.05], 'CallBack',' ');
  pause(demotime2);title('LINE 1st point');pause(demotime2);title('LINE 2nd point');
drawline(x(9),y(8),x(4),y(9),'r');
  pause(demotime3)
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F, dc);
  drawadd(x(8), y(9), 2, 1, 0, 1,' ',4,ds/3,F, dc);
  drawadd(x(3) , y(7), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawdel(x(5),y(7),x(9),' ','-2', 14,ds/2,F, dc);
  drawline(x(9),y(8),x(4),y(9), dc);
  title('CLICK a button');pause(demotime1);
  uvLINEHV = uicontrol('String', '__I', 'Units', 'normalized' ...
  , 'Position', [0.01 0.61 0.045 0.05], 'CallBack',' ');
  pause(demotime2);title('2-segment line horizontal+vertical first point');
  pause(demotime2);title('2-segment line horizontal+vertical last point');
drawlhv(x(3),y(10),x(3),y(7), 0,'r');
  pause(demotime3)
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F, dc);
  drawadd(x(8), y(9), 2, 1, 0, 1,' ',4,ds/3,F, dc);
  drawadd(x(3) , y(7), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawdel(x(5),y(7),x(9),' ','-2', 14,ds/2,F, dc);
  drawline(x(9),y(8),x(4),y(9), dc);
  drawlhv(x(3),y(10),x(3),y(7), 0, dc);
  title('CLICK a button');pause(demotime1);
  uvLINEHV = uicontrol('String', '__I', 'Units', 'normalized' ...
  , 'Position', [0.01 0.61 0.045 0.05], 'CallBack',' ');
  pause(demotime2);title('2-segment line horizontal+vertical first point');
  pause(demotime2);title('2-segment line horizontal+vertical last point');
drawlhv(x(9),y(7),x(9),y(8), 0,'r');
  pause(demotime3)
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F, dc);
  drawadd(x(8), y(9), 2, 1, 0, 1,' ',4,ds/3,F, dc);
  drawadd(x(3) , y(7), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawdel(x(5),y(7),x(9),' ','-2', 14,ds/2,F, dc);
  drawline(x(9),y(8),x(4),y(9), dc);
  drawlhv(x(3),y(10),x(3),y(7), 0, dc);
  drawlhv(x(9),y(7),x(9),y(8), 0, dc);
  title('CLICK a button');pause(demotime1);
  uvLINE = uicontrol('String', 'LINE', 'Units', 'normalized' ...
  , 'Position', [0.01 0.665 0.08 0.05], 'CallBack',' ');
  pause(demotime2);title('LINE 1st point');pause(demotime2);title('LINE 2nd point');
drawline(x(9),y(10),x(4),y(8),'r');
  pause(demotime3)
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F, dc);
  drawadd(x(8), y(9), 2, 1, 0, 1,' ',4,ds/3,F, dc);
  drawadd(x(3) , y(7), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawdel(x(5),y(7),x(9),' ','-2', 14,ds/2,F, dc);
  drawline(x(9),y(8),x(4),y(9), dc);
  drawlhv(x(3),y(10),x(3),y(7), 0, dc);
  drawlhv(x(9),y(7),x(9),y(8), 0, dc);
  drawline(x(9),y(10),x(4),y(8), dc);
  title('CLICK a button');pause(demotime1);
  uvADDER = uicontrol('String', 'Adder', 'Units', 'normalized' ...
  , 'Position', [0.01 0.940 0.08 0.05], 'CallBack', ' ');
  pause(demotime2);title('ADDER input');pause(demotime2);title('ADDER output');
drawadd(x(10), y(9), 2, 1, 1, 0,' ',6,ds/3,F,'r');
  pause(demotime3)
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F, dc);
  drawadd(x(8), y(9), 2, 1, 0, 1,' ',4,ds/3,F, dc);
  drawadd(x(3) , y(7), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawdel(x(5),y(7),x(9),' ','-2', 14,ds/2,F, dc);
  drawline(x(9),y(8),x(4),y(9), dc);
  drawlhv(x(3),y(10),x(3),y(7), 0, dc);
  drawlhv(x(9),y(7),x(9),y(8), 0, dc);
  drawline(x(9),y(10),x(4),y(8), dc);
  drawadd(x(10), y(9), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  title('CLICK a button');pause(demotime1);
  uvMULT = uicontrol('String', 'Mult', 'Units', 'normalized' ...
  , 'Position', [0.01 0.885 0.08 0.05], 'CallBack',' ');
  pause(demotime2);title('MULTIPLIER input');pause(demotime2); title('MULTIPLIER  output');
drawmult(x(12), y(9),x(15),' ','b', 0,0.9*ds/2,F,'r');
  pause(demotime3)
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F, dc);
  drawadd(x(8), y(9), 2, 1, 0, 1,' ',4,ds/3,F, dc);
  drawadd(x(3) , y(7), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawdel(x(5),y(7),x(9),' ','-2', 14,ds/2,F, dc);
  drawline(x(9),y(8),x(4),y(9), dc);
  drawlhv(x(3),y(10),x(3),y(7), 0, dc);
  drawlhv(x(9),y(7),x(9),y(8), 0, dc);
  drawline(x(9),y(10),x(4),y(8), dc);
  drawadd(x(10), y(9), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawmult(x(12), y(9),x(15),' ','b', 0,0.9*ds/2,F, dc);
  title('CLICK a button');pause(demotime1);
  uvOUT = uicontrol('String', 'Out', 'Units', 'normalized' ...
  , 'Position', [0.01 0.50 0.08 0.05], 'CallBack',' ');
  pause(demotime2);title('OUTPUT');
drawout(x(15),y(9),'Y',0,ds/2,F,'r');
  pause(demotime3)
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F, dc);
  drawadd(x(8), y(9), 2, 1, 0, 1,' ',4,ds/3,F, dc);
  drawadd(x(3) , y(7), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawdel(x(5),y(7),x(9),' ','-2', 14,ds/2,F, dc);
  drawline(x(9),y(8),x(4),y(9), dc);
  drawlhv(x(3),y(10),x(3),y(7), 0, dc);
  drawlhv(x(9),y(7),x(9),y(8), 0, dc);
  drawline(x(9),y(10),x(4),y(8), dc);
  drawadd(x(10), y(9), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawmult(x(12), y(9),x(15),' ','b', 0,0.9*ds/2,F, dc);
  drawout(x(15),y(9),'Y',0,ds/2,F, dc);
  title('CLICK a button');pause(demotime1);
  uvDELAY = uicontrol('String', 'Delay', 'Units', 'normalized' ...
  , 'Position', [0.01 0.830 0.08 0.05], 'CallBack', ' ');
  pause(demotime2);title('DELAY input');pause(demotime2);title('DELAY  output');
drawdel(x(3),y(13),x(11),' ','-1',8,ds/2,F,'r');
  pause(demotime3)
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F, dc);
  drawadd(x(8), y(9), 2, 1, 0, 1,' ',4,ds/3,F, dc);
  drawadd(x(3) , y(7), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawdel(x(5),y(7),x(9),' ','-2', 14,ds/2,F, dc);
  drawline(x(9),y(8),x(4),y(9), dc);
  drawlhv(x(3),y(10),x(3),y(7), 0, dc);
  drawlhv(x(9),y(7),x(9),y(8), 0, dc);
  drawline(x(9),y(10),x(4),y(8), dc);
  drawadd(x(10), y(9), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawmult(x(12), y(9),x(15),' ','b', 0,0.9*ds/2,F, dc);
  drawout(x(15),y(9),'Y',0,ds/2,F, dc);
  drawdel(x(3),y(13),x(11),' ','-1',8,ds/2,F, dc);
  title('CLICK a button');pause(demotime1);
  uvNODE = uicontrol('String', 'NODE', 'Units', 'normalized' ...
  , 'Position', [0.01 0.445 0.08 0.05], 'CallBack',' ');
  pause(demotime2);title('NODE ');
drawnode(x(3) ,y(10) ,'1',1,1,F, 'r');
  pause(demotime3)
drawnode(x(3) ,y(10) ,'1',1,1,F, dc);
drawnode(x(5) ,y(10) ,'2',2,1,F, dc);
drawnode(x(9),y(10) ,'3',2,1,F, dc);
drawnode(x(10),y(9) ,'4',2,1,F, dc);
drawnode(x(9),y(8) ,'5',0,1,F, dc);
drawnode(x(5) ,y(7) ,'6',2,1,F, dc);
drawnode(x(11) ,y(10) ,'7',0,1,F, dc);
drawnode(x(12) ,y(9) ,'8',2,1,F, dc);
drawnode(x(15) ,y(9) ,'9',2,1,F, dc);  
  title('CLICK a button');pause(demotime1);
  uvLINEHV = uicontrol('String', '__I', 'Units', 'normalized' ...
  , 'Position', [0.01 0.445 0.08 0.05], 'CallBack',' ');
  pause(demotime2);title('2-segment line horizontal+vertical first point');
  pause(demotime2);title('2-segment line horizontal+vertical last point');
drawlhv(x(11),y(13),x(11),y(10), 0, dc);
drawlhv(x(3),y(10),x(3),y(13), 0, dc);
  pause(demotime3)
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F, dc);
  drawadd(x(8), y(9), 2, 1, 0, 1,' ',4,ds/3,F, dc);
  drawadd(x(3) , y(7), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawdel(x(5),y(7),x(9),' ','-2', 14,ds/2,F, dc);
  drawline(x(9),y(8),x(4),y(9), dc);
  drawlhv(x(3),y(10),x(3),y(7), 0, dc);
  drawlhv(x(9),y(7),x(9),y(8), 0, dc);
  drawline(x(9),y(10),x(4),y(8), dc);
  drawadd(x(10), y(9), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawmult(x(12), y(9),x(15),' ','b', 0,0.9*ds/2,F, dc);
  drawout(x(15),y(9),'Y',0,ds/2,F, dc);
  drawdel(x(3),y(13),x(11),' ','-1',8,ds/2,F, dc);
  drawnode(x(3) ,y(10) ,'1',1,1,F, dc);
  drawnode(x(3) ,y(10) ,'1',1,1,F, dc);
  drawnode(x(5) ,y(10) ,'2',2,1,F, dc);
  drawnode(x(9),y(10) ,'3',2,1,F, dc);
  drawnode(x(10),y(9) ,'4',2,1,F, dc);
  drawnode(x(9),y(8) ,'5',0,1,F, dc);
  drawnode(x(5) ,y(7) ,'6',2,1,F, dc);
  drawnode(x(11) ,y(10) ,'7',0,1,F, dc);
  drawnode(x(12) ,y(9) ,'8',2,1,F, dc);
  drawnode(x(15) ,y(9) ,'9',2,1,F, dc);  
  drawlhv(x(11),y(13),x(11),y(10), 0, dc);
  drawlhv(x(3),y(10),x(3),y(13), 0, dc);
  title('CLICK a button');pause(demotime1);
  uvTEXT = uicontrol('String', 'TEXT', 'Units', 'normalized' ...
  , 'Position', [0.01 0.390 0.08 0.05], 'CallBack',' ');
  pause(demotime2);title('Text');
  set(gcf,'DefaultTextColor','r')
drawtext(x(7), y(15),'TEXT filter', F+1,'r');
  set(gcf,'DefaultTextColor','k');
  pause(demotime3);
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F, dc);
  drawadd(x(8), y(9), 2, 1, 0, 1,' ',4,ds/3,F, dc);
  drawadd(x(3) , y(7), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawdel(x(5),y(7),x(9),' ','-2', 14,ds/2,F, dc);
  drawline(x(9),y(8),x(4),y(9), dc);
  drawlhv(x(3),y(10),x(3),y(7), 0, dc);
  drawlhv(x(9),y(7),x(9),y(8), 0, dc);
  drawline(x(9),y(10),x(4),y(8), dc);
  drawadd(x(10), y(9), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawmult(x(12), y(9),x(15),' ','b', 0,0.9*ds/2,F, dc);
  drawout(x(15),y(9),'Y',0,ds/2,F, dc);
  drawdel(x(3),y(13),x(11),' ','-1',8,ds/2,F, dc);
  drawnode(x(3) ,y(10) ,'1',1,1,F, dc);
  drawnode(x(3) ,y(10) ,'1',1,1,F, dc);
  drawnode(x(5) ,y(10) ,'2',2,1,F, dc);
  drawnode(x(9),y(10) ,'3',2,1,F, dc);
  drawnode(x(10),y(9) ,'4',2,1,F, dc);
  drawnode(x(9),y(8) ,'5',0,1,F, dc);
  drawnode(x(5) ,y(7) ,'6',2,1,F, dc);
  drawnode(x(11) ,y(10) ,'7',0,1,F, dc);
  drawnode(x(12) ,y(9) ,'8',2,1,F, dc);
  drawnode(x(15) ,y(9) ,'9',2,1,F, dc);  
  drawlhv(x(11),y(13),x(11),y(10), 0, dc);
  drawlhv(x(3),y(10),x(3),y(13), 0, dc);
  set(gcf,'DefaultTextColor','y');
  drawtext(x(7), y(15),'TEXT filter', F+1, dc);
  set(gcf,'DefaultTextColor','k');
  title('CLICK a button');pause(demotime1);
  uie = uicontrol('String', 'EDIT', 'Units', 'normalized' ...
     , 'Position', [0.92 0.62 0.08 0.05], 'CallBack',' ');
  pause(demotime2);title('CLICK an object node to EDIT');
  set(gcf,'DefaultTextColor','r')
  drawtext(x(7), y(15),'TEXT filter', F+1, dc);
  set(gcf,'DefaultTextColor','k');
  title('EDIT  Click left mouse button for YES, right for NO');
  pause(demotime2); title('YES'); pause(demotime2);
  set(gcf,'DefaultTextColor','b');
  drawtext(x(7), y(15),'Third-order digital filter', F+1, dc);
  set(gcf,'DefaultTextColor','k');
  pause(demotime3);
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F, dc);
  drawadd(x(8), y(9), 2, 1, 0, 1,' ',4,ds/3,F, dc);
  drawadd(x(3) , y(7), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawdel(x(5),y(7),x(9),' ','-2', 14,ds/2,F, dc);
  drawline(x(9),y(8),x(4),y(9), dc);
  drawlhv(x(3),y(10),x(3),y(7), 0, dc);
  drawlhv(x(9),y(7),x(9),y(8), 0, dc);
  drawline(x(9),y(10),x(4),y(8), dc);
  drawadd(x(10), y(9), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawmult(x(12), y(9),x(15),' ','b', 0,0.9*ds/2,F, dc);
  drawout(x(15),y(9),'Y',0,ds/2,F, dc) ;
  drawdel(x(3),y(13),x(11),' ','-1',8,ds/2,F, dc);
  drawnode(x(3) ,y(10) ,'1',1,1,F, dc);
  drawnode(x(3) ,y(10) ,'1',1,1,F, dc);
  drawnode(x(5) ,y(10) ,'2',2,1,F, dc);
  drawnode(x(9),y(10) ,'3',2,1,F, dc);
  drawnode(x(10),y(9) ,'4',2,1,F, dc);
  drawnode(x(9),y(8) ,'5',0,1,F, dc);
  drawnode(x(5) ,y(7) ,'6',2,1,F, dc);
  drawnode(x(11) ,y(10) ,'7',0,1,F, dc);
  drawnode(x(12) ,y(9) ,'8',2,1,F, dc);
  drawnode(x(15) ,y(9) ,'9',2,1,F, dc);  
  drawlhv(x(11),y(13),x(11),y(10), 0, dc);
  drawlhv(x(3),y(10),x(3),y(13), 0, dc);
  drawtext(x(7), y(15),'Third-order digital filter', F+1, dc);
  title('CLICK a button');pause(demotime1);
  uiDELETE = uicontrol('String', 'DELETE', 'Units', 'normalized' ...
  , 'Position', [0.89 0.07 0.11 0.05],'CallBack',' ');
  pause(demotime2);title('CLICK an object node to DELETE');
  drawdel(x(3),y(13),x(11),' ','-1',8,ds/2,F,'r');
  title('DELETE  Click left mouse button for YES, right for NO')
  pause(demotime2); title('YES'); pause(demotime2);
  clf;[x,y]=drawgrid(x0,y0,dx,ds,F,Nx,Ny);
  drawin(x(3),y(10),'X',2,ds/2,F, dc);                        
  drawadd(x(3) , y(10), 2, 0, 1, 3,' ',2,ds/3,F, dc);
  drawmult(x(5) , y(10),x(9),' ','a', 0,0.9*ds/2,F, dc);
  drawadd(x(8), y(9), 2, 1, 0, 1,' ',4,ds/3,F, dc);
  drawadd(x(3) , y(7), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawdel(x(5),y(7),x(9),' ','-2', 14,ds/2,F, dc);
  drawline(x(9),y(8),x(4),y(9), dc);
  drawlhv(x(3),y(10),x(3),y(7), 0, dc);
  drawlhv(x(9),y(7),x(9),y(8), 0, dc);
  drawline(x(9),y(10),x(4),y(8), dc);
  drawadd(x(10), y(9), 2, 1, 1, 0,' ',6,ds/3,F, dc);
  drawmult(x(12), y(9),x(15),' ','b', 0,0.9*ds/2,F, dc);
  drawout(x(15),y(9),'Y',0,ds/2,F, dc);
  drawnode(x(3) ,y(10) ,'1',1,1,F, dc);
  drawnode(x(3) ,y(10) ,'1',1,1,F, dc);
  drawnode(x(5) ,y(10) ,'2',2,1,F, dc);
  drawnode(x(9),y(10) ,'3',2,1,F, dc);
  drawnode(x(10),y(9) ,'4',2,1,F, dc);
  drawnode(x(9),y(8) ,'5',0,1,F, dc);
  drawnode(x(5) ,y(7) ,'6',2,1,F, dc);
  drawnode(x(11) ,y(10) ,'7',0,1,F, dc);
  drawnode(x(12) ,y(9) ,'8',2,1,F, dc);
  drawnode(x(15) ,y(9) ,'9',2,1,F, dc);  
  drawlhv(x(11),y(13),x(11),y(10), 0, dc);
  drawlhv(x(3),y(10),x(3),y(13), 0, dc);
  drawtext(x(7), y(15),'Third-order digital filter', F+1, dc);
  title('CLICK a button');pause(demotime1);
  pause(5);

clear example1;
clf;example1(0,0,4,5,10); pause(demotime3);
fh2 = figure('Position',mypos(3,:),'Name','DEMO DrawFilt'); axis off;
whitebg(fh2,[1 1 1]); pause(demotime1);
clf;example1(0,0,4,5,10); pause(demotime3);
clf;example2(0,0,4,5,10); pause(demotime3);
clf;example3(0,0,4,5,10); pause(demotime3);
clf;example4(0,0,4,5,10); pause(demotime3);
clf;example5(0,0,4,5,10); pause(demotime3);
clf;example6(0,0,4,5,10); pause(demotime3);

disp(' ')
disp(' ')
disp(' Invoke this toolbox by executing')
disp('                         drawfilt')
disp('---------------------------------')
disp(' ')
disp(' ')
drawfilt
