%   DRAWING FILTER REALIZATIONS TOOLBOX
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2
%   
%  MAIN SCRIPT, BASIC OPERATIONS, DEMOS and OTHER
%   drawfilt.m   -  Run DrawFilt - drawing filter realizations (main script)
%   dfalbum.m    -  Album of digital filter realizations (main script)
%   afalbum.m    -  Album of analog filter realizations (main script)
%   scalbum.m    -  Album of analog SC filter realizations (main script)
%   contents.m   -  This file
%   demodraw.m   -  Demo
%   license.txt  -  GNU General Public License
%   untitled.m   -  Schematic MATLAB script
%   untitled.ma  -  Schematic Mathematica 2.x notebook
%   untitled.mma -  Schematic Mathematica package
%   untitled.nb  -  Schematic Mathematica 3.x template notebook
%   
% WHAT'S NEW 
%   readmedf.txt - New features and enhancements in this version.
%   
% BUTTONS
%   butdraw.m    -  Button: Generate Buttons
%   buttonde.m   -  Button: Draw element
%   butdelet.m   -  Button: Delete object
%   butedit.m    -  Button: Edit object 
%   bdrwinfo.m   -  Button: Show short help
%   bdrwload.m   -  Button: Quick open schematic
%   bdrwmath.m   -  Button: Export to Mathematica 
%   bdrwopen.m   -  Button: Open schematic
%   bdrwredr.m   -  Button: Redraw schematic 
%   bdrwsaas.m   -  Button: Save schematic (save as)
%   bdrwsave.m   -  Button: Quick save schematic
%   butundo.m    -  Button: Undo
%   butonde.m    -  Button: Draw object
%   
% INTERNALLY USED UTILITY ROUTINES
%   butdraw.m    -  Generate buttons: Draw Digital & Analog Filter Realizations
%   dfalbut.m    -  Generate buttons: Album of Digital Filter Realizations
%   dfsalbut.m   -  Generate buttons: Album of Digital Filter Realizations
%   afalbut.m    -  Generate buttons: Album of Analog Filter Realizations
%   scalbut.m    -  Generate buttons: Album of Analog SC Filter Realizations
%   dinsstra.m   -  Internal utility
%   dfcomp.m     -  Internal utility
%   dfdecomp.m   -  Internal utility
%   dfedita.m    -  Internal utility
%   dfnodes.m    -  Internal utility
%   
% DRAW
%   draw4tbl.m   -  Draw 4 terminal block
%   drawadd.m    -  Draw adder
%   drawarrw.m   -  Draw arrow
%   drawblo.m    -  Draw single-input single-output block
%   drawcap.m    -  Draw capacitor
%   drawcc.m     -  Draw current conveyor
%   drawccs.m    -  Draw controlled current source
%   drawcs.m     -  Draw current source
%   drawcvs.m    -  Draw controlled voltage source
%   drawdel.m    -  Draw delay
%   drawdown.m   -  Draw down sampler
%   drawflib.mma -  Mathematica DrawFilt library
%   drawgrid.m   -  Draw grid
%   drawgrnd.m   -  Draw ground
%   drawimp.m    -  Draw impedance
%   drawin.m     -  Draw input
%   drawlhv.m    -  Draw line horizontal + vertical
%   drawline.m   -  Draw line between 2 points
%   drawlnd.m    -  Draw inductor
%   drawlvh.m    -  Draw line vertical + horizontal
%   drawmath.m   -  Draw schematic in Mathematica
%   drawmult.m   -  Draw multiplier
%   drawnode.m   -  Draw node
%   drawopam.m   -  Draw operational amplifier (OpAmp)
%   drawota.m    -  Draw OTA
%   drawout.m    -  Draw output
%   drawres.m    -  Draw resistor
%   drawtext.m   -  Draw text
%   drawupsa.m   -  Draw up sampler
%   drawvs.m     -  Draw voltage source
%   
% MATHEMATICA
%   untitled.ma  -  Template notebook for Mathematica 2.x DrawFilt
%   untitled.nb  -  Template notebook for Mathematica 3.x DrawFilt

% EXAMPLE schematics
%   example1.m   -  Example 1: Draw third-order digital filter
%   example2.m   -  Example 2: Draw cascade realization -- direct-form II biquad
%   example3.m   -  Example 3: Draw Kerwin-Huelsman-Newcomb analog filter
%   example4.m   -  Example 4: Draw all objects
%   example5.m   -  Example 5: Draw transpose-direct-form II biquad
%   example6.m   -  Example 6: Draw Ansari-Liu digital filter realization (biquad)
%   
% EXAMPLE ALBUM
%   
% EXAMPLE ALBUM\DEMOS
%   drawall.m    -  Draw all objects
%   demomult.m   -  Multiplier drawing demo
%   untitled.m   -  Schematic MATLAB script
%   untitled.ma  -  Schematic Mathematica 2.x notebook
%   untitled.mma -  Schematic Mathematica package
%   drawflib.mma -  DrawFilt library for Mathematica
%   untitled.nb  -  Schematic Mathematica 3.x template notebook
%   untitled.eps -  Schematic in EPS format
%   
% EXAMPLE ALBUM\DIGITAL
%   draw3rd.m    -  Draw third-order digital filter
%   drawap1a.m   -  Draw Ansari-Liu digital filter first-order realization type A
%   drawap1b.m   -  Draw Ansari-Liu digital filter first-order realization type B
%   drawap1c.m   -  Draw Ansari-Liu digital filter first-order realization type C
%   drawap2a.m   -  Draw Ansari-Liu digital filter realization -- biquad type A
%   drawap2b.m   -  Draw Ansari-Liu digital filter realization -- biquad type B
%   drawap2c.m   -  Draw Ansari-Liu digital filter realization -- biquad type C
%   drawcdf2.m   -  Draw cascade realization -- direct-form II biquad
%   drawdf1.m    -  Draw first-order direct-form II
%   drawdf2b.m   -  Draw direct-form II biquad
%   drawtdf1.m   -  Draw first-order transpose-direct-form II
%   drawtdf2.m   -  Draw transpose-direct-form II biquad
%   dfircf.m     -  Draw cascade FIR realization
%   dfirdfa.m    -  Draw direct form FIR realization
%   dfirlp1.m    -  Draw linear-phase FIR realization type 1
%   dfirlp2.m    -  Draw linear-phase FIR realization type 2
%   dfirtdfa.m   -  Draw transpose direct form FIR realization
%   df2gen01.m   -  Draw second-order digital filter (genetic programming design)
%   df2gen02.m   -  Draw second-order digital filter (genetic programming design)
%   dirfors1.m   -  Draw direct-form I biquad
%   drawwdf5.m   -  Draw wave digital biquad
%   polydec5.m   -  Draw decimation filter
%   polydec6.m   -  Draw interpolation filter
%   
% EXAMPLE ALBUM\DFSTRUCT
%   ddf1.m       -  Draw direct form I filter
%   ddf1t.m      -  Draw direct form I transposed filter
%   ddf2.m       -  Draw direct form II filter
%   ddf2t.m      -  Draw direct form II transposed filter
%   dfir.m       -  Draw direct form FIR filter
%   dfirt.m      -  Draw direct form FIR transposed filter
%   dsymfiro.m   -  Draw direct form symmetric FIR (Type I) filter
%   dsymfire.m   -  Draw direct form symmetric FIR (Type II) filter
%   dasymfio.m   -  Draw direct form antisymmetric FIR (Type III) filter
%   dasymfie.m   -  Draw direct form antisymmetric FIR (Type IV) filter
%   dlatcar.m    -  Draw lattice AR filter
%   dlatcall.m   -  Draw lattice allpass filter
%   dlatcma.m    -  Draw lattice MA min. phase filter
%   dlatcmax.m   -  Draw lattice MA max. phase filter
%   dlatcarm.m   -  Draw lattice ARMA filter
%   dlatcca.m    -  Draw lattice coupled-allpass filter
%   dlatccap.m   -  Draw lattice coupled-allpass power-complementary filter
%   dstatesp.m   -  Draw state-space filter
%   dscale1.m    -  Scale values applied to a single section
%   dscale2.m    -  Scale values applied to multiple sections
%   
% EXAMPLE ALBUM\CC
%   drawccsk.m   -  Draw CC Sallen-Key biquad
%   
% EXAMPLE ALBUM\CIRCUITS
%   attencs.m    -  Draw resistive T-attenuator driven by a current source
%   attenvs.m    -  Draw resistive T-attenuator driven by a voltage source
%   cdivider.m   -  Draw resistive current divider
%   fbvamp.m     -  Draw feedback voltage amplifier
%   invamp.m     -  Draw inverting amplifier
%   vdivider.m   -  Draw resistive voltage divider
%   vfollow.m    -  Draw voltage follower amplifier
%   wien.m       -  Draw Wien bridge oscillator
%   
% EXAMPLE ALBUM\OPAMP
%   drawaphq.m   -  Draw allpass high-Q-factor op amp RC biquad
%   drawaplq.m   -  Draw allpass low-Q-factor op amp RC biquad
%   drawapmq.m   -  Draw allpass medium-Q-factor op amp RC biquad
%   drawbphq.m   -  Draw bandpass high-Q-factor op amp RC biquad
%   drawbplq.m   -  Draw bandpass low-Q-factor op amp RC biquad
%   drawbpmq.m   -  Draw bandpass medium-Q-factor op amp RC biquad
%   drawbrhq.m   -  Draw bandreject high-Q-factor op amp RC biquad
%   drawbrlq.m   -  Draw bandreject low-Q-factor op amp RC biquad
%   drawbrmq.m   -  Draw bandreject medium-Q-factor op amp RC biquad
%   drawhnhq.m   -  Draw highpass notch high-Q-factor op amp RC biquad
%   drawhnmq.m   -  Draw highpass notch medium-Q-factor op amp RC biquad
%   drawhphq.m   -  Draw highpass high-Q-factor op amp RC biquad
%   drawhplq.m   -  Draw highpass low-Q-factor op amp RC biquad
%   drawhpmq.m   -  Draw highpass medium-Q-factor op amp RC biquad
%   drawkhn.m    -  Draw KHN Kerwin-Huelsman-Newcomb op amp RC biquad
%   drawlnhq.m   -  Draw lowpass notch high-Q-factor op amp RC biquad
%   drawlnmq.m   -  Draw lowpass notch medium-Q-factor op amp RC biquad
%   drawlphq.m   -  Draw lowpass high-Q-factor op amp RC biquad
%   drawlplq.m   -  Draw lowpass low-Q-factor op amp RC biquad
%   drawlpmq.m   -  Draw lowpass medium-Q-factor op amp RC biquad
%   
% EXAMPLE ALBUM\OTA
%   drawotab.m   -  Draw four OTA general biquad
%   drawotac.m   -  Draw four OTA notch biquad
%   drawotad.m   -  Draw five OTA universal biquad
%   drawotae.m   -  Draw simple lowpass notch OTA-C biquad
%   drawotaf.m   -  Draw four element universal OTA-C biquad
%   drawota4.m   -  Draw four OTA notch biquad
%   
% EXAMPLE ALBUM\RLC
%   drawlc1.m    -  Draw doubly terminated LC-ladder with complex zeros
%   drawlc2.m    -  Draw singly terminated LC-ladder with complex zeros
%   drawlc3.m    -  Draw singly terminated LC-ladder with zeros at origin
%   drawlc4.m    -  Draw LC-ladder
%   
% EXAMPLE ALBUM\SC
%   drawsc1.m    -  Draw SC mode 1 realization
%   drawsc1a.m   -  Draw SC mode 1a realization
%   drawsc1b.m   -  Draw SC mode 1b realization
%   drawsc1c.m   -  Draw SC mode 1c realization
%   drawsc1d.m   -  Draw SC mode 1d realization
%   drawsc2.m    -  Draw SC mode 2 realization
%   drawsc2a.m   -  Draw SC mode 2a realization
%   drawsc2b.m   -  Draw SC mode 2b realization
%   drawsc3.m    -  Draw SC mode 3 realization
%   drawsc3a.m   -  Draw SC mode 3a realization
%   drawsc4.m    -  Draw SC mode 4 realization
%   drawsc4a.m   -  Draw SC mode 4a realization
%   drawsc5.m    -  Draw SC mode 5 realization
%   drawsc6a.m   -  Draw SC mode 6a realization
%   drawsc6b.m   -  Draw SC mode 6b realization
%   drawsc7.m    -  Draw SC mode 7 realization
%   drawscu1.m   -  Draw SC universal mode 1 realization
%   drawscu2.m   -  Draw SC universal mode 2 realization
%   
% EXAMPLE ALBUM\UTILITY
%   drawall.m    -  Draw all objects
%   drawsk2b.m   -  Draw cascaded connection of two Sallen-Key biquads
%   drawskoa.m   -  Draw Sallen-Key biquad (called by drawsk2b.m)
%   dfirdfa.m    -  Draw direct form FIR realization
%   dfirtdfa.m   -  Draw transpose direct form FIR realization
%   fir16a.m     -  Draw lowpass FIR filter, n_FIR = 31
%   mit6p5.m     -  Schematic called from within another MATLAB script
%   mit6p5t.m    -  Schematic called from within another MATLAB script

