% butdraw.m  
%  GENERATE BUTTONS: DRAW DIGITAL & ANALOG FILTER REALIZATIONS
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2
                 
% ----------  ALL: analog + digital   ------------------------------------------------------
% ----------  Edit window not active  ------------------------------------------------------
if  editString(1) == 0

mybutton{1,2} = uicontrol('String', 'Adder', 'Units', 'normalized' ...
 , 'Position', [0.01 0.940 0.08 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''adderx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{2,2} = uicontrol('String', 'Mult', 'Units', 'normalized' ...
 , 'Position', [0.01 0.885 0.08 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''multip'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{3,2} = uicontrol('String', 'Delay', 'Units', 'normalized' ...
 , 'Position', [0.01 0.830 0.08 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''delayx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{4,2} = uicontrol('String', 'UP', 'Units', 'normalized' ...
 , 'Position', [0.01 0.775 0.08 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''upsamp'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{5,2} = uicontrol('String', 'down', 'Units', 'normalized' ...
 , 'Position', [0.01 0.72 0.08 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''downsa'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{6,2} = uicontrol('String', 'LINE', 'Units', 'normalized' ...
 , 'Position', [0.01 0.665 0.08 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''linexx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{7,2} = uicontrol('String', 'PolyLine', 'Units', 'normalized' ...
 , 'Position', [0.415 0.01 0.10 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''polyli'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{8,2} = uicontrol('String', '__I', 'Units', 'normalized' ...
 , 'Position', [0.01 0.61 0.045 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''linehv'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{9,2}= uicontrol('String', 'I__', 'Units', 'normalized' ...
 , 'Position', [0.01 0.555 0.045 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''linevh'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{10,2} = uicontrol('String', '>', 'Units', 'normalized' ...
 , 'Position', [0.055 0.61 0.04 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''arrowx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{11,2} = uicontrol('String', 'In', 'Units', 'normalized' ...
 , 'Position', [0.055 0.555 0.04 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''inputx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{12,2} = uicontrol('String', 'Out', 'Units', 'normalized' ...
 , 'Position', [0.01 0.50 0.08 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''output'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{13,2} = uicontrol('String', 'NODE', 'Units', 'normalized' ...
 , 'Position', [0.01 0.445 0.08 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''nodexx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{14,2} = uicontrol('String', 'TEXT', 'Units', 'normalized' ...
 , 'Position', [0.01 0.390 0.08 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''textxx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{15,2} = uicontrol('String', 'Block', 'Units', 'normalized' ...
 , 'Position', [0.01 0.335 0.08 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''blockx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{16,2} = uicontrol('String', 'Block 4', 'Units', 'normalized' ...
 , 'Position', [0.01 0.285 0.085 0.045], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''block4'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{17,2} = uicontrol('Style', 'text', 'Units', 'normalized' ...
     , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.92 0.92 0.92] ...
     , 'Position', [0.925 0.365 0.12 0.10] ...
     , 'String', 'examples');

% ----------  hide analog   ---------------------------------------------------------
if digitalanalog == 0

mybutton{18,2} = uicontrol('String', 'CC', 'Units', 'normalized' ...
 , 'Position', [0.01 0.230 0.08 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''ccxxxx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{19,2} = uicontrol('String', 'OTA', 'Units', 'normalized' ...
 , 'Position', [0.01 0.175 0.08 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''otaxxx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{20,2} = uicontrol('String', 'OpAmp', 'Units', 'normalized' ...
 , 'Position', [0.01 0.120 0.08 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''opamxx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{21,2} = uicontrol('String', 'GRND', 'Units', 'normalized' ...
 , 'Position', [0.01 0.065 0.08 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''grndxx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{22,2} = uicontrol('String', 'R', 'Units', 'normalized' ...
 , 'Position', [0.01 0.01 0.04 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''resxxx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{23,2} = uicontrol('String', 'C', 'Units', 'normalized' ...
 , 'Position', [0.055 0.01 0.04 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''capxxx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{24,2} = uicontrol('String', 'L', 'Units', 'normalized' ...
 , 'Position', [0.1 0.01 0.04 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''lndxxx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{25,2} = uicontrol('String', 'Z', 'Units', 'normalized' ...
 , 'Position', [0.145 0.01 0.04 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''impxxx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{26,2} = uicontrol('String', '(V)', 'Units', 'normalized' ...
 , 'Position', [0.19 0.01 0.05 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''vsxxxx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{27,2} = uicontrol('String', '(I)', 'Units', 'normalized' ...
 , 'Position', [0.245 0.01 0.05 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''csxxxx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{28,2} = uicontrol('String', '<V>', 'Units', 'normalized' ...
 , 'Position', [0.3 0.01 0.05 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''cvsxxx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{29,2} = uicontrol('String', '<I>', 'Units', 'normalized' ...
 , 'Position', [0.355 0.01 0.05 0.05], 'CallBack', ...
 ['[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''ccsxxx'',txtst,matrixEsize,matrixEtag); butdraw;']);
mybutton{30,2} = uicontrol('String', '3', 'Units', 'normalized' ...
  , 'Position', [0.945 0.365 0.025 0.03], 'CallBack', ...
  ['fh2 = figure(''Position'',mypos(3,:));clf;' ...
  'set(fh2,''Name'', ''EXAMPLE from example3.m'', ''NumberTitle'', ''off'');example3(0,0,4,5,9)']);
mybutton{31,2} = uicontrol('String', '4', 'Units', 'normalized' ...
  , 'Position', [0.975 0.365 0.025 0.03], 'CallBack', ...
  ['fh2 = figure(''Position'',mypos(3,:));clf;' ...
  'set(fh2,''Name'', ''EXAMPLE from example4.m'', ''NumberTitle'', ''off'');example4(0,0,4,5,9)']);
mybutton{32,2} = uicontrol('String', 'digital', 'Units', 'normalized' ...
 , 'Position', [0.92 0.895 0.08 0.04], 'CallBack', ['digitalanalog = 1;' ...
 'txtst=1; [xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''redraw'',txtst,matrixEsize,matrixEtag);' ...
 '[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''redraw'',txtst,matrixEsize,matrixEtag); butdraw;']);

end

% ----------  ALL: analog + digital   ------------------------------------------------------

mybutton{33,2}= uicontrol('String', 'info', 'Units', 'normalized' ...
     , 'Position', [0.82 0.94 0.08 0.05] ...
     , 'CallBack', 'clf,bdrwinfo(myfilename,myfilenamem,digitalanalog);txtst=1;butdraw;');
mybutton{34,2} = uicontrol('String', 'close', 'Units', 'normalized' ...
   , 'Position', [0.92 0.94 0.08 0.05], 'CallBack', ['cd(mypathnameold); close all']);
mybutton{35,2} = uicontrol('String', 'NEW', 'Units', 'normalized' ...
     , 'Position', [0.92 0.78 0.08 0.05], 'CallBack', ...
     ['mypathname = lower(pwd); myfilename = ''untitled.m''; myfilenamem = ''untitled''; ' ...
     'clf; [x,y]= drawgrid(x0,y0,dx,ds,F,Nx,Ny);matrixE=matrixEnew;matrixEtag=[];matrixEdel=[];matrixEdeltag=[];butdraw;']);

if digitalanalog == 1
  mybutton{36,2} = uicontrol('String', 'analog', 'Units', 'normalized' ...
   , 'Position', [0.92 0.895 0.08 0.04], 'CallBack', ['digitalanalog = 0;' ...
   'txtst=1; [xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''redraw'',txtst,matrixEsize,matrixEtag);' ...
   '[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''redraw'',txtst,matrixEsize,matrixEtag); butdraw;']);
  mybutton{37,2} = uicontrol('String', '5', 'Units', 'normalized' ...
    , 'Position', [0.945 0.365 0.025 0.03], 'CallBack', ...
  ['fh2 = figure(''Position'',mypos(3,:));clf;' ...
  'set(fh2,''Name'', ''EXAMPLE from example5.m'', ''NumberTitle'', ''off'');example5(0,0,4,5,9)']);
  mybutton{38,2} = uicontrol('String', '6', 'Units', 'normalized' ...
    , 'Position', [0.975 0.365 0.025 0.03], 'CallBack', ...
  ['fh2 = figure(''Position'',mypos(3,:));clf;' ...
  'set(fh2,''Name'', ''EXAMPLE from example6.m'', ''NumberTitle'', ''off'');example6(0,0,4,5,9)']);
end
 
mybutton{39,2} = uicontrol('String', 'OPEN', 'Units', 'normalized', ...
'Position', [0.92 0.72 0.08 0.05], 'CallBack', ...
['clf;[x,y]= drawgrid(x0,y0,dx,ds,F,Nx,Ny);' ...
'[matrixE,myfilename,mypathname]=bdrwopen(x0,y0,dx,ds,F,Nx,Ny,matrixE,myfilename,mypathname);' ...
'myfilenamem = myfilename(1:(length(myfilename)-2));' ...
'matrixEtag=bdrwredr(x0,y0,dx,ds,F,Nx,Ny,matrixE,dc);butdraw']);

mybutton{40,2} = uicontrol('String', 'EDIT', 'Units', 'normalized' ...
     , 'Position', [0.92 0.60 0.08 0.05], 'CallBack', ...
 ['if length(matrixEtag)>0; editString(1)=1;EditChangeStr1 = 0;' rdr ...
 ';[matrixEeditind,matrixEedit,matrixEedittag]=butedit(x0,y0,dx,ds,F,Nx,Ny,matrixE,matrixEtag);' ...
     'dfedita; end;']);

mybutton{41,2} = uicontrol('Style', 'text', 'Units', 'normalized' ...
     , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.99 0.99 0.092] ...
     , 'Position', [0.915 0.05 0.09 0.305] ...
     , 'String', myfilenamem);

mybutton{42,2} = uicontrol('String', 'MA', 'Units', 'normalized', ...
       'Position', [0.92 0.05 0.08 0.05], 'CallBack', ...
       'matrixEma = bdrwmath(matrixE,myfilename,mypathname);');

mybutton{43,2} = uicontrol('String', 'EPS', 'Units', 'normalized', ...
      'Position', [0.92 0.105 0.08 0.05], 'CallBack', ...
     ['fh2 = figure(''Position'',mypos(3,:));clf;whitebg(fh2,[1 1 1]);' ...
     ' set(fh2,''NumberTitle'', ''off'',''Name'', ''Make EPS file from ' ...
     mypathname myfilenamem '.m '');' ...
     myfilenamem '(0,0,4,5,9); print -deps ' myfilenamem '.eps']);

mybutton{44,2} = uicontrol('String', 'view', 'Units', 'normalized' ...
     , 'Position', [0.92 0.16 0.08 0.05], 'CallBack'...
     ,['fh2 = figure(''Position'',mypos(3,:));clf;' ...
     ' set(fh2,''NumberTitle'', ''off'',''Name'', ''VIEW realization ' ...
     mypathname myfilenamem '.m '');' ...
     myfilenamem '(0,0,4,5,8); whitebg(fh2,[1 1 1])']);

mybutton{45,2} = uicontrol('String', 'open', 'Units', 'normalized', ...  
   'Position', [0.92 0.215 0.08 0.05], 'CallBack', ...
   ['clf;[x,y]= drawgrid(x0,y0,dx,ds,F,Nx,Ny);' ...
   '[matrixE,myfilename,mypathname]=bdrwload(x0,y0,dx,ds,F,Nx,Ny,matrixE,myfilename,mypathname);'...
   'myfilenamem = myfilename(1:(length(myfilename)-2));' ...
   'matrixEtag=bdrwredr(x0,y0,dx,ds,F,Nx,Ny,matrixE,dc);butdraw']);

mybutton{46,2} = uicontrol('String', '1', 'Units', 'normalized' ...
     , 'Position', [0.945 0.4 0.025 0.03], 'CallBack', ...
  ['fh2 = figure(''Position'',mypos(3,:));clf;' ...
  'set(fh2,''Name'', ''EXAMPLE from example1.m'', ''NumberTitle'', ''off'');example1(0,0,4,5,9)']);
mybutton{47,2} = uicontrol('String', '2', 'Units', 'normalized' ...
     , 'Position', [0.975 0.4 0.025 0.03], 'CallBack', ...
  ['fh2 = figure(''Position'',mypos(3,:));clf;' ...
  'set(fh2,''Name'', ''EXAMPLE from example2.m'', ''NumberTitle'', ''off'');example2(0,0,4,5,9)']);
mybutton{48,2} = uicontrol('String', 'DELETE', 'Units', 'normalized' ...
 , 'Position', [0.92 0.48 0.08 0.05],'CallBack', ...
 [rdr ';[matrixE,matrixEtag,matrixEdel,matrixEdeltag]=butdelet(x0,y0,dx,ds,F,Nx,Ny,matrixE,matrixEtag);title(''CLICK a button'',''Color'',''blue'',''FontWeight'',''Bold'')']);
  
mybutton{49,2} = uicontrol('String', 'UNDO', 'Units', 'normalized' ...
 , 'Position', [0.92 0.54 0.08 0.05],'CallBack', ...
 [rdr ';[matrixE,matrixEtag]=butundo(x0,y0,dx,ds,F,Nx,Ny,matrixE,matrixEdel,matrixEtag,matrixEdeltag);matrixEdel=[];matrixEdeltag=[];' ...
 ' title(''CLICK a button'',''FontWeight'',''Bold'')']);

mybutton{50,2} = uicontrol('String', 'redraw', 'Units', 'normalized', ...
    'Position', [0.92 0.84 0.09 0.05], 'CallBack', ...
    ['txtst=1; [xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''redraw'',txtst,matrixEsize,matrixEtag);' ...
    '[xs,matrixE,txtst,matrixEsize,matrixEtag]=buttonde(matrixE,x,y,ds,F,dc,''redraw'',txtst,matrixEsize,matrixEtag); butdraw;']);

mybutton{51,2} = uicontrol('String', 'save', 'Units', 'normalized', ...
         'Position', [0.92 0.270 0.08 0.05], ...
         'CallBack', '[myfilename,mypathname]=bdrwsave(matrixE,myfilename,mypathname);');

mybutton{52,2} = uicontrol('String', 'save as', 'Units', 'normalized' ...
     , 'Position', [0.92 0.66 0.08 0.05] ...
     , 'CallBack', ['[myfilename,mypathname]=bdrwsaas(matrixE,myfilename,mypathname);' ...
       'myfilenamem = myfilename(1:(length(myfilename)-2));' ...
     'matrixEtag=bdrwredr(x0,y0,dx,ds,F,Nx,Ny,matrixE,dc);butdraw']);
  
mybutton{53,2} = uicontrol('Style', 'text', 'Units', 'normalized' ...
     , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.99 0.99 0.099] ...
     , 'Position', [0.15 0.97 0.665 0.025] ...
     , 'String', mypathname);

mybutton{54,2} = uicontrol('Style', 'text', 'Units', 'normalized' ...
     , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.99 0.99 0.092] ...
     , 'Position', [0.71 0.01 0.29 0.04] ...
     , 'String', myfilename);

title('CLICK a button','Color','blue','FontWeight','Bold');

end
  


