function [matrixEE,matrixEtag,matrixEdel,matrixEdeltag] = butdelet(x0,y0,dx,ds,F,Nx,Ny,matrixE,matrixEtag)
% butdelet.m   BUTTON: DELETE OBJECT
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2

title('CLICK an object node to DELETE','Color','Red','FontWeight','Bold')

matrixEdel = [];
matrixEdeltag = [];
indEdeltag = 0;
x = (1:4*Nx)*dx/4 + x0; y = (1:4*Ny)*dx/4 + y0;
[xe1,ye1]=ginput(1);
xe2 = round(xe1); 
ye2 =round(ye1);
[nE,ns] = size(matrixE);
but = 0;

[matrixEs,newmatrixEs] = dfdecomp(matrixE);
[matrixE1x,matrixE1y] = dfnodes(matrixEs);

[nEx,nsx] = size(matrixE1x);
for indE = 1:nE
  xe3 = str2num(matrixE1x(indE,:));
  ye3 = str2num(matrixE1y(indE,:));
  xe4 = min((xe3 - xe2).^2);
  ye4 = min((ye3 - ye2).^2);
  xye(indE,:) = [indE xe4+ye4];
end
minerror = min(xye(:,2)) + 3;
c = get(gca,'Children');
for indE = nE:-1:1
  if xye(indE,2) < minerror
    % disp(matrixE(xye(indE,1),:))
    deltag = matrixEtag(xye(indE));
    for ind = 1:length(c)
        c1 = get(c(ind));
        if strcmp(c1.Tag,deltag)
           if strcmp(c1.Type,'text')|strcmp(c1.Type,'line')
              set(c(ind),'color','Green');
           elseif strcmp(c1.Type,'rectangle')
              set(c(ind),'edgecolor','Green');
           end
        end
    end
    title('DELETE  Click left mouse button for YES, right for NO','Color','Red')
    [xxe,yye,but]=ginput(1);
    if ((but == 1)|(but == 13))
       matrixEdel = strvcat(matrixEdel,matrixE(indE,:));
       matrixEdeltag{indEdeltag+1} = deltag;
       indEdeltag = indEdeltag + 1;
       for ind = 1:length(c)
           c1 = get(c(ind));
           if strcmp(c1.Tag,deltag)
              if strcmp(c1.Type,'text')|strcmp(c1.Type,'line')
                 set(c(ind),'color','Red');
              elseif strcmp(c1.Type,'rectangle')
                 set(c(ind),'edgecolor','Red');
              end
           end
       end
       matrixE(indE,:)=[];
       matrixEtag(indE) = [];
    else
       for ind = 1:length(c)
           c1 = get(c(ind));
           if strcmp(c1.Tag,deltag)
              if strcmp(c1.Type,'text')|strcmp(c1.Type,'line')
                 set(c(ind),'color','Blue');
              elseif strcmp(c1.Type,'rectangle')
                 set(c(ind),'edgecolor','Blue');
              end
           end
       end
    end
  end
end

matrixEE = matrixE;
