function [filename,pathname] = bdrwsaas(matrixE,myfilename,mypathname)
% bdrwsaas.m  BUTTON: SAVE SCHEMATIC
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2

pathnamea = lower(pwd);
pathnameb = lower([pathnamea '\album']);

pathinvname = fliplr(pathnamea);
epathnamea  = strmatch('tlifward',pathinvname);

if size(epathnamea) > 0
   if epathnamea(1) == 1
      existalbum = exist('album','dir');
      if existalbum == 7
         cd(pathnameb);
         [filename, pathname] = uiputfile('*.m', 'Save Schematic (use valid MATLAB function name)');
         filespec = [pathname, filename];
         if filename == 0
            filename = myfilename;
            pathname = mypathname;
            cd(pathnamea);
            return
         else
            cd(pathname);
         end
      else
        [filename, pathname] = uiputfile('*.m', 'Save Schematic (use valid MATLAB function name)');
        filespec = [pathname, filename];
         if filename == 0
            filename = myfilename;
            pathname = mypathname;
            cd(pathnamea);
            return
         else
            cd(pathname);
         end
      end
   else
      [filename, pathname] = uiputfile('*.m', 'Save Schematic (use valid MATLAB function name)');
      filespec = [pathname, filename];
      if filename == 0
         filename = myfilename;
         pathname = mypathname;
         cd(pathnamea);
         return
      else
         cd(pathname);
      end
   end
else
   [filename, pathname] = uiputfile('*.m', 'Save Schematic (use valid MATLAB function name)');
   filespec = [pathname, filename];
   if filename == 0
      filename = myfilename;
      pathname = mypathname;
      cd(pathnamea);
      return
   else
      cd(pathname);
   end
end

if exist(filespec) == 2
  delete(filespec);
end

% filenamenewm = lower(filename);
filenamenewm = filename;
i1 = find(filenamenewm-'.'==0);
filenamenew = filenamenewm(1:i1-1);

diary(filespec);
disp(['function dr = ' filenamenew '(x0,y0,dx,ds,F,dc);             '])
disp(['%  ' filenamenewm '                                           '])
disp('%   Schematic generated by DrawFilt version 2.8                 ')
disp('%                                                               ')
disp('%   Authors: Prof. Dr Miroslav Lutovac, Prof. Dr Dejan Tosic    ')
disp('%   lutovac@kondor.etf.bg.ac.yu  http://kondor.etf.bg.ac.yu/~lutovac/')
disp('%   tosic@galeb.etf.bg.ac.yu     http://www.rcub.bg.ac.yu/~tosicde/')
disp('%                                                               ')
disp('%   Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic  ')
disp('%   $Revision: 2.8  $  $Date: 2005/03/04$                       ')
disp('%                                                               ')
disp('%   Reference:                                                  ')
disp('%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans         ')
disp('%        Filter Design for Signal Processing                    ')
disp('%           Using MATLAB and Mathematica                        ')
disp('%        Prentice Hall    ISBN 0-201-36130-2                    ') 
disp('%                                                               ')
disp(['% call   ' filenamenew '(0,0,4,5,9,''b'')                      '])
disp(['% call   ' filenamenew '                                       '])
timedraw = clock;
tmpstr = ['% creation date: ' date '  time: ' num2str(timedraw(4)) ':' num2str(timedraw(5))];
disp(tmpstr)
disp('%                                                                ')
disp('mydrawDrawFiltLutovacTosic = ''2p8''; % don''t edit this line')
disp('narginmydraw = nargin;')
disp('if narginmydraw ~= 6, x0=0; y0=0; dx=4; ds=5; F=9; dc=''b''; end,')
disp('Nx = 100; Ny = 100; whitebg(figure(gcf),[1 1 1]); ')
disp('x = (1:4*Nx)*dx/4 + x0; y = (1:4*Ny)*dx/4 + y0;')
[imatE1,imatE2] = size(matrixE);
if imatE1 >0
  matrixE(1,:)=[];
end
disp(matrixE)
disp('axis(''equal'')')
disp('axis(''off'')')
xs = matrixE;
diary  off

%cd(pathnamea);
