function dr = LCladder(x0,y0,dx,ds,F,dc);             
%  LCladder.m                                           
%   Schematic generated by DrawFilt version 2.8                 
%                                                               
%   Authors: Prof. Dr Miroslav Lutovac, Prof. Dr Dejan Tosic    
%   lutovac@kondor.etf.bg.ac.yu  http://kondor.etf.bg.ac.yu/~lutovac/
%   tosic@galeb.etf.bg.ac.yu     http://www.rcub.bg.ac.yu/~tosicde/
%                                                               
%   Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic  
%   $Revision: 2.8  $  $Date: 2005/03/04$                       
%                                                               
%   Reference:                                                  
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans         
%        Filter Design for Signal Processing                    
%           Using MATLAB and Mathematica                        
%        Prentice Hall    ISBN 0-201-36130-2                    
%                                                               
% call   LCladder(0,0,4,5,9,'b')                      
% call   LCladder                                       
% creation date: 05-Mar-2005  time: 1:26
%                                                                
mydrawDrawFiltLutovacTosic = '2p8'; % don't edit this line
narginmydraw = nargin;
if narginmydraw ~= 6, x0=0; y0=0; dx=4; ds=5; F=9; dc='b'; end,
Nx = 100; Ny = 100; whitebg(figure(gcf),[1 1 1]); 
x = (1:4*Nx)*dx/4 + x0; y = (1:4*Ny)*dx/4 + y0;
drawvs(x(5),y(5),y(10),' ','{\it V}_g',1,ds/2,F, dc);                             
drawres(x(5),y(10),x(10),' ','{\it R}_1',0,ds/2,F, dc);                           
drawcap(x(10),y(5),y(10),' ','{\it C}_1',3,ds/2,F, dc);                           
drawlnd(x(10),y(10),x(15),' ','{\it L}_1',0,ds/2,F, dc);                          
drawcap(x(15),y(5),y(10),' ','{\it C}_2',3,ds/2,F, dc);                           
drawlnd(x(15),y(10),x(20),' ','{\it L}_2',0,ds/2,F, dc);                          
drawres(x(20),y(5),y(10),' ','{\it R}_2',3,ds/2,F, dc);                           
drawline(x(5), y(5), x(20), y(5),dc);                                             
drawgrnd(x(5), y(5), 0, ds/2, dc);                                                
drawnode(x(5),y(10),'1',2,1,F, dc);                                               
drawnode(x(10),y(10),'2',2,1,F, dc);                                              
drawnode(x(15),y(10),'3',2,1,F, dc);                                              
drawnode(x(20),y(10),'4',2,1,F, dc);                                              
drawtext(x(13),y(14),'{\it LC}-ladder with {\bf resistive} terminations',F+1, dc);
drawin(x(5),y(10),'{\bf IN }',2,ds,F,dc);                                         
drawout(x(20),y(10),' {\bf  OUT}',0,ds,F,dc);                                     
drawpoly(x([9  19  19   9   9]),y([3   3  13  13   3]),'--',2,'m','none',0.5);    
axis('equal')
axis('off')
