function [mag,phase] = r2p(inval)
%R2P Convert a complex number in rectangular format to polar in degrees
% Function R2P converts either a complex number into a complex
% number in polar format, with the angle in degrees.
 
% Define variables:
%   inval     -- Input value in rectangular form
%   mag       -- Magnitude of number
%   phase     -- Phase of number, in degrees

%  Record of revisions:
%      Date       Programmer          Description of change
%      ====       ==========          =====================
%    12/12/99    S. J. Chapman        Original code

% Check for a legal number of input arguments.
msg = nargchk(1,1,nargin);
error(msg);

% Convert number
mag = abs(inval);
phase = angle(inval) * 180 / pi;