% M-file: ex8_3.m
% M-file to calculate the sending end voltage and current 
%   for a long transmission line.

% Initialize received voltage and per-length values
vr = 121000;
z  = (0.12 + j*0.88);       % Impedance per km
y  = j*4.1e-6;              % Admitance per km
l  = 140;                   % Length (km)

% Series reactance and shunt admittance
Z  = z * l;                 % Total series impedance (ohms)
Y  = y * l;                 % Total shunt admittance (S)

% Calculate gamma * length
gamma = sqrt(y*z);
gl = gamma * l; 

% Calculate ZP and YP
ZP = Z * sinh(gl) / gl;
YP = Y * tanh(gl/2) / (gl/2);

% Calculate ABCD constants
A = ZP*YP/2 + 1;
B = ZP;
C = YP * (ZP*YP/4 + 1);
D = ZP*YP/2 + 1;

% Calculate the sending end voltage
ir = p2r(412,-31.8);
vs = A * vr + B * ir;
[mag,phase] = r2p(vs);
disp(['vs    = ' num2str(mag) ' /_ ' num2str(phase) ' V']);
disp(['Vll,s = ' num2str(mag * sqrt(3))]);

% Calculate the sending end current
ir = p2r(412,-31.8);
is = C * vr + D * ir;
[mag,phase] = r2p(is);
disp(['is    = ' num2str(mag) ' /_ ' num2str(phase) ' A']);
