% M-file: ex9_3.m
% M-file to calculate the sending end voltage and current 
%   for a medium-length transmission line.

% Initialize received voltage, impedance, and admittance
vr = 121000;
z  = 16.8 + j*123.2;
y  = j*5.7400e-4;

% Calculate ABCD constants
A = z*y/2 + 1;
B = z;
C = y * (z*y/4 + 1);
D = z*y/2 + 1;

% Calculate the sending end voltage
ir = p2r(412,-31.8);
vs = A * vr + B * ir;
[mag,phase] = r2p(vs);
disp(['Vs    = ' num2str(mag) ' /_ ' num2str(phase) ' V']);
disp(['Vll,s = ' num2str(mag * sqrt(3))]);

% Calculate the sending end current
ir = p2r(412,-31.8);
is = C * vr + D * ir;
[mag,phase] = r2p(is);
disp(['Is    = ' num2str(mag) ' /_ ' num2str(phase) ' A']);
