% M-file: ex9_2.m
% M-file to calculate the sending end line-to-neutral voltage,
% line-to-lien votlage, and voltage regulation for a short 
% transmission line.  

% Initialize received voltage and line impedance
vr = 121000;
z  = 16.8 + j*123.2;

% Perform sending-end phase voltage calculation for 0.85 pf lagging 
il = p2r(412,-31.8);
vs = vr + il * z;
[mag,phase] = r2p(vs);
voltage_regulation = (abs(vs) - abs(vr)) / abs(vr) * 100;
disp(['0.85 PF lagging: Vs = ' num2str(mag) ' /_ ' num2str(phase)]);
disp(['              Vll,s = ' num2str(mag * sqrt(3))]);
disp(['                 VR = ' num2str(voltage_regulation) '%']);

% Perform sending-end phase voltage calculation for 1.0 pf 
il = p2r(412,0);
vs = vr + il * z;
[mag,phase] = r2p(vs);
voltage_regulation = (abs(vs) - abs(vr)) / abs(vr) * 100;
disp(['1.0  PF:         Vs = ' num2str(mag) ' /_ ' num2str(phase)]);
disp(['              Vll,s = ' num2str(mag * sqrt(3))]);
disp(['                 VR = ' num2str(voltage_regulation) '%']);

% Perform sending-end phase voltage calculation for 0.85 pf leading 
il = p2r(412,31.8);
vs = vr + il * z;
[mag,phase] = r2p(vs);
voltage_regulation = (abs(vs) - abs(vr)) / abs(vr) * 100;
disp(['0.85 PF leading: Vs = ' num2str(mag) ' /_ ' num2str(phase)]);
disp(['              Vll,s = ' num2str(mag * sqrt(3))]);
disp(['                 VR = ' num2str(voltage_regulation) '%']);
