% M-file: ex11_1.m
% M-file to solve the power-flow problem of Example 11-1.

% Set problem size and initial conditions
n_bus = 2;
swing_bus = 1;

% Create Y-bus
 Ybus = ...
[ 0.3846-j*1.9231 -0.3846+j*1.9231; ...
 -0.3846+j*1.9231  0.3846-j*1.9231];

% Initialize the real and reactive power supplied to the
% power system at each bus.  Note that the power at the 
% swing bus doesn't matter.
P(2) = -0.3;
Q(2) = -0.2;
         
% Initialize the bus voltages to 1.0 at 0 degrees
for ii = 1:n_bus
   Vbus(ii) = 1;
end

% Set convergence criterion
eps = 0.0001;

% Initialize the iteration counter
n_iter = 0;

% Create an infinite loop
while (1)
   
   % Increment the iteration count
   n_iter = n_iter + 1; 

   % Save old bus voltages for comparison purposes
   Vbus_old = Vbus;

   % Calculate the updated bus voltage
   for ii = 1:n_bus
   
      % Skip the slack bus!
      if ii ~= swing_bus
      
         % Calculate updated voltage at bus 'ii'.  First, sum
         % up the current contributions at bus 'ii' from all
         % other busses. 
         temp = 0;
         for jj = 1:n_bus
            if ii ~= jj
               temp = temp - Ybus(ii,jj) * Vbus_old(jj);
            end
         end
         
         % Add in the current injected at this node
         temp = (P(ii) - j*Q(ii)) / conj(Vbus_old(ii)) + temp;
         
         % Get updated estimate of Vbus at 'ii'
         Vbus(ii) = 1/Ybus(ii,ii) * temp;

         % Display iterations
         [mag, phase] = r2p(Vbus(ii));
         str = ['Iter ' int2str(n_iter) ': The voltage at bus ' ...
                 int2str(ii) ' = ' num2str(mag) '/' num2str(phase)];
         disp(str);
      end
   end
 
   % Compare the old and new estimate of the voltages.
   % Note that we will compare the real and the imag parts
   % separately, and both must be within tolerances.
   test = 0;
   for ii = 1:n_bus
   
      % Compare real parts
      if abs( real(Vbus(ii)) - real(Vbus_old(ii)) ) > eps
         test = 1;
      end
      
      % Compare imaginary parts
      if abs( imag(Vbus(ii)) - imag(Vbus_old(ii)) ) > eps
         test = 1;
      end
   end
   
   % Did we converge?  If so, get out of the loop.
   if test == 0
      break;
   end
end

% Display results
for ii = 1:n_bus
   [mag, phase] = r2p(Vbus(ii));
   str = ['The voltage at bus ' int2str(ii) ' = ' ... 
          num2str(mag) '/' num2str(phase)];
   disp(str);
end

% Display the number of iterations
str = ['Number of iterations = ' int2str(n_iter) ];
disp(str);

