function outval = p2r(mag,phase)
%p2r Convert a complex number in polar format to rectangluar
% Function p2r converts either a complex number in polar format
% with the angle in degrees into a complex number in rectangular
% format.
 
% Define variables:
%   mag       -- Magnitude of number
%   outval    -- Output value in rectangular form
%   phase     -- Phase of number, in degrees

%  Record of revisions:
%      Date       Programmer          Description of change
%      ====       ==========          =====================
%    12/12/99    S. J. Chapman        Original code

% Check for a legal number of input arguments.
msg = nargchk(2,2,nargin);
error(msg);

% Convert number
theta = phase * pi / 180;
outval = mag * ( cos(theta) + j*sin(theta) );
