% M-file: ex10_3.m
% M-file to calculate the per-unit bus voltage and the
%   current in line 1 in the power system of Example 9-3.

% Create Y-bus
Ybus = [-j*12.576    j*5.0         0         j*6.667;  ...
         j*5.0      -j*12.5      j*5.0       j*2.5;    ...
           0         j*5.0      -j*10.625    j*5.0;    ...
         j*6.667     j*2.5       j*5.0      -j*14.167];
         
% Create the current vector I
I = [ p2r(1.0,-80); ...
      0; ...
      p2r(0.563,-112); ...
      0];
      
% Calculate Vbus
Vbus = Ybus \ I;

% Display results
for ii = 1:4
   [mag, phase] = r2p(Vbus(ii));
   str = ['The voltage at bus ' int2str(ii) ' = ' ... 
          num2str(mag) '/' num2str(phase)];
   disp(str);
end

% Now calculate the current in line 1
i1 =  (Vbus(1) - Vbus(2)) * (-j*5.0);
[mag, phase] = r2p(i1);
str = ['The current in line 1 = ' num2str(mag) '/' num2str(phase)];
disp(str);

