/*
 * Decompiled with CFR 0.152.
 */
package matsubara.carcontroller;

import matsubara.carcontroller.CarController;
import matsubara.gear.EPlanetaryGear;
import matsubara.gear.Gear;
import matsubara.gear.PlanetaryCarrier;
import matsubara.gear.PlanetaryGear;

public class ThsController
extends CarController {
    PlanetaryGear m_planetaryGear;
    boolean m_bGasoline;
    boolean m_bMotor;
    boolean m_bKaisei;
    double m_rBatterySOC = 60.0;
    boolean m_bEngineRequest = false;
    boolean m_bPowerSaveMode = false;
    public static final int thsStop = 0;
    public static final int thsStopAndEngine = 1;
    public static final int thsStart = 2;
    public static final int thsNormal = 3;
    public static final int thsNormalOD = 4;
    public static final int thsFullAccel = 5;
    public static final int thsFullAccelOD = 6;
    public static final int thsKaisei = 7;
    public static final int thsKaiseiAndEngine = 8;
    public static final int thsBackAndEngine = 9;
    int m_nThsMode = 0;
    private final long m_nIgnitionUseTime = 2000L;

    public ThsController(int n, int n2, int n3) throws EPlanetaryGear {
        this.m_planetaryGear = new PlanetaryGear(n, n2, n3, 30, 23, 78, 4, 4);
        this.setFuel(50.0);
    }

    public void setShiftPosition(String string) {
        double d = this.getSpeed();
        if (string.equals("P")) {
            if (d == 0.0) {
                super.setShiftPosition(string);
            } else {
                super.setShiftPosition("N");
            }
        } else if (string.equals("R")) {
            if (d <= 3.0) {
                super.setShiftPosition(string);
            }
        } else if (string.equals("N")) {
            super.setShiftPosition(string);
        } else if ((string.equals("D") || string.equals("B")) && d >= -3.0) {
            super.setShiftPosition(string);
        }
    }

    protected void driveInternal(double d, int n, int n2) {
        String string = this.getShiftPosition();
        if (string.equals("D")) {
            this.driveInternal_D_B(d, n, n2);
        } else if (string.equals("B")) {
            this.driveInternal_D_B(d, n, n2);
        } else if (string.equals("R")) {
            this.driveInternal_R(d, n, n2);
        } else if (string.equals("P")) {
            this.driveInternal_P(d, n, n2);
        } else {
            this.driveInternal_N(d, n, n2);
        }
        this.m_bMotor = this.m_nThsMode == 2 || this.m_nThsMode == 5 || this.m_nThsMode == 6 || this.m_nThsMode == 9;
        this.m_bKaisei = this.m_nThsMode == 7 || this.m_nThsMode == 8;
        boolean bl = this.m_bGasoline = this.m_nThsMode == 5 || this.m_nThsMode == 6 || this.m_nThsMode == 3 || this.m_nThsMode == 4 || this.m_nThsMode == 1 || this.m_nThsMode == 9;
        if (this.m_rBatterySOC > 80.0) {
            this.m_rBatterySOC = 80.0;
        }
        if (!this.m_bEngineRequest && this.m_rBatterySOC < 45.0) {
            this.m_bEngineRequest = true;
        }
        if (this.m_rBatterySOC < 40.0) {
            this.m_bPowerSaveMode = true;
        }
        if (this.m_bEngineRequest && this.m_rBatterySOC >= 50.0) {
            this.m_bEngineRequest = false;
            this.m_bPowerSaveMode = false;
        }
    }

    private double engineRpm(double d, double d2) {
        double d3;
        if (this.getFuel() <= 0.0) {
            d = 0.0;
        }
        if ((d3 = this.m_planetaryGear.getPlaCarrierSpeed()) < d) {
            if ((d3 += d2 / 1000.0 * 1000.0) > d) {
                d3 = d;
            }
        } else if (d3 > d && (d3 -= d2 / 1000.0 * 2000.0) < d) {
            d3 = d;
        }
        return d3;
    }

    private void driveInternal_P(double d, int n, int n2) {
        long l;
        this.m_nThsMode = 0;
        double d2 = 0.0;
        if (n >= 5) {
            d2 = 1000 + n * 500 / 100;
        }
        if ((l = System.currentTimeMillis() - this.getIgnitionTime()) < 2000L) {
            d2 = 1100.0;
        } else if (l < 3000L) {
            d2 = 1050.0;
        } else if (l < 4000L) {
            d2 = 1000.0;
        }
        if (this.m_bEngineRequest) {
            if (d2 < 1250.0) {
                d2 = 1250.0;
            }
            d2 = 1250.0;
            this.m_nThsMode = 1;
            this.m_rBatterySOC += 1.0E-4 * d;
        }
        double d3 = this.engineRpm(d2, d);
        this.m_planetaryGear.setRingGearSpeed(0.0);
        this.m_planetaryGear.setPlaCarrierSpeed(d3);
        this.m_planetaryGear.move(d / 100.0);
    }

    private void driveInternal_R(double d, int n, int n2) {
        this.m_nThsMode = 0;
        double d2 = this.getSpeed();
        double d3 = -5.0 - (double)(n * 35 / 100);
        double d4 = 0.0;
        if (this.m_bEngineRequest) {
            if (d3 < -16.0) {
                d3 = -16.0;
            }
            d4 = 1200.0;
        }
        if (!this.m_bPowerSaveMode && this.m_bEngineRequest && d2 < -5.0) {
            d4 = 0.0;
        }
        if (this.getFuel() <= 0.0) {
            d4 = 0.0;
            d3 = this.m_rBatterySOC < 40.0 ? 0.0 : Math.max(d3, -16.0);
        }
        double d5 = this.engineRpm(d4, d);
        this.m_bMotor = true;
        this.m_nThsMode = 2;
        if (d2 > d3) {
            if ((d2 += (d3 - d2) * d / 1000.0 * 0.15) < d3) {
                d2 = d3;
            }
        } else {
            if ((d2 += 2.2 * d / 1000.0) > d3) {
                d2 = d3;
            }
            if (d2 < -10.0) {
                this.m_nThsMode = 7;
            }
        }
        if (d5 > 1000.0) {
            this.m_nThsMode = 9;
        }
        if (this.isParkingBrake() && n2 < 50) {
            n2 = 50;
        }
        if (n2 > 5) {
            if ((d2 += 0.25 * (double)n2 * d / 1000.0) > 0.0) {
                d2 = 0.0;
            }
            this.m_nThsMode = d2 < -10.0 ? 7 : 0;
        }
        if (d5 > 1000.0 && d2 == 0.0) {
            this.m_nThsMode = 1;
        }
        if (this.m_nThsMode == 2) {
            this.m_rBatterySOC -= d2 * -3.0E-6 * d;
        } else if (this.m_nThsMode == 7) {
            this.m_rBatterySOC += d2 * -1.0E-6 * d;
        } else if (this.m_nThsMode == 9) {
            this.m_rBatterySOC += 2.0E-6 * d;
        } else if (this.m_nThsMode == 1) {
            this.m_rBatterySOC += 1.0E-4 * d;
        }
        double d6 = 570.0;
        double d7 = d6 * Math.PI;
        double d8 = 3.927 / d6 / Math.PI / 60.0 * 1000.0 * 1000.0 * d2;
        this.m_planetaryGear.setRingGearSpeed(d8);
        this.m_planetaryGear.setPlaCarrierSpeed(d5);
        this.m_planetaryGear.move(d / 100.0);
    }

    private void driveInternal_N(double d, int n, int n2) {
        double d2 = this.getSpeed();
        if (d2 > 0.0) {
            d2 -= (1.4 + d2 / 100.0 * 1.5) * d / 1000.0 * 0.5;
            if ((d2 -= (0.2 + d2 / 100.0 * 0.8) * (double)n2 * d / 1000.0 * 0.5) < 0.0) {
                d2 = 0.0;
            }
        } else if (d2 < 0.0) {
            d2 += (1.4 - d2 / 100.0 * 1.5) * d / 1000.0 * 0.5;
            if ((d2 += (0.2 - d2 / 100.0 * 0.8) * (double)n2 * d / 1000.0 * 0.5) > 0.0) {
                d2 = 0.0;
            }
        }
        double d3 = 570.0;
        double d4 = d3 * Math.PI;
        double d5 = 3.927 / d3 / Math.PI / 60.0 * 1000.0 * 1000.0 * d2;
        this.m_planetaryGear.setRingGearSpeed(d5);
        this.m_planetaryGear.setPlaCarrierSpeed(0.0);
        this.m_planetaryGear.move(d / 100.0);
        this.m_nThsMode = 0;
    }

    private void driveInternal_D_B(double d, int n, int n2) {
        double d2;
        double d3;
        double d4 = this.getSpeed();
        double d5 = this.m_planetaryGear.getPlaCarrierSpeed();
        double d6 = 13.0 + (double)n * 1.6;
        double d7 = 0.0;
        double d8 = 45.0;
        double d9 = d3 = this.m_rBatterySOC >= 50.0 ? 20.0 : 10.0;
        if ((d4 >= d8 || d4 < d6 - d3) && n >= 10) {
            d7 = 1150.0 + (d6 - 40.0) * (d6 - 40.0) * 2850.0 / 10000.0;
            if (d7 > 4000.0) {
                d7 = 4000.0;
            }
            this.m_nThsMode = d5 >= 1000.0 ? 3 : 2;
        } else if (d4 >= 3.0 && d4 < 15.0 && d5 >= 1000.0) {
            d7 = 1150.0;
            this.m_nThsMode = 3;
        } else {
            d7 = 1000.0 + (d4 - 50.0) * 10.0;
            if (d4 < 45.0) {
                d7 = 0.0;
            }
            this.m_nThsMode = 2;
        }
        if (this.m_bPowerSaveMode) {
            if (n2 <= 5 || d4 < 15.0) {
                d7 = (d7 += 100.0) > 1250.0 ? d7 : 1250.0;
                double d10 = d7 = d7 < 4000.0 ? d7 : 4000.0;
            }
            if (d4 != 0.0) {
                this.m_nThsMode = 3;
            }
            if (d6 >= 140.0) {
                d6 = 140.0;
            }
        }
        if (this.getFuel() <= 0.0) {
            d7 = 0.0;
            if (this.m_rBatterySOC < 40.0) {
                d6 = 0.0;
                this.m_nThsMode = 0;
            } else {
                d6 = Math.min(d6, 45.0);
                this.m_nThsMode = 2;
            }
        }
        d5 = this.engineRpm(d7, d);
        if (d4 < d6) {
            d2 = 0.5 + (160.0 - d4) / 320.0;
            if (this.m_bPowerSaveMode) {
                d2 *= 0.9;
            }
            d4 = this.getShiftPosition().equals("D") ? (d4 += Math.pow(d6 - d4, 0.9) * d / 1000.0 * 0.12 * d2) : (d4 += Math.pow(d6 - d4, 0.9) * d / 1000.0 * 0.111 * d2);
            if (d4 > d6) {
                d4 = d6;
            }
            if (d4 < d6 - 15.0 || d6 > 140.0 || d5 == 0.0) {
                if (d5 >= 1000.0) {
                    if (!this.m_bPowerSaveMode) {
                        this.m_nThsMode = 5;
                    }
                } else {
                    this.m_nThsMode = 2;
                }
            }
        } else {
            d2 = 1.0;
            if (this.getShiftPosition().equals("B")) {
                d2 = 1.4;
            }
            if ((d4 -= (1.4 + d4 / 100.0 * 1.5) * d / 1000.0 * d2) < d6) {
                d4 = d6;
            }
            if (n == 0 && d4 > 15.0) {
                this.m_nThsMode = 7;
            }
        }
        if (this.isParkingBrake() && n2 < 50) {
            n2 = 50;
        }
        if (n2 > 5) {
            if ((d4 -= (0.2 + d4 / 100.0 * 0.8) * (double)n2 * d / 1000.0) < 0.0) {
                d4 = 0.0;
            }
            this.m_nThsMode = d4 > 10.0 ? 7 : 0;
        }
        if (this.m_nThsMode == 7 && d7 > 0.0) {
            this.m_nThsMode = 8;
        }
        if (this.m_nThsMode == 0 && d5 >= 1250.0) {
            this.m_nThsMode = 1;
        }
        d2 = 570.0;
        double d11 = d2 * Math.PI;
        double d12 = (int)(3.927 / d2 / Math.PI / 60.0 * 1000.0 * 1000.0 * d4);
        this.m_planetaryGear.setRingGearSpeed(d12);
        this.m_planetaryGear.setPlaCarrierSpeed(d5);
        if (this.m_planetaryGear.getSunGearSpeed() > 6000.0) {
            this.m_planetaryGear.setSunGearSpeed(6000.0);
        } else if (this.m_planetaryGear.getSunGearSpeed() < -4500.0) {
            this.m_planetaryGear.setSunGearSpeed(-4500.0);
        }
        if (this.m_nThsMode == 3 && this.m_planetaryGear.getSunGearSpeed() < 300.0) {
            this.m_nThsMode = 4;
        }
        if (this.m_nThsMode == 5 && this.m_planetaryGear.getSunGearSpeed() < 300.0) {
            this.m_nThsMode = 6;
        }
        this.m_planetaryGear.move(d / 100.0);
        switch (this.m_nThsMode) {
            case 2: 
            case 5: 
            case 6: {
                this.m_rBatterySOC -= d4 * 2.2E-6 * d + (d6 - d4) * 1.5E-6 * d;
                break;
            }
            case 7: 
            case 8: {
                this.m_rBatterySOC += (d4 - d6) * 1.0E-6 * d;
                break;
            }
            case 3: 
            case 4: {
                this.m_rBatterySOC += 3.0E-5 * d;
                break;
            }
            case 1: {
                this.m_rBatterySOC += 1.0E-4 * d;
                break;
            }
        }
    }

    public double getEngineRpm() {
        return this.m_planetaryGear.getPlaCarrierSpeed();
    }

    public double getSpeed() {
        double d = 570.0;
        double d2 = d * Math.PI;
        return this.m_planetaryGear.getRingGearSpeed() / 3.927 * d * Math.PI * 60.0 / 1000.0 / 1000.0;
    }

    public PlanetaryGear getPlanetaryGear() {
        return this.m_planetaryGear;
    }

    public int getThsMode() {
        return this.m_nThsMode;
    }

    public boolean isGasoline() {
        return this.m_bGasoline;
    }

    public boolean isMotor() {
        return this.m_bMotor;
    }

    public boolean isKaisei() {
        return this.m_bKaisei;
    }

    public Gear getRingGear() {
        return this.m_planetaryGear.getRingGear();
    }

    public PlanetaryCarrier getPlanetaryCarrier() {
        return this.m_planetaryGear.getPlanetaryCarrier();
    }

    public Gear getSunGear() {
        return this.m_planetaryGear.getSunGear();
    }

    public double getRingGearSpeed() {
        return this.m_planetaryGear.getRingGearSpeed();
    }

    public double getPlaCarrierSpeed() {
        return this.m_planetaryGear.getPlaCarrierSpeed();
    }

    public double getSunGearSpeed() {
        return this.m_planetaryGear.getSunGearSpeed();
    }

    public double getBatterySOC() {
        return this.m_rBatterySOC;
    }

    public boolean isEngineRequest() {
        return this.m_bEngineRequest;
    }

    public boolean isPowerSaveMode() {
        return this.m_bPowerSaveMode;
    }

    protected double getUseFuel(double d) {
        double d2 = 0.0;
        String string = this.getShiftPosition();
        if (this.isGasoline()) {
            double d3 = 1.0 + (this.m_rBatterySOC - 60.0) / 20.0 * 0.1;
            d2 = string.equals("D") || string.equals("R") ? Math.pow(this.getEngineRpm() / 1000.0, 1.4) * 1.7 / 3600.0 / 1000.0 * d / d3 : Math.pow(this.getEngineRpm() / 1000.0, 1.5) * 1.54 / 3600.0 / 1000.0 * d / d3;
        }
        return d2;
    }

    public boolean isReady() {
        return System.currentTimeMillis() - this.m_nIgnitionTime > 2000L;
    }
}

