%This MATLAB program generates a DSB/WC-AM signal and displays it in both the time and frequency % domain.

% First, generate a time vector of N discrete times.
N= 159;
dt = 0.0001*2*pi;
t = dt*(1:N);

% Generate the message signal m(t)=3sin(500t)
m =3*sin(500*t);

%Display the message signal
subplot(2,2,1),   plot(t,m),   title('The message signal m(t)'),grid

% Generate the carrier signal c(t)= 1cos(1500t)
c = cos(1500*t);

% Generate the amplitude modulated signal,    x(t) = [1 + km(t)]c(t),  using a modulation index of ka = 0.3
ka=0.3;
x = (1+ka*m).*c;


% Plot the DSB/WC-AM signal
subplot(2,2,2),   plot(t,x),    title('DSB/WC-AM Signal'),grid

% Use the fft function (explained in Chapter 12) to approximate the Fourier transform of the signals.
Mw = fft(m);
Cw = fft(c);
Xw = fft(x);

%Generate a frequency vector.
limw=20;
w = 2*pi*(0:2*limw)/(N*dt);
%
% Prepare the frequency spectra data for plotting (the magnitude is adjusted to 
% approximate the weight of the impulses in the Fourier Transform)
M= zeros(size(w));
X = zeros(size(w));
for n = 1:length(w)
	M(n) = 2/N*pi*abs(Mw(n));
	X(n) = 2/N*pi*abs(Xw(n));
end


% Display the magnitude frequency spectrum of m(t).
subplot(2,2,3),  stem(w,M),   xlabel('Frequency Spectrum of m(t)'),grid

% Display the magnitude frequency spectrum of x(t).
subplot(2,2,4),   stem(w,X),  xlabel('Frequency Spectrum of DSB/WC signal)'),grid


