
    % This MATLAB program generates an Elliptic filter 
    % of specified order.  The magnitude frequency response 
    % is displayed.

    N=input...
         ('Specify the order of the filter:')
    Rp=input...
         ('Specify passband ripple magnitude in dB. ')
    Rs=input...
         ('Specify stopband ripple in dB below passband gain.')

    z_p_k='The zeros, poles and multiplying constant.'
    [z,p,k] = ellipap(N,Rp,Rs),pause

    num_den='The numerator and denominator coefficients.'
    [num,den]=zp2tf(z,p,k),pause

    [mag,phase,w] = bode(num,den);

    plot(w,mag)
    title(['Elliptic filter frequency response.  Order ',... 
              num2str(N),' Rp=',num2str(Rp),...
              'dB  Rs= -',num2str(Rs),'dB'])
    xlabel('omega')
    ylabel('Magnitude')

