%       This program compares the freqency spectra of rectangular pulses.
%       The pulse width is selected by the user.
%
d1 = input('Type in the desired pulse width for the first pulse in seconds.  ')
d2 = input('Type in the desired pulse width for the second pulse in seconds.  ')
%
%       Limit the time vector to twice the duration of the widest pulse.
%
tlim = max([d1 d2]);
%
%       Make the time step 1/1000 the maximum time.
%
        dt = 2*tlim/1000;
%
%       Create the time vector.
%
        t = [-tlim:dt:tlim];
%
%       Create the pulse vectors.
%
p1=zeros(size(t));
p2=zeros(size(t));
w1 = d1/dt;
w2 = d2/dt;
for n = 501-round(w1/2):501+round(w1/2);
        p1(n) = 1;
end
for n = 501-round(w2/2):501+round(w2/2)
        p2(n) = 1;
end
%
%       Plot the two pulses.
%
subplot(2,2,1),plot(t,p1), xlabel('time (s)'),ylabel('first pulse')
subplot(2,2,2),plot(t,p2,'g'),xlabel('time (s)'),ylabel('second pulse')
        ylabel('second pulse'),
%
%       Approximate the Fourier transform of each pulse using the fft function.
%
F1=fft(p1);
F2=fft(p2);
%
%       Create a vector of frequency values.
%
wlim =round(3*1001*dt/min([d1 d2]));
w = (2*pi/(1001*dt))*[-wlim:1:wlim];
%
%       Prepare to plot the magnitudes of the Fourier transform approximations.
%
P1 = zeros(size(w));
P2 = zeros(size(w));
mid = fix(length(w)/2);
%
for n = 1:mid;
        P1(n+mid) = F1(n);
        P2(n+mid) = F2(n);
        P1(mid+1-n)  = F1(n);
        P2(mid+1-n)  = F2(n);
end
%
P1p=dt*abs(P1);
P2p=dt*abs(P2);
%
%       Plot the magnitude frequency spectra of the two pulses.
%
subplot(2,2,3), plot(w,P1p), xlabel('Frequency (rad/s)')
subplot(2,2,4), plot(w,P2p,'g'),xlabel('Frequency (rad/s)')


